/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.RemoteDockerRuntimeUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.scratch.DockerRootType;
import com.intellij.docker.view.DockerFileChooser;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.PopupHandler;
import com.intellij.util.Function;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerContainerBrowser
extends JPanel
implements Disposable {
    private static final String TOOLBAR_PLACE = "DockerContainerBrowser#Toolbar";
    private static final String POPUP_PLACE = "DockerContainerBrowser#Popup";
    private static final Logger LOG = Logger.getInstance(DockerContainerBrowser.class);
    private final Project myProject;
    private final DockerApplicationRuntime myApplicationRuntime;
    private final DockerFileChooser myFileChooser;

    public DockerContainerBrowser(@NotNull Project project, @NotNull DockerApplicationRuntime applicationRuntime, @NotNull Host host) {
        if (project == null) {
            DockerContainerBrowser.$$$reportNull$$$0(0);
        }
        if (applicationRuntime == null) {
            DockerContainerBrowser.$$$reportNull$$$0(1);
        }
        if (host == null) {
            DockerContainerBrowser.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myProject = project;
        this.myApplicationRuntime = applicationRuntime;
        this.myFileChooser = new DockerFileChooser(this.myProject, this.myApplicationRuntime, true, () -> this.init(host));
        this.setBorder((Border)JBUI.Borders.empty());
        this.add((Component)((Object)this.myFileChooser), "Center");
        Disposer.register((Disposable)this, (Disposable)this.myFileChooser);
    }

    private void init(@NotNull Host host) {
        if (host == null) {
            DockerContainerBrowser.$$$reportNull$$$0(3);
        }
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        JTree tree = this.myFileChooser.getTree();
        DownloadAction downloadAction = new DownloadAction();
        ViewInEditorAction viewInEditorAction = new ViewInEditorAction();
        DefaultActionGroup toolbarActions = new DefaultActionGroup(new AnAction[]{this.myFileChooser.createRefreshAction(), CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)new DefaultTreeExpander(tree), (JComponent)tree), new Separator(), downloadAction, viewInEditorAction});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(TOOLBAR_PLACE, (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent((JComponent)tree);
        DefaultActionGroup popupActions = new DefaultActionGroup(new AnAction[]{downloadAction, viewInEditorAction});
        PopupHandler.installPopupHandler((JComponent)tree, (ActionGroup)popupActions, (String)POPUP_PLACE);
        this.myFileChooser.addOkAction(this::viewInEditor);
        this.add((Component)toolbar.getComponent(), "East");
        host.setActions((ActionGroup)toolbarActions, TOOLBAR_PLACE, tree);
    }

    public void dispose() {
    }

    private boolean hasSelectedFiles() {
        return this.myFileChooser.getSelectedFiles().length > 0;
    }

    private void download() {
        final List<String> selectedPaths = this.myFileChooser.getSelectedPaths();
        if (!selectedPaths.isEmpty()) {
            Task.Backgroundable downloadInBackground = new Task.Backgroundable(this.myProject, DockerBundle.message("DockerContainerBrowser.downloadTask.title", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DockerContainerBrowser.this.download(selectedPaths);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/view/DockerContainerBrowser$1", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)downloadInBackground);
        }
    }

    private void download(@NotNull List<String> selectedPaths) {
        if (selectedPaths == null) {
            DockerContainerBrowser.$$$reportNull$$$0(4);
        }
        LinkedList<String> sourcePaths = new LinkedList<String>();
        for (String selectedPath : selectedPaths) {
            boolean addToSource = true;
            Iterator sourcePathsIterator = sourcePaths.iterator();
            while (sourcePathsIterator.hasNext()) {
                String sourcePath = (String)sourcePathsIterator.next();
                if (selectedPath.startsWith(sourcePath + "/")) {
                    addToSource = false;
                    break;
                }
                if (!sourcePath.startsWith(selectedPath + "/")) continue;
                sourcePathsIterator.remove();
            }
            if (!addToSource) continue;
            sourcePaths.add(selectedPath);
        }
        File targetDirectory = this.doDownload(sourcePaths);
        VirtualFile targetFile = DockerContainerBrowser.getTargetFile(LocalFileSystem.getInstance(), targetDirectory, selectedPaths.get(0));
        if (targetFile != null) {
            ApplicationManager.getApplication().invokeLater(() -> Objects.requireNonNull(ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Project")).activate(() -> {
                ProjectView projectView = ProjectView.getInstance((Project)this.myProject);
                projectView.changeView("ProjectPane");
                projectView.select(null, targetFile, true);
            }));
        }
    }

    @NotNull
    private File doDownload(@NotNull List<String> sourcePaths) {
        if (sourcePaths == null) {
            DockerContainerBrowser.$$$reportNull$$$0(5);
        }
        File targetDirectory = new File(FileUtil.toSystemDependentName((String)(ScratchFileService.getInstance().getRootPath((RootType)DockerRootType.getInstance()) + "/" + this.myFileChooser.getSanitizedContainerName())));
        for (String sourcePath : sourcePaths) {
            this.download(sourcePath, targetDirectory);
        }
        VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
        File file2 = targetDirectory;
        if (file2 == null) {
            DockerContainerBrowser.$$$reportNull$$$0(6);
        }
        return file2;
    }

    private void download(@NotNull String sourcePath, @NotNull File targetDirectory) {
        if (sourcePath == null) {
            DockerContainerBrowser.$$$reportNull$$$0(7);
        }
        if (targetDirectory == null) {
            DockerContainerBrowser.$$$reportNull$$$0(8);
        }
        try {
            RemoteDockerRuntimeUtil.download(this.myApplicationRuntime.getAgentApplication(), this.myApplicationRuntime.getAgentTaskExecutor(), sourcePath, targetDirectory, (Function<String, String>)((Function)DockerContainerBrowser::toRelativeLocalPath), null);
        }
        catch (ServerRuntimeException | IOException ex) {
            LOG.debug(ex);
        }
    }

    @NotNull
    private static String toRelativeLocalPath(@NotNull String remotePath) {
        if (remotePath == null) {
            DockerContainerBrowser.$$$reportNull$$$0(9);
        }
        String string = FileUtil.toSystemDependentName((String)remotePath.substring(1));
        if (string == null) {
            DockerContainerBrowser.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static VirtualFile getTargetFile(@NotNull LocalFileSystem localFileSystem, @NotNull File targetDirectory, @NotNull String sourcePath) {
        if (localFileSystem == null) {
            DockerContainerBrowser.$$$reportNull$$$0(11);
        }
        if (targetDirectory == null) {
            DockerContainerBrowser.$$$reportNull$$$0(12);
        }
        if (sourcePath == null) {
            DockerContainerBrowser.$$$reportNull$$$0(13);
        }
        return localFileSystem.refreshAndFindFileByIoFile(new File(targetDirectory, DockerContainerBrowser.toRelativeLocalPath(sourcePath)));
    }

    private boolean hasOnlyFilesSelected() {
        return DockerContainerBrowser.hasOnlyFilesSelected(this.myFileChooser.getSelectedFiles());
    }

    private static boolean hasOnlyFilesSelected(VirtualFile @NotNull [] selectedFiles) {
        if (selectedFiles == null) {
            DockerContainerBrowser.$$$reportNull$$$0(14);
        }
        if (selectedFiles.length <= 0) {
            return false;
        }
        for (VirtualFile selectedFile : selectedFiles) {
            if (!selectedFile.isDirectory()) continue;
            return false;
        }
        return true;
    }

    private void viewInEditor() {
        Object[] selectedFiles = this.myFileChooser.getSelectedFiles();
        if (DockerContainerBrowser.hasOnlyFilesSelected((VirtualFile[])selectedFiles)) {
            OpenSourceUtil.navigate((boolean)true, (boolean)true, (Iterable)ContainerUtil.map((Object[])selectedFiles, selectedFile -> new OpenFileDescriptor(this.myProject, selectedFile)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRuntime";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPaths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePaths";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/view/DockerContainerBrowser";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileSystem";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/view/DockerContainerBrowser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doDownload";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toRelativeLocalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doDownload";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toRelativeLocalPath";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTargetFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyFilesSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ViewInEditorAction
    extends DumbAwareAction {
        ViewInEditorAction() {
            super(DockerBundle.messagePointer("DockerContainerBrowser.ViewInEditorAction.text", new Object[0]), DockerBundle.messagePointer("DockerContainerBrowser.ViewInEditorAction.description", new Object[0]), AllIcons.Actions.Preview);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ViewInEditorAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(DockerContainerBrowser.this.hasOnlyFilesSelected());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ViewInEditorAction.$$$reportNull$$$0(1);
            }
            DockerContainerBrowser.this.viewInEditor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/docker/view/DockerContainerBrowser$ViewInEditorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DownloadAction
    extends DumbAwareAction {
        DownloadAction() {
            super(DockerBundle.messagePointer("DockerContainerBrowser.DownloadAction.text", new Object[0]), DockerBundle.messagePointer("DockerContainerBrowser.DownloadAction.description", new Object[0]), AllIcons.Actions.Download);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DownloadAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(DockerContainerBrowser.this.hasSelectedFiles());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DownloadAction.$$$reportNull$$$0(1);
            }
            DockerContainerBrowser.this.download();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/docker/view/DockerContainerBrowser$DownloadAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Host {
        public void setActions(@Nullable ActionGroup var1, @Nullable String var2, @Nullable JComponent var3);
    }
}

