/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.vfs;

import com.intellij.docker.RemoteDockerRuntimeUtil;
import com.intellij.docker.TarCompressionUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableConsumer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerFileSystem
extends NewVirtualFileSystem
implements NonPhysicalFileSystem,
Disposable {
    private static final String PROTOCOL = "docker";
    private static final Pattern LS_ENTRY_PATTERN = Pattern.compile("^([-dl])(?:.{9})(?: +)(?:\\d+)(?: +)(\\d+) (\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{9}[+\\-]\\d{2}:\\d{2}) (.+)$");
    private static final String SYMLINK_DELIMITER = "\" -> \"";
    private static final Logger LOG = Logger.getInstance(DockerFileSystem.class);
    private static final Map<String, Map<String, Ref<Entry>>> ourEntries = new ConcurrentHashMap<String, Map<String, Ref<Entry>>>();
    private final DockerApplicationRuntime myRuntime;
    private volatile boolean disposed;

    public DockerFileSystem(@NotNull DockerApplicationRuntime runtime) {
        if (runtime == null) {
            DockerFileSystem.$$$reportNull$$$0(0);
        }
        this.myRuntime = runtime;
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(1);
        }
        return this.disposed ? null : VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        if (normalizedPath == null) {
            DockerFileSystem.$$$reportNull$$$0(2);
        }
        return DockerFileSystem.extractRootPathImpl(normalizedPath);
    }

    @NotNull
    private static String extractRootPathImpl(@NotNull String normalizedPath) {
        int index;
        if (normalizedPath == null) {
            DockerFileSystem.$$$reportNull$$$0(3);
        }
        String string = (index = normalizedPath.indexOf(47)) < 0 ? normalizedPath : normalizedPath.substring(0, index);
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(4);
        }
        return string;
    }

    public int getRank() {
        return 1;
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(5);
        }
        if (newParent == null) {
            DockerFileSystem.$$$reportNull$$$0(6);
        }
        if (copyName == null) {
            DockerFileSystem.$$$reportNull$$$0(7);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    @NotNull
    private static IOException createModificationNotSupportedError(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(8);
        }
        return new IOException(DockerBundle.message("DockerFileSystem.error.modification.not.supported", file2.getUrl()));
    }

    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        byte[] byArray;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(9);
        }
        if (this.disposed || this.myRuntime.getStatus() != DeploymentStatus.DEPLOYED || file2.isDirectory() || file2.is(VFileProperty.SYMLINK)) {
            throw DockerFileSystem.createGettingContentsError(file2);
        }
        try {
            Ref contents = Ref.create();
            RemoteDockerRuntimeUtil.download(this.myRuntime.getAgentApplication(), this.myRuntime.getAgentTaskExecutor(), this.getPathInsideContainer(file2), null, (ThrowableConsumer<? super File, ? extends IOException>)((ThrowableConsumer)tarFile -> {
                try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream(TarCompressionUtil.decompressStream(new BufferedInputStream(new FileInputStream((File)tarFile))));){
                    TarArchiveEntry tarEntry = tarInputStream.getNextTarEntry();
                    if (tarEntry != null && tarEntry.getName().equals(file2.getName()) && tarEntry.isFile()) {
                        contents.set((Object)FileUtil.loadBytes((InputStream)tarInputStream));
                    }
                }
            }));
            if (contents.isNull()) {
                throw DockerFileSystem.createGettingContentsError(file2);
            }
            byArray = (byte[])contents.get();
        }
        catch (ServerRuntimeException e) {
            throw DockerFileSystem.createGettingContentsError(file2, e);
        }
        if (byArray == null) {
            DockerFileSystem.$$$reportNull$$$0(10);
        }
        return byArray;
    }

    @NotNull
    private static IOException createGettingContentsError(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(11);
        }
        return DockerFileSystem.createGettingContentsError(file2, null);
    }

    @NotNull
    private static IOException createGettingContentsError(@NotNull VirtualFile file2, @Nullable Throwable cause) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(12);
        }
        return new IOException(DockerBundle.message("DockerFileSystem.error.can.not.get.contents", file2.getUrl()), cause);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(13);
        }
        throw new IOException("Not implemented yet");
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file2, Object requestor, long modStamp, long l) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(14);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    public long getLength(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(15);
        }
        return (attributes = this.getAttributes(file2)) != null ? attributes.length : 0L;
    }

    public boolean exists(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(16);
        }
        return this.getAttributes(file2) != null;
    }

    public String @NotNull [] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(17);
        }
        if (this.disposed) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                DockerFileSystem.$$$reportNull$$$0(18);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String path = this.getPathInsideContainer(file2);
        String joinedEntries = this.execLs('A', path);
        if (joinedEntries == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                DockerFileSystem.$$$reportNull$$$0(19);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        Object pathWithSlash = "/".equals(path) ? path : path + "/";
        Map<String, Ref<Entry>> entries = DockerFileSystem.getRootEntries(file2);
        ArrayList<String> names = new ArrayList<String>();
        for (String entry : StringUtil.splitByLinesDontTrim((String)joinedEntries)) {
            Pair<String, Entry> parsedEntry = DockerFileSystem.parseLsEntry(entry);
            if (parsedEntry == null) continue;
            names.add((String)parsedEntry.first);
            entries.put((String)pathWithSlash + (String)parsedEntry.first, (Ref<Entry>)Ref.create((Object)((Entry)parsedEntry.second)));
        }
        String[] stringArray = ArrayUtilRt.toStringArray(names);
        if (stringArray == null) {
            DockerFileSystem.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    @Nullable
    private String execLs(char flag, @NotNull String pathInsideContainer) {
        if (pathInsideContainer == null) {
            DockerFileSystem.$$$reportNull$$$0(21);
        }
        if (this.myRuntime.getStatus() != DeploymentStatus.DEPLOYED) {
            return null;
        }
        try {
            CompletableFuture<byte[]> outputFuture = this.myRuntime.captureExecOutput(new String[]{"ls", "-" + flag + "lgoQ", "--time-style=+%Y-%m-%dT%H:%M:%S.%N%:z", "--tabsize=0", "--width=1", pathInsideContainer}, false);
            if (outputFuture == null) {
                return null;
            }
            byte[] output = outputFuture.get();
            if (output == null) {
                return null;
            }
            return new String(output, StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            LOG.warn(t);
            return null;
        }
    }

    @Nullable
    private static Pair<String, Entry> parseLsEntry(@NotNull String entry) {
        long timestamp;
        long size;
        int delimiter;
        String nameAndTarget;
        Matcher matcher;
        if (entry == null) {
            DockerFileSystem.$$$reportNull$$$0(22);
        }
        if (!(matcher = LS_ENTRY_PATTERN.matcher(entry)).find()) {
            return null;
        }
        String flags = matcher.group(1);
        char kind = flags.charAt(0);
        boolean directory = kind == 'd';
        boolean symlink = kind == 'l';
        String name = nameAndTarget = matcher.group(4);
        String target = null;
        if (symlink && (delimiter = nameAndTarget.indexOf(SYMLINK_DELIMITER)) > 0) {
            name = nameAndTarget.substring(0, delimiter + 1);
            target = nameAndTarget.substring(delimiter + SYMLINK_DELIMITER.length() - 1);
            target = DockerFileSystem.unquote(target);
        }
        name = DockerFileSystem.unquote(name);
        try {
            size = Long.parseLong(matcher.group(2));
        }
        catch (NumberFormatException e) {
            return null;
        }
        try {
            timestamp = OffsetDateTime.parse(matcher.group(3)).toInstant().toEpochMilli();
        }
        catch (DateTimeParseException e) {
            return null;
        }
        return Pair.create((Object)name, (Object)new Entry(new FileAttributes(directory, false, symlink, false, size, timestamp, false, FileAttributes.CaseSensitivity.SENSITIVE), target));
    }

    @NotNull
    private static String unquote(@NotNull String quoted) {
        if (quoted == null) {
            DockerFileSystem.$$$reportNull$$$0(23);
        }
        String string = StringUtil.unescapeStringCharacters((String)StringUtil.unquoteString((String)quoted, (char)'\"'));
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static Map<String, Ref<Entry>> getRootEntries(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(25);
        }
        Map map2 = ourEntries.computeIfAbsent(DockerFileSystem.extractRootPath(file2), rootPath -> new ConcurrentHashMap());
        if (map2 == null) {
            DockerFileSystem.$$$reportNull$$$0(26);
        }
        return map2;
    }

    @NotNull
    private static String extractRootPath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(27);
        }
        return DockerFileSystem.extractRootPathImpl(file2.getPath());
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(28);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isDirectory();
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(29);
        }
        return (attributes = this.getAttributes(file2)) != null ? attributes.lastModified : 0L;
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(30);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(31);
        }
        return false;
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(32);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            DockerFileSystem.$$$reportNull$$$0(33);
        }
        if (dir == null) {
            DockerFileSystem.$$$reportNull$$$0(34);
        }
        throw DockerFileSystem.createModificationNotSupportedError(parent);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        if (parent == null) {
            DockerFileSystem.$$$reportNull$$$0(35);
        }
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(36);
        }
        throw DockerFileSystem.createModificationNotSupportedError(parent);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(37);
        }
        return this.disposed ? null : VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(38);
        }
        String string = path;
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(39);
        }
        return string;
    }

    public void refresh(boolean asynchronous) {
        this.refresh(asynchronous, null);
    }

    public void refresh(boolean asynchronous, @Nullable Runnable finishRunnable) {
        if (this.disposed) {
            return;
        }
        ourEntries.remove(this.getRootPath());
        this.processRoots(roots -> {
            RefreshQueue.getInstance().refresh(asynchronous, true, finishRunnable, roots);
            VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])roots);
        });
    }

    @NotNull
    private String getRootPath() {
        String string = FileUtil.sanitizeFileName((String)Objects.requireNonNull(this.myRuntime.getServer()).getName(), (boolean)false) + ":" + this.myRuntime.getContainerId() + ":/";
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(40);
        }
        return string;
    }

    private void processRoots(@NotNull Consumer<VirtualFile[]> rootsProcessor) {
        VirtualFile[] roots;
        if (rootsProcessor == null) {
            DockerFileSystem.$$$reportNull$$$0(41);
        }
        if ((roots = ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this)).length > 0) {
            rootsProcessor.accept(roots);
        }
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(42);
        }
        return this.disposed ? null : VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(43);
        }
        if (requestor != this) {
            throw DockerFileSystem.createModificationNotSupportedError(file2);
        }
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(44);
        }
        if (newParent == null) {
            DockerFileSystem.$$$reportNull$$$0(45);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(46);
        }
        if (newName == null) {
            DockerFileSystem.$$$reportNull$$$0(47);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(48);
        }
        Entry entry = this.disposed ? null : this.getEntry(file2);
        return entry != null ? entry.attributes : null;
    }

    @Nullable
    private Entry getEntry(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(49);
        }
        return (Entry)DockerFileSystem.getRootEntries(file2).computeIfAbsent(this.getPathInsideContainer(file2), path -> {
            Pair<String, Entry> parsedEntry;
            String entry = this.execLs('d', (String)path);
            if (entry != null && (parsedEntry = DockerFileSystem.parseLsEntry(entry)) != null) {
                return Ref.create((Object)((Entry)parsedEntry.second));
            }
            return Ref.create();
        }).get();
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(50);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isSymLink();
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        String target;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(51);
        }
        if (this.disposed) {
            return null;
        }
        Entry entry = this.getEntry(file2);
        String string = target = entry != null ? entry.target : null;
        if (target == null || target.contains(":")) {
            return null;
        }
        if (target.startsWith("/")) {
            return DockerFileSystem.extractRootPath(file2) + target;
        }
        List pathComponents = StringUtil.split((String)this.getPathInsideContainer(file2), (String)"/");
        ArrayList<String> resolvedComponents = pathComponents.size() < 2 ? new ArrayList<String>() : new ArrayList(pathComponents.subList(0, pathComponents.size() - 1));
        for (String targetComponent : StringUtil.split((String)target, (String)"/")) {
            if ("..".equals(targetComponent)) {
                if (resolvedComponents.isEmpty()) {
                    return null;
                }
                resolvedComponents.remove(resolvedComponents.size() - 1);
                continue;
            }
            if (".".equals(targetComponent)) continue;
            resolvedComponents.add(targetComponent);
        }
        return DockerFileSystem.extractRootPath(file2) + "/" + StringUtil.join(resolvedComponents, (String)"/");
    }

    public void dispose() {
        this.disposed = true;
        this.processRoots(roots -> ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile root : roots) {
                try {
                    root.delete((Object)this);
                }
                catch (Throwable t) {
                    LOG.warn(t);
                }
            }
        }));
    }

    @Nullable
    public VirtualFile getRoot() {
        VirtualFile root = this.findFileByPath(this.getRootPath());
        if (root != null) {
            VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
        }
        return root;
    }

    @NotNull
    public String getPathInsideContainer(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(52);
        }
        return DockerFileSystem.getPathInsideContainer(file2.getPath());
    }

    @NotNull
    private static String getPathInsideContainer(@NotNull String path) {
        int index;
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(53);
        }
        String pathInsideContainer = (index = path.indexOf(47)) < 0 ? "" : path.substring(index);
        String string = pathInsideContainer.isEmpty() ? "/" : pathInsideContainer;
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getSanitizedContainerName() {
        String containerName = this.myRuntime.getContainerName();
        if (containerName == null) {
            return "";
        }
        String string = FileUtil.sanitizeFileName((String)StringUtil.trimStart((String)containerName, (String)"/"), (boolean)false);
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(55);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 39: 
            case 40: 
            case 54: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 39: 
            case 40: 
            case 54: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 1: 
            case 37: 
            case 38: 
            case 42: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 4: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 39: 
            case 40: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/vfs/DockerFileSystem";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInsideContainer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsProcessor";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/vfs/DockerFileSystem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPathImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootEntries";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathInsideContainer";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getSanitizedContainerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 2: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPathImpl";
                break;
            }
            case 4: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 39: 
            case 40: 
            case 54: 
            case 55: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createModificationNotSupportedError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createGettingContentsError";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "execLs";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseLsEntry";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRootEntries";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processRoots";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getEntry";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getPathInsideContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 39: 
            case 40: 
            case 54: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Entry {
        @NotNull
        public final FileAttributes attributes;
        @Nullable
        public final String target;

        Entry(@NotNull FileAttributes attributes, @Nullable String target) {
            if (attributes == null) {
                Entry.$$$reportNull$$$0(0);
            }
            this.attributes = attributes;
            this.target = target;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/docker/vfs/DockerFileSystem$Entry", "<init>"));
        }
    }
}

