/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.settings.DockerLinkConfigurable;
import com.intellij.docker.settings.TableWithCardEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.util.Column;
import org.jetbrains.annotations.Nls;

public class DockerLinksEditor
extends TableWithCardEditor<DockerLinkImpl, ColumnBase> {
    private final RemoteServer myServer;

    public DockerLinksEditor(RemoteServer server) {
        super((Column[])new ColumnBase[]{new NameColumn(), new AliasColumn()});
        this.myServer = server;
    }

    @Override
    protected DockerLinkImpl createItem() {
        return new DockerLinkImpl();
    }

    @Override
    protected DockerLinkImpl cloneItem(DockerLinkImpl item) {
        return new DockerLinkImpl((DockerLink)item);
    }

    @Override
    protected Configurable createItemConfigurable(DockerLinkImpl item) {
        return new DockerLinkConfigurable(item, this.myServer);
    }

    private static class AliasColumn
    extends ColumnBase {
        AliasColumn() {
            super(DockerBundle.message("DockerLinksEditor.AliasColumn.title", new Object[0]));
        }

        public Object getColumnValue(DockerLinkImpl row) {
            return row.getAlias();
        }
    }

    private static class NameColumn
    extends ColumnBase {
        NameColumn() {
            super(DockerBundle.message("DockerLinksEditor.NameColumn.title", new Object[0]));
        }

        public Object getColumnValue(DockerLinkImpl row) {
            return row.getName();
        }
    }

    public static abstract class ColumnBase
    extends Column<DockerLinkImpl> {
        public ColumnBase(@Nls String name) {
            super(name);
        }
    }
}

