/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntimeBase;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRuntimeComparator
implements Comparator<DockerDeploymentRuntimeBase> {
    @Override
    public int compare(DockerDeploymentRuntimeBase r1, DockerDeploymentRuntimeBase r2) {
        DockerRuntimeCategory category2;
        if (r1 == r2) {
            return 0;
        }
        if (r1 == null || r2 == null) {
            return r1 == null ? -1 : 1;
        }
        DockerRuntimeCategory category1 = DockerRuntimeComparator.getCategory(r1);
        int compareCategories = category1.compareTo(category2 = DockerRuntimeComparator.getCategory(r2));
        if (compareCategories != 0) {
            return compareCategories;
        }
        assert (category1 == category2);
        return category1.compare(r1, r2);
    }

    private static DockerRuntimeCategory getCategory(DockerDeploymentRuntimeBase runtime) {
        if (runtime instanceof ComposeApplicationRuntime) {
            return DockerRuntimeCategory.COMPOSE_APPS;
        }
        if (runtime instanceof DockerGroupRuntime.ContainersGroup) {
            return DockerRuntimeCategory.GROUP_CONTAINERS;
        }
        if (runtime instanceof DockerGroupRuntime.ImagesGroup) {
            return DockerRuntimeCategory.GROUP_IMAGES;
        }
        if (runtime instanceof DockerGroupRuntime) {
            return DockerRuntimeCategory.GROUP_UNKNOWN;
        }
        if (runtime instanceof ComposeServiceRuntime) {
            return DockerRuntimeCategory.COMPOSE_SERVICES;
        }
        if (runtime instanceof DockerApplicationRuntime) {
            if (((DockerApplicationRuntime)runtime).getContainerId() != null) {
                return DockerRuntimeCategory.CONTAINERS;
            }
            if (((DockerApplicationRuntime)runtime).getImageId() != null) {
                return DockerRuntimeCategory.IMAGES;
            }
        }
        return DockerRuntimeCategory.UNKNOWNS;
    }

    private static int compareIdentity(@Nullable Object o1, @Nullable Object o2) {
        return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
    }

    private static enum DockerRuntimeCategory {
        COMPOSE_APPS{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                if (rt1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ComposeApplicationRuntime impl1 = (ComposeApplicationRuntime)rt1;
                ComposeApplicationRuntime impl2 = (ComposeApplicationRuntime)rt2;
                return StringUtil.compare((String)impl1.getComposeProjectName(), (String)impl2.getComposeProjectName(), (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$1";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        GROUP_CONTAINERS,
        GROUP_IMAGES,
        GROUP_UNKNOWN,
        COMPOSE_SERVICES{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                if (rt1 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                ComposeServiceRuntime impl1 = (ComposeServiceRuntime)rt1;
                ComposeServiceRuntime impl2 = (ComposeServiceRuntime)rt2;
                int parentCompare = this.compareParents(impl1.getParent(), impl2.getParent());
                if (parentCompare != 0) {
                    return parentCompare;
                }
                return StringUtil.compare((String)impl1.getServiceName(), (String)impl2.getServiceName(), (boolean)false);
            }

            private int compareParents(@Nullable ComposeApplicationRuntime parent1, @Nullable ComposeApplicationRuntime parent2) {
                if (parent1 == parent2) {
                    return 0;
                }
                if (parent1 == null || parent2 == null) {
                    return parent1 == null ? -1 : 1;
                }
                return COMPOSE_APPS.compare(parent1, parent2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$2";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        CONTAINERS{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                if (rt1 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return StringUtil.compare((String)((DockerApplicationRuntime)rt1).getContainerId(), (String)((DockerApplicationRuntime)rt2).getContainerId(), (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$3";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        IMAGES{

            @Override
            public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
                boolean noImageTags2;
                if (rt1 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (rt2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                DockerApplicationRuntime art1 = (DockerApplicationRuntime)rt1;
                DockerApplicationRuntime art2 = (DockerApplicationRuntime)rt2;
                ArrayList imageTags1 = new ArrayList(ContainerUtil.notNullize(art1.getImageRepoTags()));
                ArrayList imageTags2 = new ArrayList(ContainerUtil.notNullize(art2.getImageRepoTags()));
                Collections.sort(imageTags1);
                Collections.sort(imageTags2);
                String firstTag1 = (String)ContainerUtil.getFirstItem(imageTags1);
                String firstTag2 = (String)ContainerUtil.getFirstItem(imageTags2);
                boolean noImageTags1 = firstTag1 == null || StringUtil.equals((CharSequence)firstTag1, (CharSequence)"<none>:<none>");
                boolean bl = noImageTags2 = firstTag2 == null || StringUtil.equals((CharSequence)firstTag2, (CharSequence)"<none>:<none>");
                if (noImageTags1 || noImageTags2) {
                    if (noImageTags1 && noImageTags2) {
                        return StringUtil.compare((String)art1.getImageId(), (String)art2.getImageId(), (boolean)false);
                    }
                    return noImageTags1 ? 1 : -1;
                }
                return StringUtil.compare((String)firstTag1, (String)firstTag2, (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rt2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory$4";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        UNKNOWNS;


        public int compare(@NotNull DockerDeploymentRuntimeBase rt1, @NotNull DockerDeploymentRuntimeBase rt2) {
            if (rt1 == null) {
                DockerRuntimeCategory.$$$reportNull$$$0(0);
            }
            if (rt2 == null) {
                DockerRuntimeCategory.$$$reportNull$$$0(1);
            }
            return DockerRuntimeComparator.compareIdentity((Object)rt1, (Object)rt2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rt1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rt2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/runtimes/DockerRuntimeComparator$DockerRuntimeCategory";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

