/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerAgentPathMapperImpl;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.progress.DockerImageBuilder;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.settings.DockerLabelImpl;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.cli.executor.DockerCliImageBuilder;
import com.intellij.docker.debug.DebugDeploymentTransformer;
import com.intellij.docker.debug.DockerDebugConnector;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeployingDeploymentRuntime;
import com.intellij.docker.runtimes.DockerFailedDeploymentRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerDeploymentRuntime
extends DockerApplicationRuntime {
    private static final Logger LOG = Logger.getInstance(DockerDeploymentRuntime.class);
    private final DockerAgentDeployment myAgentDeployment;
    private final DeploymentTask<? extends DockerDeploymentConfiguration> myTask;

    DockerDeploymentRuntime(DockerRuntimeContext context, final DeploymentTask<? extends DockerDeploymentConfiguration> task, DockerGroupRuntime group) throws ServerRuntimeException {
        super(context, task.getSource().getPresentableName(), group);
        DebugDeploymentTransformer<DockerAgentDeploymentConfig> deploymentTransformer;
        DebugConnector debugConnector;
        File sourceFile;
        DockerAgentSourceType agentSourceType;
        this.myTask = task;
        DeploymentSource source = task.getSource();
        if (source.getType() instanceof DockerFileDeploymentSourceType) {
            agentSourceType = DockerAgentSourceType.FILE;
            if (StringUtil.isEmptyOrSpaces((String)((DockerDeploymentConfiguration)task.getConfiguration()).getSourceFilePath())) {
                throw new ServerRuntimeException("Dockerfile not specified");
            }
            File dockerFile = DockerDeploymentConfigurationUtilsKt.getSourceFile(task.getProject(), (DockerDeploymentConfiguration)task.getConfiguration());
            if (dockerFile == null) {
                throw new ServerRuntimeException("Dockerfile cannot be found at " + ((DockerDeploymentConfiguration)task.getConfiguration()).getSourceFilePath());
            }
            sourceFile = dockerFile;
        } else if (source.getType() instanceof DockerImageDeploymentSourceType) {
            agentSourceType = DockerAgentSourceType.IMAGE;
            sourceFile = null;
        } else {
            agentSourceType = DockerAgentSourceType.FILE;
            sourceFile = source.getFile();
            if (sourceFile == null) {
                throw new ServerRuntimeException("Artifact file not found");
            }
        }
        final DockerDeploymentConfiguration configuration = (DockerDeploymentConfiguration)task.getConfiguration();
        DockerAgentDeploymentConfig.Adapter dockerAgentDeploymentConfig = new DockerAgentDeploymentConfig.Adapter(){

            public File getFile() {
                return sourceFile;
            }

            public String @NotNull [] getImageTags() {
                String[] stringArray = (String[])Stream.of(configuration.getSeparateImageTags()).map(String::trim).filter(StringUtil::isNotEmpty).toArray(String[]::new);
                if (stringArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return stringArray;
            }

            public String getContainerName() {
                return Optional.ofNullable(configuration.getContainerName()).map(String::trim).orElse(null);
            }

            public String[] getCustomRunOptions() {
                return this.parseToArray(configuration.getRunCliOptions());
            }

            public String[] getCustomBuildOptions() {
                return this.parseToArray(configuration.getBuildCliOptions());
            }

            private String[] parseToArray(@Nullable String cliOptions) {
                return StringUtil.isEmptyOrSpaces((String)cliOptions) ? null : ParametersListUtil.parseToArray((String)cliOptions);
            }

            public DockerLabel[] getLabels() {
                RunnerAndConfigurationSettings settings;
                if (StringUtil.isEmptyOrSpaces((String)this.getContainerName()) && (settings = task.getExecutionEnvironment().getRunnerAndConfigurationSettings()) != null && !StringUtil.isEmptyOrSpaces((String)settings.getName())) {
                    DockerLabelImpl markerLabel = new DockerLabelImpl();
                    markerLabel.setKey("com.intellij.docker.source.run.configuration");
                    markerLabel.setValue(settings.getName());
                    return new DockerLabel[]{markerLabel};
                }
                return null;
            }

            public String sourceType() {
                return agentSourceType.name();
            }

            public boolean isBuildImageOnly() {
                return configuration.isBuildOnly();
            }

            public File getCustomContextFolder() {
                String contextPath = configuration.getContextFolderPath();
                return StringUtil.isEmptyOrSpaces((String)contextPath) ? null : DockerDeploymentConfigurationUtilsKt.getSourceFile(DockerDeploymentRuntime.this.myTask.getProject(), contextPath);
            }

            public String[] getEntrypoint() {
                return DockerDeploymentRuntime.parseCommandLine(configuration.getEntrypoint());
            }

            public String[] getCommand() {
                return DockerDeploymentRuntime.parseCommandLine(configuration.getCommand());
            }

            public DockerPortBinding[] getPortBindings() {
                List<DockerPortBindingImpl> portBindings = configuration.getPortBindings();
                return DockerDeploymentRuntime.toObjectArrayOrNull(portBindings, DockerPortBinding.class);
            }

            public Boolean getPublishAllPorts() {
                return this.isPublishAllPorts() ? Boolean.TRUE : null;
            }

            public boolean isPublishAllPorts() {
                return configuration.isPublishAllPorts();
            }

            public DockerLink[] getLinks() {
                List<DockerLinkImpl> links = configuration.getLinks();
                return DockerDeploymentRuntime.toObjectArrayOrNull(links, DockerLink.class);
            }

            public DockerVolumeBinding[] getVolumeBindings() {
                List<DockerVolumeBindingImpl> binds = configuration.getVolumeBindings();
                return DockerDeploymentRuntime.toObjectArrayOrNull(binds, DockerVolumeBinding.class);
            }

            public DockerEnvVar[] getEnvVars() {
                List<DockerEnvVarImpl> envVars = configuration.getEnvVars();
                return DockerDeploymentRuntime.toObjectArrayOrNull(envVars, DockerEnvVar.class);
            }

            public DockerEnvVar[] getBuildArgs() {
                List<DockerEnvVarImpl> buildArgs = configuration.getBuildArgs();
                return DockerDeploymentRuntime.toObjectArrayOrNull(buildArgs, DockerEnvVar.class);
            }

            public String @Nullable [] getImplicitlyRequiredImages() {
                List<String> images = configuration.getImagesToPullBeforeRun();
                return images.isEmpty() ? null : ArrayUtil.toStringArray(images);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/runtimes/DockerDeploymentRuntime$1", "getImageTags"));
            }
        };
        if (task instanceof DeploymentTaskImpl && (debugConnector = ((DeploymentTaskImpl)task).getDebugConnector()) instanceof DockerDebugConnector && (deploymentTransformer = ((DockerDebugConnector)debugConnector).getDeploymentTransformer(task)) != null) {
            dockerAgentDeploymentConfig = deploymentTransformer.transformConfig((DockerAgentDeploymentConfig)dockerAgentDeploymentConfig);
        }
        this.myAgentDeployment = context.getAgent().createDeployment((DockerAgentDeploymentConfig)dockerAgentDeploymentConfig, (DockerAgentPathMapper)new DockerAgentPathMapperImpl(this.myTask.getProject()));
    }

    private static <T> T[] toObjectArrayOrNull(Collection<? extends T> list, Class<T> clazz) {
        return list == null || list.isEmpty() ? null : ArrayUtil.toObjectArray(list, clazz);
    }

    private static String[] parseCommandLine(String commandLine) {
        return StringUtil.isEmpty((String)commandLine) ? null : ParametersListUtil.parseToArray((String)commandLine);
    }

    public DockerDeploymentConfiguration getConfiguration() {
        return (DockerDeploymentConfiguration)this.myTask.getConfiguration();
    }

    public void deploy(final @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback, @NotNull @Nls String deploymentDisplayName, @NotNull Boolean enableBuildKit) {
        if (callback == null) {
            DockerDeploymentRuntime.$$$reportNull$$$0(0);
        }
        if (deploymentDisplayName == null) {
            DockerDeploymentRuntime.$$$reportNull$$$0(1);
        }
        if (enableBuildKit == null) {
            DockerDeploymentRuntime.$$$reportNull$$$0(2);
        }
        final DockerTerminalPipe.WithTty deployPipe = new DockerTerminalPipe.WithTty("DockerBuildLog.pipe", DockerDeploymentRuntime.wrapIdeaLogger(LOG, false)).setUseBufferedWriter(true).setShowCursor(false);
        callback.started((DeploymentRuntime)new DockerDeployingDeploymentRuntime(this.getApplicationName(), this.getContext()){

            @Override
            public void stopDeploy() {
                DockerDeploymentRuntime.this.myAgentDeployment.stopDeploy();
            }

            @Override
            @NotNull
            public DockerTerminalPipe getDeployLogPipe() {
                DockerTerminalPipe.WithTty withTty = deployPipe;
                if (withTty == null) {
                    2.$$$reportNull$$$0(0);
                }
                return withTty;
            }

            @Override
            public boolean isAttachToContainerNeeded() {
                return ((DockerDeploymentConfiguration)DockerDeploymentRuntime.this.myTask.getConfiguration()).isAttachToContainerNeeded();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/runtimes/DockerDeploymentRuntime$2", "getDeployLogPipe"));
            }
        });
        CallbackWrapper<Void> callbackWrapper = new CallbackWrapper<Void>(){

            public void onSuccess(Void result) {
                DockerDeploymentRuntime.this.setApplication((DockerAgentApplication)DockerDeploymentRuntime.this.myAgentDeployment);
                Deployment deployment = callback.succeeded((DeploymentRuntime)DockerDeploymentRuntime.this);
                DockerDeploymentRuntime.this.setDeploymentModel(deployment);
            }

            public void onError(final @Nls String message) {
                callback.errorOccurred(message, (DeploymentRuntime)new DockerFailedDeploymentRuntime(DockerDeploymentRuntime.this.getApplicationName(), DockerDeploymentRuntime.this.getContext()){

                    @Override
                    @NotNull
                    public String getErrorMessage() {
                        String string = message;
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/runtimes/DockerDeploymentRuntime$3$1", "getErrorMessage"));
                    }
                });
            }
        };
        this.getAgentTaskExecutor().execute(() -> {
            this.myAgentDeployment.deploy(deploymentDisplayName, (DockerTerminalPipe)deployPipe, this.getImageBuilder(enableBuildKit, deployPipe));
            return null;
        }, (CallbackWrapper)callbackWrapper);
    }

    @Nullable
    private DockerImageBuilder getImageBuilder(boolean enableBuildKit, DockerTerminalPipe.WithTty deployPipe) {
        if (enableBuildKit) {
            return new DockerCliImageBuilder(this.myTask.getProject(), deployPipe, (DockerDeploymentConfiguration)this.myTask.getConfiguration(), this.getContext().getServerConfiguration());
        }
        return null;
    }

    @Override
    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        if (callback == null) {
            DockerDeploymentRuntime.$$$reportNull$$$0(3);
        }
        if (this.getContainerId() == null) {
            callback.errorOccurred(DockerBundle.message("DockerDeploymentRuntime.images.undeploy.is.not.supported", new Object[0]));
            return;
        }
        Computable deleteContainerTask = () -> {
            this.getAgentApplication().deleteContainer();
            return null;
        };
        ((CompletableFuture)this.makeAgentPromise(deleteContainerTask).thenRun(() -> callback.succeeded())).exceptionally(e -> {
            callback.errorOccurred(e.getMessage());
            return null;
        });
    }

    @Override
    public void deleteContainer() {
        Deployment deployment = this.getDeploymentModel();
        if (deployment != null && this.getContainerId() != null) {
            deployment.getConnection().undeploy(deployment, (DeploymentRuntime)this);
        } else {
            super.deleteContainer();
        }
    }

    public JavaDebugConnectionData getDebugConnectionData() throws ServerRuntimeException {
        URL apiUrl;
        Integer debugPort = ((DockerDeploymentConfiguration)this.myTask.getConfiguration()).getDebugPort();
        if (debugPort == null) {
            throw new ServerRuntimeException("Debug port not specified");
        }
        try {
            apiUrl = new URL(this.getServerConfiguration().getApiUrl());
        }
        catch (MalformedURLException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
        return new JavaDebugConnectionData(apiUrl.getHost(), debugPort.intValue());
    }

    @Override
    @Nullable
    protected DockerApplicationRuntime.DockerRuntimeNavigatable computeRuntimeNavigatable(@NotNull Project project) {
        DockerApplicationRuntime.DockerRuntimeNavigatable result;
        if (project == null) {
            DockerDeploymentRuntime.$$$reportNull$$$0(4);
        }
        if ((result = super.computeRuntimeNavigatable(project)) != null) {
            return result;
        }
        VirtualFile virtualFile = Optional.ofNullable(DockerDeploymentConfigurationUtilsKt.getSourceFile(project, this.getConfiguration())).map(arg_0 -> ((LocalFileSystem)LocalFileSystem.getInstance()).findFileByIoFile(arg_0)).orElse(null);
        return virtualFile == null ? null : new DockerApplicationRuntime.DockerRuntimeVirtualFileNavigatable(project, virtualFile);
    }

    @Override
    protected void setupDeploymentPresentableName() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentDisplayName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableBuildKit";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/runtimes/DockerDeploymentRuntime";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deploy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "undeploy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeRuntimeNavigatable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

