/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentLogProvider;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.agent.terminal.pipe.DockerConsolePipe;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerAgentRepositoryConfigImpl;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerSuccessfulDeploymentRuntime;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentImpl;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerApplicationRuntime
extends DockerSuccessfulDeploymentRuntime {
    private static final Logger LOG = Logger.getInstance(DockerApplicationRuntime.class);
    private final DockerRuntimeContext myContext;
    private final AtomicBoolean myStatusChangedInternally;
    private volatile DockerParentRuntime myParent;
    private volatile DockerAgentApplication myAgentApplication;
    private volatile String[] myContainerNames;
    private volatile String myImageId;
    private volatile DockerDeploymentStatus myStatusWithCustomText;
    private volatile Set<String> myImageRepoTags;
    private volatile String myContainerId;

    public DockerApplicationRuntime(@NotNull DockerRuntimeContext context, @NotNull String uniqueName, @Nullable DockerParentRuntime parent) {
        if (context == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(0);
        }
        if (uniqueName == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(1);
        }
        super(uniqueName, context);
        this.myStatusChangedInternally = new AtomicBoolean();
        this.myContext = context;
        this.setParent(parent);
    }

    public DockerAgent getAgent() {
        return this.getRuntimeContext().getAgent();
    }

    @NotNull
    final DockerRuntimeContext getRuntimeContext() {
        DockerRuntimeContext dockerRuntimeContext = this.myContext;
        if (dockerRuntimeContext == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(2);
        }
        return dockerRuntimeContext;
    }

    @NotNull
    protected DockerCloudConfiguration getServerConfiguration() {
        DockerCloudConfiguration dockerCloudConfiguration = this.myContext.getServerConfiguration();
        if (dockerCloudConfiguration == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(3);
        }
        return dockerCloudConfiguration;
    }

    void setApplication(DockerAgentApplication agentApplication) {
        this.myAgentApplication = agentApplication;
        this.myContainerId = agentApplication.getContainerId();
        this.myContainerNames = agentApplication.getContainerNames();
        this.myImageId = agentApplication.getImageId();
        @NlsSafe String statusText = agentApplication.getAgentApplicationStatus();
        if (this.myContainerId != null) {
            this.myStatusWithCustomText = DockerDeploymentStatus.newContainerStatus(statusText);
        } else {
            this.myStatusWithCustomText = DockerDeploymentStatus.newImageStatus(statusText == null ? "" : statusText);
            this.myImageRepoTags = ContainerUtil.set((Object[])agentApplication.getImageRepoTags());
        }
        this.checkAndClearInternalChangeStatus();
        this.setupDeploymentPresentableName();
    }

    public String getContainerId() {
        return this.myAgentApplication != null ? this.myContainerId : null;
    }

    public String @Nullable [] getContainerNames() {
        return this.myContainerNames;
    }

    public String getContainerName() {
        return this.myContainerNames == null || this.myContainerNames.length == 0 ? null : new TreeSet<String>(Arrays.asList(this.myContainerNames)).first();
    }

    public void setDeploymentModel(@NotNull Deployment deployment) {
        if (deployment == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(4);
        }
        super.setDeploymentModel(deployment);
        this.setupDeploymentPresentableName();
    }

    protected void setupDeploymentPresentableName() {
        if (this.myAgentApplication == null) {
            return;
        }
        Deployment deployment = this.getDeploymentModel();
        if (deployment instanceof DeploymentImpl) {
            ((DeploymentImpl)deployment).setPresentableName(this.getPresentableName());
        }
    }

    @Nullable
    @NlsSafe
    public final String getPresentableName() {
        return this.myAgentApplication.getPresentableName();
    }

    public String getImageId() {
        return this.myImageId;
    }

    @NotNull
    public Set<String> getImageRepoTags() {
        Set set = Optional.ofNullable(this.myImageRepoTags).map(HashSet::new).orElse(new HashSet());
        if (set == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public DeploymentStatus getStatus() {
        return this.myStatusWithCustomText == null ? null : this.myStatusWithCustomText.getStatus();
    }

    boolean checkAndClearInternalChangeStatus() {
        return this.myStatusChangedInternally.getAndSet(false);
    }

    private void internalChangeStatus(@Nullable DockerDeploymentStatus newStatus) {
        if (newStatus != null) {
            this.myStatusWithCustomText = newStatus;
            this.myStatusChangedInternally.set(true);
        }
        this.myStatusWithCustomText.apply(this.getDeploymentModel());
    }

    @Nullable
    public String getStatusText() {
        return this.myStatusWithCustomText == null ? null : this.myStatusWithCustomText.getCustomText();
    }

    @Nullable
    public DockerApplicationRuntime getParent() {
        return this.myParent == null ? null : this.myParent.asDockerRuntime();
    }

    @Nullable
    public final Navigatable computeNavigatable(@NotNull Project project) {
        DockerRuntimeNavigatable navigatable;
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(6);
        }
        return (navigatable = this.computeRuntimeNavigatable(project)) == null ? null : navigatable.getNavigatable();
    }

    @Nullable
    public final VirtualFile computeVirtualFile(@NotNull Project project) {
        DockerRuntimeNavigatable navigatable;
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(7);
        }
        return (navigatable = this.computeRuntimeNavigatable(project)) == null ? null : navigatable.getVirtualFile();
    }

    @Nullable
    protected DockerRuntimeNavigatable computeRuntimeNavigatable(@NotNull Project project) {
        DockerApplicationRuntime parent;
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(8);
        }
        if (this.getContainerId() != null && (parent = this.getParent()) instanceof ComposeServiceRuntime) {
            return parent.computeRuntimeNavigatable(project);
        }
        return null;
    }

    public void setParent(@Nullable DockerParentRuntime parent) {
        if (this.myParent != null) {
            this.myParent.childRemoved(this);
        }
        this.myParent = parent;
        if (this.myParent != null) {
            this.myParent.childAdded(this);
        }
    }

    @Override
    public void startContainer() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.startContainer();
            }
        }.run(DockerDeploymentStatus.STARTING, DockerDeploymentStatus.STARTED);
    }

    @Override
    public void stopContainer() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.stopContainer();
            }
        }.run(DockerDeploymentStatus.STOPPING, DockerDeploymentStatus.STOPPED);
    }

    @Override
    public void deleteContainer() {
        Deployment deployment = this.getDeploymentModel();
        String deploymentName = deployment == null ? null : deployment.getName();
        ServerConnection connection = deployment == null ? null : deployment.getConnection();
        StatusChangingTask deleteTask = new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.deleteContainer();
            }
        };
        deleteTask.run(DockerDeploymentStatus.DELETING, DockerDeploymentStatus.DELETED).thenRunAsync(() -> {
            if (connection instanceof ServerConnectionImpl && connection.getStatus() == ConnectionStatus.CONNECTED) {
                ((ServerConnectionImpl)connection).disposeAllLogs(deploymentName);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    @Override
    public CompletableFuture<DockerConsolePipe> showLog() {
        return this.myAgentApplication.showLog();
    }

    @Override
    @NotNull
    public CompletableFuture<String> inspectJson() {
        CompletableFuture<String> completableFuture = this.makeAgentPromise(() -> ((DockerAgentApplication)this.myAgentApplication).computeInspectJson());
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<String> processesJson() {
        CompletableFuture<String> completableFuture = this.makeAgentPromise(() -> ((DockerAgentApplication)this.myAgentApplication).computeProcessesJson());
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    protected final <T> CompletableFuture<T> makeAgentPromise(@NotNull Computable<? extends T> agentComputable) {
        if (agentComputable == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(11);
        }
        CompletableFuture result = new CompletableFuture();
        this.getTaskExecutor().submit(() -> {
            try {
                Object agentResult = this.getAgentTaskExecutor().execute(agentComputable);
                result.complete(agentResult);
            }
            catch (ServerRuntimeException e) {
                LOG.error((Throwable)e);
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    @Override
    @NotNull
    public Void reportError(@NotNull Throwable ex) {
        if (ex == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(12);
        }
        LOG.debug(ex);
        this.getCloudNotifier().showMessage(ex.getMessage(), MessageType.ERROR);
        if (null == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(13);
        }
        return null;
    }

    public CompletableFuture<DockerAgentContainerInspection> promiseInspect() {
        return this.makeAgentPromise(() -> this.myAgentApplication.inspect());
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> attach() {
        CompletableFuture completableFuture = this.myAgentApplication.attach(true);
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(14);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<DockerTerminalPipe> exec(@NotNull String command) {
        if (command == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(15);
        }
        CompletableFuture completableFuture = this.myAgentApplication.exec(ParametersListUtil.parseToArray((String)command), true);
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<byte[]> captureExecOutput(String @NotNull [] command, boolean includeErr) {
        if (command == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(17);
        }
        CompletableFuture completableFuture = this.myAgentApplication.captureExecOutput(command, includeErr);
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(18);
        }
        return completableFuture;
    }

    @Override
    public void deleteImage() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.deleteImage();
            }
        }.run(DockerDeploymentStatus.DELETING, DockerDeploymentStatus.DELETED);
    }

    @Override
    @NotNull
    public CompletableFuture<String> createContainer() {
        CompletionStage completionStage = this.makeAgentPromise(() -> this.myAgentApplication.createContainer()).exceptionally(e -> {
            this.reportError((Throwable)e);
            return null;
        });
        if (completionStage == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(19);
        }
        return completionStage;
    }

    @Override
    public boolean isUndeploySupported() {
        return false;
    }

    @Override
    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        if (callback == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(20);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void pushImage(@NotNull Project project, DockerRepositoryModel repositoryModel) {
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(21);
        }
        final DockerAgentRepositoryConfigImpl repositoryConfig = new DockerAgentRepositoryConfigImpl(repositoryModel);
        @NlsSafe String qualifiedReference = repositoryConfig.getQualifiedTag();
        new RegistryRuntimeTask(){

            @Override
            protected OngoingProcess doPerform(DockerAgentProgressCallback progressCallback) {
                return DockerApplicationRuntime.this.myAgentApplication.pushImage(repositoryConfig, progressCallback);
            }
        }.performAsyncWithNotification(project, this.getTaskExecutor(), this.getAgentTaskExecutor(), DockerBundle.message("DockerApplicationRuntime.progress.message.pushing", qualifiedReference), DockerBundle.message("DockerApplicationRuntime.progress.message.pushed.successfully", qualifiedReference));
    }

    @Override
    @NotNull
    public CompletableFuture<DockerAgentApplication.ContainerUpdateResult> updateContainer(@NotNull DockerAgentContainerConfig config) {
        if (config == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(22);
        }
        CompletableFuture<DockerAgentApplication.ContainerUpdateResult> completableFuture = this.makeAgentPromise(() -> {
            DockerAgentApplication.ContainerUpdateResult updateResult = this.myAgentApplication.updateContainer(config);
            this.handleContainerUpdateResult(updateResult);
            return updateResult;
        });
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(23);
        }
        return completableFuture;
    }

    protected final void handleContainerUpdateResult(@Nullable DockerAgentApplication.ContainerUpdateResult updateResult) {
        if (updateResult == null) {
            return;
        }
        String oldId = updateResult.getRemovedContainerId();
        String newId = updateResult.getCreatedContainerId();
        if (!StringUtil.equals((CharSequence)oldId, (CharSequence)this.getContainerId())) {
            return;
        }
        DockerAgentApplication newAgentApp = updateResult.getCreatedAgentApplication();
        if (newAgentApp != null && oldId != null && newId != null && !newId.equals(oldId)) {
            this.setApplication(newAgentApp);
        }
    }

    public String toString() {
        String hash = Optional.ofNullable(this.getApplicationName()).map(DockerUtil::shortedId).orElse(null);
        return "@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + " id: " + hash + ", " + (this.myContainerId == null ? "[IMG]: " + this.getImageRepoTags() : "[CNT]: " + Arrays.toString(this.getContainerNames()));
    }

    public DockerAgentApplication getAgentApplication() {
        return this.myAgentApplication;
    }

    @Nullable
    public RemoteServer<?> getServer() {
        Deployment deployment = this.getDeploymentModel();
        if (deployment == null) {
            return null;
        }
        return deployment.getConnection().getServer();
    }

    protected static DockerAgentLogProvider wrapIdeaLogger(Logger logger, boolean withTracing) {
        return new DockerAgentLogProvider(e -> logger.info(e), e -> logger.trace(e), e -> logger.warn(e), e -> logger.error(e), withTracing);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/DockerApplicationRuntime";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentComputable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/DockerApplicationRuntime";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageRepoTags";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectJson";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "processesJson";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "reportError";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "attach";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "exec";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "captureExecOutput";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createContainer";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "updateContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDeploymentModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeNavigatable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeVirtualFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeRuntimeNavigatable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "makeAgentPromise";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "captureExecOutput";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "undeploy";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pushImage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class DockerRuntimeVirtualFileNavigatable
    implements DockerRuntimeNavigatable {
        private final Project myProject;
        private final VirtualFile myVirtualFile;

        DockerRuntimeVirtualFileNavigatable(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            if (project == null) {
                DockerRuntimeVirtualFileNavigatable.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                DockerRuntimeVirtualFileNavigatable.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myVirtualFile = virtualFile;
        }

        @Override
        @NotNull
        public Navigatable getNavigatable() {
            Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myVirtualFile, 0);
            if (navigatable == null) {
                DockerRuntimeVirtualFileNavigatable.$$$reportNull$$$0(2);
            }
            return navigatable;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                DockerRuntimeVirtualFileNavigatable.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/runtimes/DockerApplicationRuntime$DockerRuntimeVirtualFileNavigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/runtimes/DockerApplicationRuntime$DockerRuntimeVirtualFileNavigatable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static interface DockerRuntimeNavigatable {
        @NotNull
        public Navigatable getNavigatable();

        @Nullable
        public VirtualFile getVirtualFile();
    }

    private abstract class StatusChangingTask
    extends StatusChangingAgentComputable<Void> {
        private StatusChangingTask() {
        }

        @Override
        public CompletableFuture<Void> run(DockerDeploymentStatus transitionStatus, DockerDeploymentStatus targetStatus) {
            CompletableFuture mayFail = super.run(transitionStatus, targetStatus);
            return mayFail.exceptionally(DockerApplicationRuntime.this::reportError);
        }

        @Override
        protected Void computeOnAgent() {
            this.doAgentTask();
            return null;
        }

        protected abstract void doAgentTask();
    }

    private abstract class StatusChangingAgentComputable<T> {
        private StatusChangingAgentComputable() {
        }

        public CompletableFuture<T> run(DockerDeploymentStatus transitionStatus, DockerDeploymentStatus targetStatus) {
            transitionStatus.apply(DockerApplicationRuntime.this.getDeploymentModel());
            CompletableFuture result = DockerApplicationRuntime.this.makeAgentPromise(this::computeOnAgent);
            return result.whenComplete((agentResult, failure) -> DockerApplicationRuntime.this.internalChangeStatus(targetStatus));
        }

        protected abstract T computeOnAgent();
    }
}

