/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerComposeDownOptions;
import com.intellij.docker.DockerComposeRemoveImagesOnDown;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.agent.cli.communicator.AsyncCliProcess;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.cli.executor.CliExecutor;
import com.intellij.docker.compose.cli.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeDownCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStopCliBuilder;
import com.intellij.docker.debug.DebugDeploymentTransformer;
import com.intellij.docker.debug.DockerDebugConnector;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeployingDeploymentRuntime;
import com.intellij.docker.runtimes.DockerFailedDeploymentRuntime;
import com.intellij.docker.runtimes.DockerRuntimesCache;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposeDeploymentRuntime
extends ComposeApplicationRuntime {
    private static final Logger LOG = Logger.getInstance(ComposeDeploymentRuntime.class);
    private final Project myProject;
    private final DockerRuntimesCache myRuntimesCache;
    private final File myWorkingDirectory;
    private final String myComposeProjectName;
    private Runnable myStopDeployFunction;
    private DockerTerminalPipe.WithTty myPipe;
    private NextDeployInfo myNextDeployInfo;
    private final LinkedHashSet<File> myMergedComposeFiles;
    private final Map<String, String> myMergedEnvironment;

    public ComposeDeploymentRuntime(@NotNull DockerRuntimesCache runtimesCache, @NotNull DeploymentTask<DockerDeploymentConfiguration> task) throws ServerRuntimeException {
        if (runtimesCache == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(0);
        }
        if (task == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(1);
        }
        this(runtimesCache, task, ComposeDeploymentRuntime.getComposeFiles(task));
    }

    public ComposeDeploymentRuntime(@NotNull DockerRuntimesCache runtimesCache, @NotNull DeploymentTask<DockerDeploymentConfiguration> task, @NotNull List<File> composeFiles) throws ServerRuntimeException {
        if (runtimesCache == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(2);
        }
        if (task == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(3);
        }
        if (composeFiles == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(4);
        }
        super(runtimesCache.getRuntimeContext(), ComposeDeploymentRuntime.computeApplicationId(composeFiles));
        this.myStopDeployFunction = () -> {};
        this.myMergedComposeFiles = new LinkedHashSet();
        this.myMergedEnvironment = new LinkedHashMap<String, String>();
        this.myProject = task.getProject();
        this.myRuntimesCache = runtimesCache;
        this.myWorkingDirectory = ComposeDeploymentRuntime.computeWorkingDir(composeFiles);
        this.myComposeProjectName = ComposeDeploymentRuntime.computeErasedProjectName(this.myWorkingDirectory.getName());
        this.myNextDeployInfo = new NextDeployInfo((DockerDeploymentConfiguration)task.getConfiguration(), composeFiles);
        this.myMergedComposeFiles.addAll(composeFiles);
        this.myMergedEnvironment.putAll(ComposeDeploymentRuntime.getTaskEnvironment(task));
    }

    void appendDeploymentTask(@NotNull DeploymentTask<DockerDeploymentConfiguration> newDeploymentTask) throws ServerRuntimeException {
        List<File> newComposeFiles;
        File newWorkingDirectory;
        if (newDeploymentTask == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(5);
        }
        if ((newWorkingDirectory = ComposeDeploymentRuntime.computeWorkingDir(newComposeFiles = ComposeDeploymentRuntime.getComposeFiles(this.myProject, (DockerDeploymentConfiguration)newDeploymentTask.getConfiguration(), ComposeDeploymentRuntime.getDockerDebugTransformer(newDeploymentTask)))) == null || !FileUtil.filesEqual((File)newWorkingDirectory, (File)this.myWorkingDirectory)) {
            LOG.debug("Merging compose deployments from different folders: current work-dir: " + this.myWorkingDirectory + ", requested: " + newWorkingDirectory);
        }
        this.myNextDeployInfo = new NextDeployInfo((DockerDeploymentConfiguration)newDeploymentTask.getConfiguration(), newComposeFiles);
        this.myMergedComposeFiles.addAll(newComposeFiles);
        this.myMergedEnvironment.putAll(ComposeDeploymentRuntime.getTaskEnvironment(newDeploymentTask));
    }

    @Nullable
    private static DebugDeploymentTransformer<?> getDockerDebugTransformer(@NotNull DeploymentTask<DockerDeploymentConfiguration> newDeploymentTask) {
        if (newDeploymentTask == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(6);
        }
        if (!(newDeploymentTask instanceof DeploymentTaskImpl)) {
            return null;
        }
        DebugConnector debugConnector = ((DeploymentTaskImpl)newDeploymentTask).getDebugConnector();
        return debugConnector instanceof DockerDebugConnector ? ((DockerDebugConnector)debugConnector).getDeploymentTransformer(newDeploymentTask) : null;
    }

    @Override
    @NotNull
    public String getComposeProjectName() {
        String string = this.myComposeProjectName;
        if (string == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String computeErasedProjectName(@NotNull String name) {
        if (name == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(8);
        }
        String string = StringUtil.toLowerCase((String)name.replaceAll("[^a-zA-Z0-9-_]+", ""));
        if (string == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public List<File> getComposeFiles() {
        return new ArrayList<File>(this.myMergedComposeFiles);
    }

    @Override
    @NotNull
    protected RemoteDockerRuntime getRuntimeHelper() throws ServerRuntimeException {
        RemoteDockerRuntime result = RemoteDockerRuntime.create(this.getServerConfiguration(), this.myProject);
        assert (result != null);
        RemoteDockerRuntime remoteDockerRuntime = result;
        if (remoteDockerRuntime == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(10);
        }
        return remoteDockerRuntime;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> executeCli(@NotNull AbstractDockerComposeCmdCliBuilder<?> cliBuilder) {
        if (cliBuilder == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(11);
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        GeneralCommandLine commandLine = cliBuilder.buildCommandLine();
        List args = ContainerUtil.filter((Collection)commandLine.getCommandLineList(""), e -> !StringUtil.isEmptyOrSpaces((String)e));
        CliExecutor executor = new CliExecutor(commandLine.getExePath());
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.putAll(this.myMergedEnvironment);
        envs.putAll(commandLine.getEnvironment());
        this.myPipe.printlnSystem(commandLine.getCommandLineString());
        AsyncCliProcess<Unit> cancelable = executor.execAsync(args, envs, (Function1<? super String, Unit>)((Function1)e -> {
            this.myPipe.printError(e);
            return Unit.INSTANCE;
        }), (Function1<? super String, Unit>)((Function1)e -> {
            this.myPipe.print(e);
            return Unit.INSTANCE;
        }), (Function1<? super Integer, Unit>)((Function1)e -> {
            if (e == 0) {
                result.complete(null);
            } else {
                String message = DockerBundle.message("ComposeDeploymentRuntime.process.finished.error.message", e);
                result.completeExceptionally(new CompletionException(message, null));
                this.myPipe.printlnError(message);
            }
            return Unit.INSTANCE;
        }), this.myWorkingDirectory.getPath(), null, true);
        this.myStopDeployFunction = () -> cancelable.cancel();
        CompletableFuture<Void> completableFuture = result;
        if (completableFuture == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    public void deploy(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        CompletableFuture<?> promise;
        DockerTerminalPipe.WithTty deployPipe;
        if (callback == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(13);
        }
        this.myPipe = deployPipe = new DockerTerminalPipe.WithTty("DockerBuildLog.pipe", ComposeDeploymentRuntime.wrapIdeaLogger(LOG, false)).setUseBufferedWriter(true).setShowCursor(false);
        callback.started((DeploymentRuntime)new DockerDeployingDeploymentRuntime(this.getApplicationName(), this.getContext()){

            @Override
            @NotNull
            public DockerTerminalPipe getDeployLogPipe() {
                DockerTerminalPipe.WithTty withTty = deployPipe;
                if (withTty == null) {
                    1.$$$reportNull$$$0(0);
                }
                return withTty;
            }

            @Override
            public void stopDeploy() {
                ComposeDeploymentRuntime.this.myStopDeployFunction.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/runtimes/ComposeDeploymentRuntime$1", "getDeployLogPipe"));
            }
        });
        try {
            promise = this.doDeploy();
        }
        catch (ServerRuntimeException e2) {
            callback.errorOccurred(e2.getMessage(), (DeploymentRuntime)new DockerFailedDeploymentRuntime(this.getApplicationName(), this.getContext()){

                @Override
                @NotNull
                public String getErrorMessage() {
                    String string = e2.getMessage();
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/runtimes/ComposeDeploymentRuntime$2", "getErrorMessage"));
                }
            });
            return;
        }
        ((CompletableFuture)promise.thenRun(() -> callback.succeeded((DeploymentRuntime)this))).exceptionally(e -> {
            callback.errorOccurred(e.getMessage(), (DeploymentRuntime)new DockerFailedDeploymentRuntime(this.getApplicationName(), this.getContext(), (Throwable)e){
                final /* synthetic */ Throwable val$e;
                {
                    this.val$e = throwable;
                    super(arg0, arg1);
                }

                @Override
                @NotNull
                public String getErrorMessage() {
                    String string = this.val$e.getMessage();
                    if (string == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/runtimes/ComposeDeploymentRuntime$3", "getErrorMessage"));
                }
            });
            return null;
        });
    }

    @NotNull
    private static List<File> getComposeFiles(@NotNull DeploymentTask<DockerDeploymentConfiguration> deploymentTask) {
        if (deploymentTask == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(14);
        }
        return ComposeDeploymentRuntime.getComposeFiles(deploymentTask.getProject(), (DockerDeploymentConfiguration)deploymentTask.getConfiguration(), ComposeDeploymentRuntime.getDockerDebugTransformer(deploymentTask));
    }

    @NotNull
    private static List<File> getComposeFiles(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration, DebugDeploymentTransformer<?> debugDeploymentTransformer) {
        if (project == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(15);
        }
        if (configuration == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(16);
        }
        LinkedList<String> paths = new LinkedList<String>();
        paths.add(configuration.getSourceFilePath());
        paths.addAll(configuration.getSecondarySourceFiles());
        List<File> composeFiles = paths.stream().filter(Objects::nonNull).map(path -> DockerDeploymentConfigurationUtilsKt.getSourceFile(project, path)).filter(Objects::nonNull).collect(Collectors.toList());
        List<File> list = debugDeploymentTransformer != null ? debugDeploymentTransformer.patchComposeFiles(composeFiles) : composeFiles;
        if (list == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static String computeApplicationId(@NotNull List<File> composeFiles) throws ServerRuntimeException {
        if (composeFiles == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(18);
        }
        return "Docker-compose: " + ComposeDeploymentRuntime.computeWorkingDir(composeFiles).getName();
    }

    private static File computeWorkingDir(@NotNull List<File> composeFiles) throws ServerRuntimeException {
        if (composeFiles == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(19);
        }
        ComposeDeploymentRuntime.validateComposeFiles(composeFiles);
        return composeFiles.get(0).getParentFile();
    }

    private static void validateComposeFiles(@NotNull List<File> files) throws ServerRuntimeException {
        if (files == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(20);
        }
        if (files.isEmpty()) {
            throw new ServerRuntimeException("Compose file is not specified");
        }
        Optional<File> firstMissing = files.stream().filter(f -> !f.exists() || !f.isFile()).findFirst();
        if (firstMissing.isPresent()) {
            throw new ServerRuntimeException("Can't read compose file at " + firstMissing.get());
        }
    }

    private CompletableFuture<?> doDeploy() throws ServerRuntimeException {
        AbstractDockerComposeCmdCliBuilder cliBuilder = this.shouldRestartOnDeploy() ? DockerComposeCliUtil.buildRestartCommand(this.getRuntimeHelper()).withServices(this.myNextDeployInfo.myServices) : DockerComposeCliUtil.buildUpCommand(this.getRuntimeHelper()).from(this.myNextDeployInfo.myDeployment);
        cliBuilder.withFiles(this.myNextDeployInfo.myComposeFiles);
        cliBuilder.withEnvFile(this.myNextDeployInfo.myEnvFile);
        return this.executeCli(cliBuilder);
    }

    private boolean shouldRestartOnDeploy() {
        String[] services = this.myNextDeployInfo.myServices;
        if (services.length != 1) {
            return false;
        }
        DockerRuntimesManagerService.DockerRuntimesManager manager = DockerRuntimesManagerService.getInstance().getActiveManager();
        if (manager == null) {
            return false;
        }
        return manager.findComposeServiceStatus(this.myComposeProjectName, services[0]) == DockerRuntimesManagerService.ComposeServiceStatus.DEPLOYED;
    }

    public CompletableFuture<?> down() throws ServerRuntimeException {
        RemoteDockerRuntime helper = this.getRuntimeHelper();
        DockerComposeDownCliBuilder cliBuilder = ((DockerComposeDownCliBuilder)DockerComposeCliUtil.buildDownCommand(helper).withFiles(this.getComposeFilePaths())).withRemoveVolumes(this.myNextDeployInfo != null && this.myNextDeployInfo.shouldRemoveVolumes()).withRemoveOrphans(this.myNextDeployInfo != null && this.myNextDeployInfo.shouldRemoveOrphans()).withRemoveImages(this.myNextDeployInfo != null ? this.myNextDeployInfo.shouldRemoveImages() : DockerComposeDownCliBuilder.ImageKind.none);
        return this.executeCli(cliBuilder);
    }

    public CompletableFuture<?> stopAllServices() throws ServerRuntimeException {
        RemoteDockerRuntime helper = this.getRuntimeHelper();
        String[] allServices = this.getAllServiceNames();
        DockerComposeStopCliBuilder cliBuilder = ((DockerComposeStopCliBuilder)DockerComposeCliUtil.buildStopCommand(helper).withFiles(this.getComposeFilePaths())).withServices(allServices);
        return this.executeCli(cliBuilder);
    }

    @Override
    public String toString() {
        return "@" + Integer.toHexString(this.hashCode()) + " id: " + this.getApplicationName() + ", [APP][++]";
    }

    @Override
    public boolean isUndeploySupported() {
        return true;
    }

    @Override
    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        CompletableFuture<?> downPromise;
        if (callback == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(21);
        }
        try {
            downPromise = this.down();
        }
        catch (ServerRuntimeException e2) {
            callback.errorOccurred(e2.getMessage());
            return;
        }
        ((CompletableFuture)((CompletableFuture)downPromise.thenRun(() -> this.myRuntimesCache.composeApplicationUndeployed(this))).thenRun(() -> callback.succeeded())).exceptionally(e -> {
            callback.errorOccurred(e.getMessage());
            return null;
        });
    }

    @NotNull
    private static Map<String, String> getTaskEnvironment(@NotNull DeploymentTask<DockerDeploymentConfiguration> task) {
        if (task == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(22);
        }
        Map<String, String> map2 = ((DockerDeploymentConfiguration)task.getConfiguration()).getEnvVars().stream().filter(var -> !StringUtil.isEmptyOrSpaces((String)var.getName())).collect(Collectors.toMap(var -> StringUtil.trim((String)var.getName()), var -> StringUtil.trim((String)var.getValue()), (oldVal, newVal) -> newVal));
        if (map2 == null) {
            ComposeDeploymentRuntime.$$$reportNull$$$0(23);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimesCache";
                break;
            }
            case 1: 
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composeFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDeploymentTask";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cliBuilder";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentTask";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposeProjectName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeErasedProjectName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeHelper";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCli";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposeFiles";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendDeploymentTask";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDockerDebugTransformer";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 23: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeErasedProjectName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeCli";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deploy";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getComposeFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeApplicationId";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeWorkingDir";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "validateComposeFiles";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "undeploy";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTaskEnvironment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 17: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NextDeployInfo {
        private final DockerComposeDownOptions myDownOptions;
        private final List<Path> myComposeFiles;
        private final String myEnvFile;
        private final DockerDeploymentConfiguration myDeployment;
        private final String[] myServices;

        NextDeployInfo(@NotNull DockerDeploymentConfiguration deployment, @NotNull List<File> composeFiles) {
            if (deployment == null) {
                NextDeployInfo.$$$reportNull$$$0(0);
            }
            if (composeFiles == null) {
                NextDeployInfo.$$$reportNull$$$0(1);
            }
            this.myServices = ArrayUtilRt.toStringArray(deployment.getServices());
            this.myDeployment = deployment;
            this.myDownOptions = deployment.copyComposeDownOptions();
            this.myEnvFile = deployment.getEnvFilePath();
            this.myComposeFiles = ContainerUtil.map(composeFiles, File::toPath);
        }

        DockerComposeRemoveImagesOnDown getRemoveImagesPolicy() {
            return this.myDownOptions.getRemoveImages();
        }

        DockerComposeDownCliBuilder.ImageKind shouldRemoveImages() {
            switch (this.getRemoveImagesPolicy()) {
                case ALL: {
                    return DockerComposeDownCliBuilder.ImageKind.all;
                }
                case LOCAL: {
                    return DockerComposeDownCliBuilder.ImageKind.local;
                }
            }
            return DockerComposeDownCliBuilder.ImageKind.none;
        }

        boolean shouldRemoveOrphans() {
            return this.myDownOptions.getRemoveOrphans();
        }

        boolean shouldRemoveVolumes() {
            return this.myDownOptions.getRemoveVolumes();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deployment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "composeFiles";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/runtimes/ComposeDeploymentRuntime$NextDeployInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

