/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerIcons;
import com.intellij.docker.compose.cli.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComposeApplicationRuntime
extends DockerApplicationRuntime
implements DockerParentRuntime {
    public static final CloudNotifier COMPOSE_NOTIFIER = new CloudNotifier("docker-compose");
    private final List<ComposeServiceRuntime> myServiceRuntimes;
    private final DeploymentStatus myStatus;

    @Nls
    public static String NOTIFICATION_GROUP_TITLE() {
        return DockerBundle.message("ComposeApplicationRuntime.notification.group", new Object[0]);
    }

    public ComposeApplicationRuntime(@NotNull DockerRuntimeContext context, @NotNull String applicationName) {
        if (context == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(0);
        }
        if (applicationName == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(1);
        }
        super(context, applicationName, null);
        this.myServiceRuntimes = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myStatus = new DeploymentStatus(DockerIcons.ContainersList_2, "", false);
    }

    @Override
    @Nullable
    public DeploymentStatus getStatus() {
        return this.myStatus;
    }

    @Override
    @NotNull
    public DockerApplicationRuntime asDockerRuntime() {
        ComposeApplicationRuntime composeApplicationRuntime = this;
        if (composeApplicationRuntime == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(2);
        }
        return composeApplicationRuntime;
    }

    @Override
    public void childAdded(@NotNull DockerApplicationRuntime child) {
        if (child == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(3);
        }
        assert (child instanceof ComposeServiceRuntime) : "unexpected: " + child;
        this.myServiceRuntimes.add((ComposeServiceRuntime)child);
    }

    @Override
    public void childRemoved(@NotNull DockerApplicationRuntime child) {
        if (child == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(4);
        }
        assert (child instanceof ComposeServiceRuntime) : "unexpected: " + child;
        this.myServiceRuntimes.remove((ComposeServiceRuntime)child);
    }

    @NotNull
    public abstract String getComposeProjectName();

    public CloudNotifier getCloudNotifier() {
        return COMPOSE_NOTIFIER;
    }

    @Nullable
    protected abstract RemoteDockerRuntime getRuntimeHelper() throws ServerRuntimeException;

    @NotNull
    public final RemoteDockerRuntime requireRuntimeHelper() throws ServerRuntimeException {
        RemoteDockerRuntime result = this.getRuntimeHelper();
        if (result == null) {
            throw new ServerRuntimeException(DockerBundle.message("ComposeApplicationRuntime.cant.find.configuration.for.compose.project", this.getComposeProjectName()));
        }
        RemoteDockerRuntime remoteDockerRuntime = result;
        if (remoteDockerRuntime == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(5);
        }
        return remoteDockerRuntime;
    }

    @NotNull
    public abstract CompletableFuture<Void> executeCli(@NotNull AbstractDockerComposeCmdCliBuilder<?> var1) throws ServerRuntimeException;

    @NotNull
    protected abstract List<File> getComposeFiles();

    @Override
    @Nullable
    protected DockerApplicationRuntime.DockerRuntimeNavigatable computeRuntimeNavigatable(@NotNull Project project) {
        File mainFile;
        if (project == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(6);
        }
        VirtualFile virtualFile = (mainFile = (File)ContainerUtil.getFirstItem(this.getComposeFiles())) == null ? null : LocalFileSystem.getInstance().findFileByIoFile(mainFile);
        return virtualFile == null ? null : new DockerApplicationRuntime.DockerRuntimeVirtualFileNavigatable(project, virtualFile);
    }

    @NotNull
    public final List<Path> getComposeFilePaths() {
        List list = ContainerUtil.map(this.getComposeFiles(), File::toPath);
        if (list == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public ComposeServiceRuntime findOrCreateService(@NotNull @NlsSafe String serviceName) {
        ComposeServiceRuntime result;
        if (serviceName == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(8);
        }
        if ((result = this.findService(serviceName)) == null) {
            result = new ComposeServiceRuntime(this, serviceName);
        }
        ComposeServiceRuntime composeServiceRuntime = result;
        if (composeServiceRuntime == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(9);
        }
        return composeServiceRuntime;
    }

    @Nullable
    public ComposeServiceRuntime findService(@NotNull String serviceName) {
        if (serviceName == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(10);
        }
        return (ComposeServiceRuntime)ContainerUtil.find(this.myServiceRuntimes, next -> serviceName.equals(next.getServiceName()));
    }

    protected String[] getAllServiceNames() {
        return (String[])this.myServiceRuntimes.stream().map(ComposeServiceRuntime::getServiceName).toArray(String[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationName";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/ComposeApplicationRuntime";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/ComposeApplicationRuntime";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asDockerRuntime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "requireRuntimeHelper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposeFilePaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "childAdded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "childRemoved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeRuntimeNavigatable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateService";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

