/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remoteRunRuntime;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerConnector;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerPluginDisposable;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.RemoteDockerRuntimeUtil;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.cli.communicator.CliCommunicator;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.ServerTaskExecutorImpl;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Function;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteDockerRuntime {
    private static final Logger LOG = Logger.getInstance(RemoteDockerRuntime.class);
    private static final Map<Pair<DockerCloudConfiguration, Project>, RemoteDockerRuntime> myDockerRuntimeMap = new LinkedHashMap<Pair<DockerCloudConfiguration, Project>, RemoteDockerRuntime>();
    private static final Lock myDockerRuntimeMapLock = new ReentrantLock();
    private final DockerCloudConfiguration myAccount;
    @Nullable
    private final Project myProject;
    private AgentTaskExecutor myAgentTaskExecutor;
    private DockerAgent myDockerAgent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteDockerRuntime create(@NotNull DockerCloudConfiguration config, @Nullable Project project) throws ServerRuntimeException {
        RemoteDockerRuntime dockerRuntime;
        if (config == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(0);
        }
        myDockerRuntimeMapLock.lock();
        try {
            Pair key = Pair.create((Object)((Object)config), (Object)project);
            dockerRuntime = myDockerRuntimeMap.get(key);
            if (dockerRuntime == null) {
                dockerRuntime = new RemoteDockerRuntime(config, project);
                myDockerRuntimeMap.put((Pair<DockerCloudConfiguration, Project>)key, dockerRuntime);
                Disposer.register((Disposable)DockerPluginDisposable.getInstance(project), () -> RemoteDockerRuntime.forgetRuntime((Pair<DockerCloudConfiguration, Project>)key));
            }
        }
        finally {
            myDockerRuntimeMapLock.unlock();
        }
        return dockerRuntime;
    }

    private static void forgetRuntime(Pair<DockerCloudConfiguration, Project> key) {
        myDockerRuntimeMapLock.lock();
        try {
            myDockerRuntimeMap.remove(key);
        }
        finally {
            myDockerRuntimeMapLock.unlock();
        }
    }

    private RemoteDockerRuntime(DockerCloudConfiguration account, @Nullable Project project) throws ServerRuntimeException {
        this.myAccount = account;
        this.myProject = project;
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref errorRef = Ref.create();
        new DockerConnector(account, (ServerTaskExecutor)new ServerTaskExecutorImpl()).connect(new ServerConnector.ConnectionCallback<DockerDeploymentConfiguration>(){

            public void connected(@NotNull ServerRuntimeInstance<DockerDeploymentConfiguration> serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    1.$$$reportNull$$$0(0);
                }
                DockerServerRuntimeInstance dockerServerRuntimeInstance = (DockerServerRuntimeInstance)serverRuntimeInstance;
                RemoteDockerRuntime.this.myDockerAgent = dockerServerRuntimeInstance.getAgent();
                RemoteDockerRuntime.this.myAgentTaskExecutor = dockerServerRuntimeInstance.getAgentTaskExecutor();
                semaphore.up();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                errorRef.set((Object)new ServerRuntimeException(errorMessage));
                semaphore.up();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntimeInstance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/remoteRunRuntime/RemoteDockerRuntime$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        semaphore.waitFor();
        if (!errorRef.isNull()) {
            throw (ServerRuntimeException)((Object)errorRef.get());
        }
    }

    public <T> T executeAgentTask(Computable<T> computable) throws ServerRuntimeException {
        return RemoteDockerRuntimeUtil.executeAgentTask(this.myAgentTaskExecutor, computable);
    }

    public CliCommunicator getDockerCommunicator() {
        return this.getAgent().getCliFacade().createDockerCommunicator();
    }

    public DockerAgent getAgent() {
        return this.myDockerAgent;
    }

    public AgentTaskExecutor getAgentExecutor() {
        return this.myAgentTaskExecutor;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public RemoteDockerApplicationRuntime findContainerByName(String containerName) throws ServerRuntimeException {
        return (RemoteDockerApplicationRuntime)this.createName2ContainerMapping().fun((Object)containerName);
    }

    public Function<String, RemoteDockerApplicationRuntime> createName2ContainerMapping() throws ServerRuntimeException {
        DockerAgentApplication[] applications = this.getContainers();
        return containerName -> {
            for (DockerAgentApplication application : applications) {
                if (application.getContainerNames() == null || !ContainerUtil.exists((Object[])application.getContainerNames(), n -> n != null && n.startsWith("/" + containerName))) continue;
                return RemoteDockerApplicationRuntime.create(this, application);
            }
            return null;
        };
    }

    public DockerAgentApplication[] getContainers() throws ServerRuntimeException {
        return (DockerAgentApplication[])this.executeAgentTask(() -> this.getAgent().getContainers());
    }

    public DockerAgentApplication[] getImages() throws ServerRuntimeException {
        return this.getImages(null);
    }

    public DockerAgentApplication[] getImages(String label) throws ServerRuntimeException {
        return (DockerAgentApplication[])this.executeAgentTask(() -> this.getAgent().getImages(label));
    }

    @Nullable
    public DockerAgentApplication findImageByNameOrId(@NotNull String nameOrId) throws ServerRuntimeException {
        if (nameOrId == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(1);
        }
        return nameOrId.startsWith("sha256:") ? this.findImageByIdPrefix(nameOrId) : this.findImageByName(nameOrId);
    }

    @Nullable
    public DockerAgentApplication findImageByIdPrefix(@NotNull String sha256id) throws ServerRuntimeException {
        if (sha256id == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(2);
        }
        int MINIMAL_LOOKUP_LENGTH = 6;
        String lookup = StringUtil.trimStart((String)sha256id, (String)"sha256:");
        if (lookup.length() < 6) {
            return null;
        }
        for (DockerAgentApplication next : this.getImages()) {
            String actualId;
            String nextId = next.getImageId();
            if (nextId == null || !(actualId = StringUtil.trimStart((String)nextId, (String)"sha256:")).startsWith(lookup)) continue;
            return next;
        }
        return null;
    }

    @Nullable
    public DockerAgentApplication findImageByName(@NotNull String imageName) throws ServerRuntimeException {
        DockerAgentApplication[] applications;
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(3);
        }
        for (DockerAgentApplication application : applications = this.getImages()) {
            for (String imageTag : application.getImageRepoTags()) {
                if (!StringUtil.equals((CharSequence)imageTag, (CharSequence)imageName)) continue;
                return application;
            }
        }
        return null;
    }

    public void pullImage(@NotNull String imageName) throws ServerRuntimeException {
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(4);
        }
        LOG.debug("Pull image {" + imageName + "}");
        try {
            this.doPullImage(imageName);
            LOG.debug("Docker image {" + imageName + "} pulled successfully");
        }
        catch (ServerRuntimeException e) {
            LOG.debug("Failed to pull docker image {" + imageName + "}", (Throwable)e);
            throw e;
        }
    }

    public CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(@NotNull String imageName) {
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(5);
        }
        if (this.myProject == null) {
            throw new NullPointerException();
        }
        DockerAgentRepositoryConfig repositoryConfig = RemoteDockerRuntime.forImageName(imageName);
        return this.getAgent().asyncPullImage(repositoryConfig);
    }

    public CompletableFuture<BlockingQueue<byte[]>> asyncBuildImage(@NotNull DockerAgentDeploymentConfig config) {
        if (config == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(6);
        }
        if (this.myProject == null) {
            throw new NullPointerException();
        }
        return this.getAgent().createImageBuilder().asyncBuildImage(config);
    }

    private void doPullImage(@NotNull String imageName) throws ServerRuntimeException {
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(7);
        }
        final DockerAgentRepositoryConfig repositoryConfig = RemoteDockerRuntime.forImageName(imageName);
        new RegistryRuntimeTask(){

            @Override
            protected OngoingProcess doPerform(DockerAgentProgressCallback progressCallback) {
                return RemoteDockerRuntime.this.getAgent().pullImage(repositoryConfig, progressCallback);
            }
        }.performSync((ServerTaskExecutor)new ServerTaskExecutorImpl(), this.myAgentTaskExecutor, DockerBundle.message("RemoteDockerRuntime.progress.title.pulling.image", imageName));
    }

    public DockerCloudConfiguration getAccount() {
        return this.myAccount;
    }

    private static DockerAgentRepositoryConfig forImageName(String imageName) {
        DockerRepoTag repoTag = DockerRepoTag.fromString((String)imageName);
        return repoTag.toAgentRepositoryConfig();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameOrId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sha256id";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/remoteRunRuntime/RemoteDockerRuntime";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findImageByNameOrId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findImageByIdPrefix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findImageByName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "pullImage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "asyncPullImage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "asyncBuildImage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doPullImage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

