/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry.search;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.search.DockerSearchContext;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J;\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u0002H\u000f0\u0012H\u0000\u00a2\u0006\u0002\b\u0015J1\u0010\u0016\u001a\u0004\u0018\u0001H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0019H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ1\u0010\u001c\u001a\u0004\u0018\u0001H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0019H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lcom/intellij/docker/registry/search/DockerSearchContext;", "", "client", "Ljava/net/http/HttpClient;", "(Ljava/net/http/HttpClient;)V", "getClient$intellij_clouds_docker", "()Ljava/net/http/HttpClient;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "mapper$delegate", "Lkotlin/Lazy;", "executeLater", "Ljava/util/concurrent/CompletableFuture;", "T", "request", "Ljava/net/http/HttpRequest;", "Lkotlin/Function1;", "Ljava/net/http/HttpResponse;", "", "executeLater$intellij_clouds_docker", "parseJSON", "json", "clazz", "Lkotlin/reflect/KClass;", "parseJSON$intellij_clouds_docker", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "parseJSONResource", "resourcePath", "parseJSONResource$intellij_clouds_docker", "BadResponseException", "Companion", "intellij.clouds.docker"})
public final class DockerSearchContext {
    private final Lazy mapper$delegate;
    @NotNull
    private final HttpClient client;
    private static final Lazy LOG$delegate;
    @NotNull
    public static final Companion Companion;

    private final ObjectMapper getMapper() {
        Lazy lazy = this.mapper$delegate;
        DockerSearchContext dockerSearchContext = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ObjectMapper)lazy.getValue();
    }

    @Nullable
    public final <T> T parseJSON$intellij_clouds_docker(@NotNull String json, @NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)this.getMapper().readValue(json, JvmClassMappingKt.getJavaClass(clazz));
    }

    @Nullable
    public final <T> T parseJSONResource$intellij_clouds_docker(@NotNull String resourcePath, @NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            T t;
            URL uRL = DockerSearchContext.class.getResource(resourcePath);
            if (uRL != null) {
                Object object = uRL;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = TextStreamsKt.readBytes((URL)object);
                boolean bl2 = false;
                boolean bl3 = false;
                object = new String(byArray, charset);
                boolean bl4 = false;
                bl = false;
                Object it = object;
                boolean bl5 = false;
                t = this.parseJSON$intellij_clouds_docker((String)it, clazz);
            } else {
                t = null;
            }
            return t;
        }
        catch (IOException e) {
            DockerSearchContext.Companion.getLOG().error("Can't read bundled resource: " + resourcePath, (Throwable)e);
            return null;
        }
    }

    @NotNull
    public final <T> CompletableFuture<T> executeLater$intellij_clouds_docker(@NotNull HttpRequest request, @NotNull Function1<? super HttpResponse<String>, ? extends T> mapper2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(mapper2, (String)"mapper");
        CompletionStage completionStage = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(new Function<HttpResponse<String>, T>(mapper2){
            final /* synthetic */ Function1 $mapper;

            public final T apply(HttpResponse<String> response) {
                int code = response.statusCode();
                if (code < 200 || code >= 300) {
                    HttpRequest httpRequest = response.request();
                    Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"response.request()");
                    throw (Throwable)new BadResponseException(code, httpRequest);
                }
                HttpResponse<String> httpResponse = response;
                Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"response");
                return (T)this.$mapper.invoke(httpResponse);
            }
            {
                this.$mapper = function1;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"client.sendAsync(request\u2026 mapper(response)\n      }");
        return completionStage;
    }

    @NotNull
    public final HttpClient getClient$intellij_clouds_docker() {
        return this.client;
    }

    public DockerSearchContext(@NotNull HttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.mapper$delegate = LazyKt.lazy((Function0)mapper.2.INSTANCE);
    }

    public /* synthetic */ DockerSearchContext(HttpClient httpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HttpClient httpClient2 = HttpClient.newHttpClient();
            Intrinsics.checkNotNullExpressionValue((Object)httpClient2, (String)"HttpClient.newHttpClient()");
            httpClient = httpClient2;
        }
        this(httpClient);
    }

    public DockerSearchContext() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/registry/search/DockerSearchContext$BadResponseException;", "Ljava/io/IOException;", "code", "", "request", "Ljava/net/http/HttpRequest;", "(ILjava/net/http/HttpRequest;)V", "getCode", "()I", "getRequest", "()Ljava/net/http/HttpRequest;", "intellij.clouds.docker"})
    public static final class BadResponseException
    extends IOException {
        private final int code;
        @NotNull
        private final HttpRequest request;

        public final int getCode() {
            return this.code;
        }

        @NotNull
        public final HttpRequest getRequest() {
            return this.request;
        }

        public BadResponseException(int code, @NotNull HttpRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            super(DockerBundle.message("DockerSearchContext.BadResponseException.message", code, request.uri()));
            this.code = code;
            this.request = request;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/registry/search/DockerSearchContext$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "intellij.clouds.docker"})
    public static final class Companion {
        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

