/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.DynamicBundle;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.RegistryAuthCallback;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.DelayedRunner;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRegistryConfigurable
extends NamedConfigurable<DockerRegistry> {
    private JComboBox myAddressComboBox;
    private JTextField myUsernameTextField;
    private JPasswordField myPasswordField;
    private JPanel myMainPanel;
    private JBLabel myConnectionStatusLabel;
    private JComboBox myServerComboBox;
    private final DockerRegistry myRegistry;
    private boolean myNew;
    @Nls
    private String myRegistryName;
    private final DelayedRunner myRunner;
    private ConnectionTester myConnectionTester;

    public DockerRegistryConfigurable(DockerRegistry registry, Runnable treeUpdater, boolean isNew) {
        super(true, treeUpdater);
        this.myRegistry = registry;
        this.myNew = isNew;
        this.$$$setupUI$$$();
        this.myRegistryName = registry.getName();
        this.getAddressComboBox().addItem("registry.hub.docker.com");
        for (String provider : DockerRegistry.PROVIDER_ADDRESSES) {
            this.getAddressComboBox().addItem(provider);
        }
        this.resetAddressComboBox();
        ServerItem toSelect = null;
        ServerConnectionManager connectionManager = ServerConnectionManager.getInstance();
        for (RemoteServer account : RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance())) {
            ServerItem nextItem = new ServerItem(account);
            this.getServerComboBox().addItem(nextItem);
            if (toSelect != null || connectionManager.getConnection(account) == null) continue;
            toSelect = nextItem;
        }
        if (toSelect != null) {
            this.getServerComboBox().setSelectedItem(toSelect);
        }
        this.myRunner = new DelayedRunner(this.myMainPanel){
            private RegistryForComparison myPreviousConfig;
            private RemoteServer<?> myPreviousServer;

            protected boolean wasChanged() {
                RemoteServer<?> currentServer;
                RegistryForComparison currentConfig = new RegistryForComparison();
                try {
                    DockerRegistryConfigurable.this.applyTo(currentConfig);
                }
                catch (ConfigurationException e) {
                    DockerRegistryConfigurable.this.setConnectionStatus("");
                    DockerRegistryConfigurable.this.myConnectionTester = null;
                    return true;
                }
                ServerItem selectedServerItem = (ServerItem)DockerRegistryConfigurable.this.myServerComboBox.getSelectedItem();
                RemoteServer<?> remoteServer = currentServer = selectedServerItem == null ? null : selectedServerItem.getServer();
                if (this.myPreviousConfig != null && DockerRegistryConfigurable.isConfigEqual(this.myPreviousConfig, currentConfig) && this.myPreviousServer != null && this.myPreviousServer == currentServer) {
                    return false;
                }
                DockerRegistryConfigurable.this.myConnectionTester = null;
                DockerRegistryConfigurable.this.setConnectionStatus("");
                this.myPreviousConfig = currentConfig;
                this.myPreviousServer = currentServer;
                return true;
            }

            protected void run() {
                if (!this.myPreviousConfig.hasUserData()) {
                    return;
                }
                DockerRegistryConfigurable.this.setConnectionStatus(DockerBundle.message("docker.registry.configurable.connection.status.connecting", new Object[0]));
                DockerRegistryConfigurable.this.myConnectionTester = new ConnectionTester();
                DockerRegistryConfigurable.this.myConnectionTester.testConnection(this.myPreviousConfig, this.myPreviousServer);
            }
        };
    }

    private JComboBox<String> getAddressComboBox() {
        return this.myAddressComboBox;
    }

    private JComboBox<ServerItem> getServerComboBox() {
        return this.myServerComboBox;
    }

    private void setConnectionStatus(@Nls String text) {
        this.myConnectionStatusLabel.setText(UIUtil.toHtml((String)text));
        this.myConnectionStatusLabel.setVisible(StringUtil.isNotEmpty((String)text));
    }

    private void resetAddressComboBox() {
        this.myAddressComboBox.setSelectedItem(this.myNew ? "registry.hub.docker.com" : this.myRegistry.getAddress());
    }

    private static boolean isConfigEqual(DockerRegistry config1, DockerRegistry config2) {
        return Objects.equals(config1.getAddress(), config2.getAddress()) && Objects.equals(config1.getUsername(), config2.getUsername()) && Objects.equals(config1.getPasswordSafe(), config2.getPasswordSafe()) && Objects.equals(config1.getEmail(), config2.getEmail());
    }

    public boolean isModified() {
        if (this.myNew) {
            return true;
        }
        if (!Objects.equals(this.myRegistry.getName(), this.getDisplayName())) {
            return true;
        }
        RegistryForComparison currentConfig = new RegistryForComparison();
        try {
            this.applyTo(currentConfig);
        }
        catch (ConfigurationException e) {
            return true;
        }
        return !DockerRegistryConfigurable.isConfigEqual(this.myRegistry, currentConfig) || !this.myRegistry.isPasswordSafe();
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.myRegistry);
        this.myNew = false;
    }

    public void reset() {
        this.setDisplayName(DockerRegistryConfigurable.safeTrim(this.myRegistry.getName()));
        this.updateName();
        this.myPasswordField.setText(DockerRegistryConfigurable.safeTrim(this.myRegistry.getPasswordSafe()));
        this.resetAddressComboBox();
        this.myUsernameTextField.setText(DockerRegistryConfigurable.safeTrim(this.myRegistry.getUsername()));
    }

    protected void applyTo(DockerRegistry registry) throws ConfigurationException {
        String address = ((JTextComponent)this.myAddressComboBox.getEditor().getEditorComponent()).getText();
        if (StringUtil.isEmpty((String)address)) {
            throw new RuntimeConfigurationException(DockerBundle.message("DockerRegistryConfigurable.error.address.required", new Object[0]));
        }
        String username = DockerRegistryConfigurable.safeTrim(this.myUsernameTextField.getText());
        if (StringUtil.isEmpty((String)username)) {
            throw new RuntimeConfigurationException(DockerBundle.message("DockerRegistryConfigurable.error.username.required", new Object[0]));
        }
        String password = DockerRegistryConfigurable.safeTrim(new String(this.myPasswordField.getPassword()));
        if (StringUtil.isEmpty((String)password)) {
            throw new RuntimeConfigurationException(DockerBundle.message("DockerRegistryConfigurable.error.password.required", new Object[0]));
        }
        registry.setValuesPack(this.getDisplayName(), address, username, password);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myRunner);
    }

    public void setDisplayName(String name) {
        this.myRegistryName = name;
    }

    public DockerRegistry getEditableObject() {
        return this.myRegistry;
    }

    public String getBannerSlogan() {
        return this.myRegistry.getName();
    }

    public JComponent createOptionsPanel() {
        return this.myMainPanel;
    }

    @Nls
    public String getDisplayName() {
        return this.myRegistryName;
    }

    @Nullable
    public String getHelpTopic() {
        return "Docker_Registry_dialog";
    }

    @NotNull
    private static String safeTrim(@Nullable String text) {
        String string = StringUtil.notNullize((String)text).trim();
        if (string == null) {
            DockerRegistryConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/registry/DockerRegistryConfigurable", "safeTrim"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JPasswordField jPasswordField;
        JTextField jTextField;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 10, 0, 10), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerRegistryConfigurable.class).getString("DockerRegistryConfigurable.address.text"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAddressComboBox = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerRegistryConfigurable.class).getString("DockerRegistryConfigurable.username.text"));
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerRegistryConfigurable.class).getString("DockerRegistryConfigurable.password.text"));
        jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/DockerBundle", DockerRegistryConfigurable.class).getString("DockerRegistryConfigurable.test.connection.text"));
        jPanel.add((Component)titledSeparator, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerRegistryConfigurable.class).getString("DockerRegistryConfigurable.server.text"));
        jPanel.add((Component)jBLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConnectionStatusLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(5, 0, 1, 2, 8, 0, 1, 0, null, null, null));
        this.myServerComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(false);
        jPanel.add(jComboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jBLabel2.setLabelFor(jComboBox2);
        jBLabel3.setLabelFor(jTextField);
        jBLabel4.setLabelFor(jPasswordField);
        jBLabel5.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class RegistryForComparison
    extends DockerRegistry {
        private RegistryForComparison() {
        }

        public void setPasswordSafe(String password) {
            this.setPassword(password);
        }

        public String getPasswordSafe() {
            return this.getPassword();
        }

        @Override
        public void clearPasswordSafe() {
        }
    }

    private static class ServerItem {
        private final RemoteServer<?> myServer;

        ServerItem(RemoteServer<?> server) {
            this.myServer = server;
        }

        public RemoteServer<?> getServer() {
            return this.myServer;
        }

        public String toString() {
            return this.myServer.getName();
        }
    }

    private class ConnectionTester {
        private ConnectionTester() {
        }

        public void testConnection(final DockerRegistry registry, RemoteServer<?> account) {
            final ServerConnection connection = ServerConnectionManager.getInstance().createTemporaryConnection(account);
            final AtomicReference<Object> errorMessageRef = new AtomicReference<Object>(null);
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

                public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                    if (serverRuntimeInstance == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ((DockerServerRuntimeInstance)serverRuntimeInstance).imageRegistryAuth(registry, new RegistryAuthCallback(){

                        public void errorOccurred(@NotNull String errorMessage) {
                            if (errorMessage == null) {
                                ConnectionTester.1.$$$reportNull$$$0(0);
                            }
                            errorMessageRef.set(errorMessage);
                            semaphore.up();
                            connection.disconnect();
                        }

                        @Override
                        public void succeeded() {
                            semaphore.up();
                            connection.disconnect();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/docker/registry/DockerRegistryConfigurable$ConnectionTester$1$1", "errorOccurred"));
                        }
                    });
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    errorMessageRef.set(connection.getStatusText());
                    semaphore.up();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "serverRuntimeInstance";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/docker/registry/DockerRegistryConfigurable$ConnectionTester$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "connected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            new Task.Backgroundable(null, DockerBundle.message("DockerRegistryConfigurable.ConnectionTester.task.title", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    do {
                        if (!indicator.isCanceled()) continue;
                        return;
                    } while (!semaphore.waitFor(500L));
                    UIUtil.invokeLaterIfNeeded(() -> {
                        String errorMessage = (String)errorMessageRef.get();
                        if (DockerRegistryConfigurable.this.myConnectionTester == ConnectionTester.this) {
                            String status = errorMessage == null ? DockerBundle.message("docker.registry.configurable.connection.status.successful", new Object[0]) : DockerBundle.message("docker.registry.configurable.connection.status.cannot.connect", errorMessage);
                            DockerRegistryConfigurable.this.setConnectionStatus(status);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/registry/DockerRegistryConfigurable$ConnectionTester$2", "run"));
                }
            }.queue();
        }
    }
}

