/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerAuthConfigImpl;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRegistry
extends CloudConfigurationBase<DockerRegistry> {
    @Deprecated
    public static final String DOCKER_HUB_ADDRESS = "registry.hub.docker.com";
    public static final String[] PROVIDER_ADDRESSES = new String[]{"quay.io"};
    @Nls
    private String myName;
    @NlsSafe
    private String myAddress;
    @NlsSafe
    private String myUsername;

    @Nls
    public String getName() {
        return this.myName;
    }

    public void setName(@Nls String name) {
        this.myName = name;
    }

    public DockerRegistry withName(@Nls String name) {
        this.setName(name);
        return this;
    }

    @NlsSafe
    public String getAddress() {
        return this.myAddress;
    }

    public void setAddress(String address) {
        this.myAddress = address;
    }

    @Transient
    public void setValuesPack(@Nls String serviceName, String address, String username, String password) {
        if (!(Objects.equals(serviceName, this.myName) && Objects.equals(address, this.myAddress) && Objects.equals(username, this.myUsername))) {
            this.clearPasswordSafe();
        }
        this.myName = serviceName;
        this.myAddress = address;
        this.myUsername = username;
        this.setPasswordSafe(password);
    }

    public void clearPasswordSafe() {
        CredentialAttributes oldAttributes = this.createCredentialAttributes();
        if (oldAttributes != null) {
            PasswordSafe.getInstance().set(oldAttributes, null);
        }
    }

    @NlsSafe
    public String getUsername() {
        return this.myUsername;
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    public DockerAuthConfig getAuthConfig() {
        DockerAuthConfigImpl result = new DockerAuthConfigImpl();
        result.setServerAddress(this.myAddress);
        result.setUsername(this.myUsername);
        result.setPassword(this.getPasswordSafe());
        result.setEmail(this.getEmail());
        return result;
    }

    public boolean hasUserData() {
        return StringUtil.isNotEmpty((String)this.getUsername());
    }

    @Nullable
    protected String getServiceName() {
        String name = this.getName();
        return StringUtil.isEmpty((String)name) ? null : "IntelliJ Platform Docker Registry - " + name;
    }

    protected String getCredentialUser() {
        return this.getUsername();
    }

    public boolean mayContainTag(@NotNull DockerRepoTag tag2) {
        if (tag2 == null) {
            DockerRegistry.$$$reportNull$$$0(0);
        }
        return tag2.isOwnedBy(this.getAddress(), this.getUsername());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/docker/registry/DockerRegistry", "mayContainTag"));
    }
}

