/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.engine;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.engine.DockerEngineUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\t\u001a\b\u0010\r\u001a\u00020\u0001H\u0002\u001a\b\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\t\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u001a\b\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"DOCKER_FOR_LINUX_NETWORK_INTERFACE_NAME", "", "HOST_DOCKER_INTERNAL_DNS_NAME", "INADDR_ANY", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "VIRTUAL_BOX_HOST_IP", "getDockerCloudConfiguration", "Lcom/intellij/docker/DockerCloudConfiguration;", "accountName", "getDockerEngineAddress", "configuration", "getDockerForLinuxHostAddress", "getDockerForMacHostAddress", "getDockerForWindowsHostAddress", "getHostAddress", "getInterfaceHostAddress", "networkInterfaceName", "iterable", "", "Ljava/net/InterfaceAddress;", "getVirtualBoxHostAddress", "isDockerForWindowsLegacyClientConnection", "", "intellij.clouds.docker"})
@JvmName(name="DockerNetworkUtil")
public final class DockerNetworkUtil {
    @NotNull
    public static final String INADDR_ANY = "0.0.0.0";
    private static final String HOST_DOCKER_INTERNAL_DNS_NAME = "host.docker.internal";
    private static final String DOCKER_FOR_LINUX_NETWORK_INTERFACE_NAME = "docker0";
    private static final String VIRTUAL_BOX_HOST_IP = "10.0.2.2";
    private static final Logger LOG;

    @NotNull
    public static final String getHostAddress(@NotNull DockerCloudConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        if (DockerEngineUtil.isUnixSocket(configuration)) {
            if (SystemInfo.isWindows) {
                throw (Throwable)new IllegalStateException("Unix domain socket " + configuration.getApiUrl() + " is not supported on Windows");
            }
            if (SystemInfo.isMac) {
                return DockerNetworkUtil.getDockerForMacHostAddress();
            }
            return DockerNetworkUtil.getDockerForLinuxHostAddress();
        }
        if (configuration.getMachine() != null) {
            return DockerNetworkUtil.getVirtualBoxHostAddress();
        }
        if (DockerNetworkUtil.isDockerForWindowsLegacyClientConnection(configuration)) {
            return DockerNetworkUtil.getDockerForWindowsHostAddress();
        }
        throw (Throwable)new IllegalStateException("Host address cannot be detected for " + configuration.getApiUrl() + " Docker connection");
    }

    private static final String getDockerForLinuxHostAddress() {
        String address = DockerNetworkUtil.getInterfaceHostAddress(DOCKER_FOR_LINUX_NETWORK_INTERFACE_NAME);
        LOG.debug("Using " + address + " host machine address taken from docker0 network interface");
        return address;
    }

    private static final String getDockerForMacHostAddress() {
        LOG.debug("Using host.docker.internal host machine address available for Docker for Mac 18.03+");
        return HOST_DOCKER_INTERNAL_DNS_NAME;
    }

    private static final String getVirtualBoxHostAddress() {
        LOG.debug("Using VirtualBox host machine default IP address 10.0.2.2");
        return VIRTUAL_BOX_HOST_IP;
    }

    @NotNull
    public static final String getDockerForWindowsHostAddress() {
        LOG.debug("Using host.docker.internal host machine address available for Docker Desktop for Windows 18.03+");
        return HOST_DOCKER_INTERNAL_DNS_NAME;
    }

    public static final boolean isDockerForWindowsLegacyClientConnection(@NotNull DockerCloudConfiguration configuration) {
        block5: {
            String string;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
                    if (!SystemInfo.isWindows) break block5;
                    string = configuration.getApiUrl();
                    if (string == null) break block6;
                    String string2 = string;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                    string = string4;
                    if (string4 != null) break block7;
                }
                return false;
            }
            String apiUrl = string;
            if (StringsKt.contains$default((CharSequence)apiUrl, (CharSequence)"127.0.0.1:2375", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)apiUrl, (CharSequence)"localhost:2375", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static final DockerCloudConfiguration getDockerCloudConfiguration(@Nullable String accountName) {
        if (accountName == null || StringsKt.isBlank((CharSequence)accountName)) {
            throw (Throwable)new IllegalStateException("Docker account not specified");
        }
        RemoteServer remoteServer = RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        if (remoteServer == null) {
            throw (Throwable)new IllegalStateException("Docker account not found");
        }
        Intrinsics.checkNotNullExpressionValue((Object)remoteServer, (String)"RemoteServersManager.get\u2026ocker account not found\")");
        RemoteServer server = remoteServer;
        ServerConfiguration serverConfiguration = server.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"server.configuration");
        return (DockerCloudConfiguration)serverConfiguration;
    }

    @NotNull
    public static final String getInterfaceHostAddress(@NotNull String networkInterfaceName) throws SocketException {
        Intrinsics.checkNotNullParameter((Object)networkInterfaceName, (String)"networkInterfaceName");
        NetworkInterface networkInterface = NetworkInterface.getByName(networkInterfaceName);
        if (networkInterface == null) {
            throw (Throwable)new IllegalStateException("Network interface " + networkInterfaceName + " could not be found");
        }
        NetworkInterface networkInterface2 = networkInterface;
        List<InterfaceAddress> list = networkInterface2.getInterfaceAddresses();
        Intrinsics.checkNotNullExpressionValue(list, (String)"networkInterface.interfaceAddresses");
        String string = DockerNetworkUtil.getInterfaceHostAddress((Iterable<? extends InterfaceAddress>)list);
        if (string == null) {
            throw (Throwable)new IllegalStateException("Host address for network interface " + networkInterfaceName + " is absent");
        }
        return string;
    }

    private static final String getInterfaceHostAddress(Iterable<? extends InterfaceAddress> iterable) {
        String resultAddress = null;
        for (InterfaceAddress interfaceAddress : iterable) {
            if (interfaceAddress.getBroadcast() != null) {
                InetAddress inetAddress = interfaceAddress.getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"address.address");
                return inetAddress.getHostAddress();
            }
            InetAddress inetAddress = interfaceAddress.getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"address.address");
            resultAddress = inetAddress.getHostAddress();
        }
        return resultAddress;
    }

    @Nullable
    public static final String getDockerEngineAddress(@NotNull DockerCloudConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        String string = configuration.getApiUrl();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("Docker Engine API URL must be specified");
        }
        String apiUrl = string;
        if (DockerEngineUtil.isUnixSocket(configuration)) {
            if (SystemInfo.isWindows) {
                throw (Throwable)new IllegalStateException("Unix domain socket " + apiUrl + " is not supported on Windows");
            }
            return null;
        }
        return new URI(apiUrl).getHost();
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.docker.engine.DockerNetworkUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026ngine.DockerNetworkUtil\")");
        LOG = logger;
    }
}

