/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.text.StringKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"checkComposeFile", "", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "checkEnvFile", "checkTimeout", "toValidationInfo", "Lcom/intellij/openapi/ui/ValidationInfo;", "", "intellij.clouds.docker"})
public final class DockerComposeDeploymentValidationKt {
    @Nullable
    public static final ValidationInfo toValidationInfo(@Nullable Throwable $this$toValidationInfo) {
        ValidationInfo validationInfo;
        Object object = $this$toValidationInfo;
        if (object != null && (object = ((Throwable)object).getMessage()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            validationInfo = new ValidationInfo((String)it);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    public static final void checkEnvFile(@NotNull DockerDeploymentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        String string = config.getEnvFilePath();
        if (string == null || (string = StringKt.nullize((String)string, (boolean)true)) == null) {
            return;
        }
        String path = string;
        File file2 = new File(path);
        if (!file2.exists()) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.env.file.does.not.exist", file2.getAbsolutePath()));
        }
        if (file2.isDirectory()) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.env.file.not.valid", file2.getAbsolutePath()));
        }
    }

    public static final void checkTimeout(@NotNull DockerDeploymentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        String timeout = config.getUpTimeout();
        CharSequence charSequence = timeout;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        if (StringsKt.toIntOrNull((String)timeout) == null) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.up.timeout.dialog.message.not.valid.integer", timeout));
        }
        charSequence = timeout;
        bl = false;
        if (Integer.parseInt((String)charSequence) < 0) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.up.timeout.dialog.message.timeout.cannot.be.less", new Object[0]));
        }
        charSequence = timeout;
        bl = false;
        if (Integer.parseInt((String)charSequence) > 1000) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.up.timeout.dialog.message.timeout.cannot.be.greater", new Object[0]));
        }
    }

    public static final void checkComposeFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        File composeFile = DockerDeploymentConfigurationUtilsKt.getSourceFile(project, config);
        if (composeFile == null) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentSourceType.error.path.required", new Object[0]));
        }
        if (!composeFile.exists() || !composeFile.isFile()) {
            throw (Throwable)new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentSourceType.error.file.does.not.exist", composeFile));
        }
    }
}

