/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.DockerFileSearch;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerDeploymentSourcePathCombo
extends ComboBox<String> {
    private final List<Runnable> myActionList = new CopyOnWriteArrayList<Runnable>();

    public static DockerDeploymentSourcePathCombo createAndFillForProject(@NotNull Project project) {
        if (project == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(0);
        }
        DockerDeploymentSourcePathCombo result = new DockerDeploymentSourcePathCombo();
        result.addBrowseFolderActionListener(project, DockerBundle.message("DockerDeploymentSourcePathCombo.dialogTitle", new Object[0]), DockerBundle.message("DockerDeploymentSourcePathCombo.dialogDescription", new Object[0]), FileChooserDescriptorFactory.createSingleFileDescriptor());
        for (VirtualFile nextDockerfile : DockerFileSearch.getInstance().getDockerFiles(project)) {
            result.addPredefinedFile(project, nextDockerfile);
        }
        return result;
    }

    public DockerDeploymentSourcePathCombo() {
        this.initBrowsableEditor(() -> {
            for (Runnable runnable : this.myActionList) {
                runnable.run();
            }
        }, null);
    }

    public void applyUiTo(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(1);
        }
        configuration.setSourceFilePath(this.getValueToApply());
    }

    @Nullable
    public String getValueToApply() {
        String displayPath = (String)this.getEditor().getItem();
        return displayPath == null ? null : FileUtil.toSystemIndependentName((String)displayPath);
    }

    public void resetUiFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(2);
        }
        this.resetUiFrom(configuration.getSourceFilePath());
    }

    public void resetUiFrom(@Nullable String sourceFilePath) {
        String sourcePath = Optional.ofNullable(sourceFilePath).filter(path -> !StringUtil.isEmptyOrSpaces((String)path)).map(FileUtil::toSystemDependentName).orElse(null);
        this.setSelectedItem(sourcePath);
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(3);
        }
        ((JTextField)this.getEditor().getEditorComponent()).getDocument().addDocumentListener(listener);
    }

    public void addPredefinedFile(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(5);
        }
        String nextDisplayPath = this.getPathToDisplay(project, file2);
        this.addItem(nextDisplayPath);
    }

    public void addBrowseFolderActionListener(final @NotNull Project project, @NotNull @Nls String title, @NotNull @Nls String description, @NotNull FileChooserDescriptor fileChooserDescriptor) {
        if (project == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(6);
        }
        if (title == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(7);
        }
        if (description == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(8);
        }
        if (fileChooserDescriptor == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(9);
        }
        BrowseFolderRunnable<JComboBox> action = new BrowseFolderRunnable<JComboBox>(title, description, project, fileChooserDescriptor, (JComboBox)((Object)this), TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = DockerDeploymentSourcePathCombo.this.getPathToDisplay(project, chosenFile);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile defaultResult = project.getBaseDir();
                String currentValue = this.getComponentText();
                if (StringUtil.isEmptyOrSpaces((String)currentValue)) {
                    return defaultResult;
                }
                File ioFile = DockerDeploymentConfigurationUtilsKt.getSourceFile(project, currentValue);
                if (ioFile == null) {
                    return defaultResult;
                }
                return LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/docker/deployment/ui/DockerDeploymentSourcePathCombo$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/docker/deployment/ui/DockerDeploymentSourcePathCombo$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myActionList.add((Runnable)action);
    }

    @NotNull
    @NlsSafe
    public String getPathToDisplay(@NotNull Project project, @NotNull VirtualFile chosenFile) {
        if (project == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(10);
        }
        if (chosenFile == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(11);
        }
        String storeable = DockerDeploymentConfigurationUtilsKt.getPathToStore(project, chosenFile);
        String string = FileUtil.toSystemDependentName((String)storeable);
        if (string == null) {
            DockerDeploymentSourcePathCombo.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooserDescriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerDeploymentSourcePathCombo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerDeploymentSourcePathCombo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToDisplay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndFillForProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyUiTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetUiFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseFolderActionListener";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPathToDisplay";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

