/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.DynamicBundle;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.agent.cli.CliParserBase;
import com.intellij.docker.cli.DockerBuildCliBuilder;
import com.intellij.docker.cli.DockerBuildCliValidator;
import com.intellij.docker.cli.NormalizedCommandLine;
import com.intellij.docker.cli.model.DockerCliOption;
import com.intellij.docker.cli.model.DockerCliOptionsModel;
import com.intellij.docker.deployment.ui.DockerCliOptionsField;
import com.intellij.docker.deployment.ui.DockerDeploymentSourcePathCombo;
import com.intellij.docker.deployment.ui.DockerEnvVarFieldWithBrowseButton;
import com.intellij.docker.deployment.ui.DockerFileAndContextFolderUI;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class DockerBuildSettingsUI {
    private final Project myProject;
    private JPanel myMainPanel;
    private JTextField myImageTextField;
    private ComboBox mySourcePathCombo;
    private TextFieldWithBrowseButton myBuildArgsField;
    private TextFieldWithBrowseButton myContextFolderField;
    private TextFieldWithCompletion myBuildCliOptionsField;
    private JBCheckBox myEnableBuildKit;
    private DockerFileAndContextFolderUI myDockerFileAndContextFolder;

    public DockerBuildSettingsUI(@NotNull Project project) {
        if (project == null) {
            DockerBuildSettingsUI.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    public void setContextFolderListener(@NotNull Consumer<File> listener) {
        if (listener == null) {
            DockerBuildSettingsUI.$$$reportNull$$$0(1);
        }
        this.myDockerFileAndContextFolder.setContextFolderListener(listener::accept);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerBuildSettingsUI.$$$reportNull$$$0(2);
        }
        this.myDockerFileAndContextFolder.resetUIFrom(configuration);
        this.myImageTextField.setText(configuration.getAllImageTagsJoined());
        this.getBuildArgsField().setEnvVars(configuration.getBuildArgs());
        this.getBuildCliOptionsField().resetEditorFrom(configuration);
        this.myEnableBuildKit.setSelected(configuration.isBuildKitEnabled());
    }

    public void applyEditorTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerBuildSettingsUI.$$$reportNull$$$0(3);
        }
        this.myDockerFileAndContextFolder.applyUITo(configuration);
        configuration.setAllImageTagsJoined(this.myImageTextField.getText());
        configuration.setBuildArgs(this.getBuildArgsField().getEnvVars());
        this.getBuildCliOptionsField().applyValueTo(configuration);
        configuration.setBuildKitEnabled(this.myEnableBuildKit.isSelected());
    }

    public DockerBuildCliBuilder prepareBuildCliBuilder() {
        DockerBuildCliBuilder builder = new DockerBuildCliBuilder();
        builder.setDockerFile(this.getSourcePathCombo().getValueToApply());
        builder.setEnableBuildKit(this.myEnableBuildKit.isSelected());
        for (Map.Entry<String, String> argEntry : this.getBuildArgsField().getPairs().entrySet()) {
            if (argEntry.getKey() == null) continue;
            builder.addBuildArg(argEntry.getKey(), argEntry.getValue());
        }
        for (String tag2 : DockerDeploymentConfigurationUtilsKt.splitTags(this.getNotEmptyImageTag())) {
            builder.addImageTag(tag2);
        }
        try {
            NormalizedCommandLine userOptions = this.getBuildCliOptionsField().getParsedOptions();
            if (userOptions != null) {
                builder.setCustomBuildOptions(userOptions);
            }
        }
        catch (CliParserBase.IllegalOptionException | ParseException throwable) {
            // empty catch block
        }
        return builder;
    }

    @NotNull
    public String getNotEmptyImageTag() {
        String imageTag = this.myImageTextField.getText();
        String string = StringUtil.isEmptyOrSpaces((String)imageTag) ? "<image_tag>" : imageTag;
        if (string == null) {
            DockerBuildSettingsUI.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void createUIComponents() {
        this.myBuildArgsField = new BuildArgsField();
        this.myDockerFileAndContextFolder = new DockerFileAndContextFolderUI(this.myProject);
        this.mySourcePathCombo = this.myDockerFileAndContextFolder.getSourcePathCombo();
        this.myContextFolderField = this.myDockerFileAndContextFolder.getContextFolderField();
        this.myBuildCliOptionsField = new DockerBuildOptionsField(this.myProject);
    }

    private DockerBuildOptionsField getBuildCliOptionsField() {
        return (DockerBuildOptionsField)this.myBuildCliOptionsField;
    }

    private DockerDeploymentSourcePathCombo getSourcePathCombo() {
        return (DockerDeploymentSourcePathCombo)this.mySourcePathCombo;
    }

    private BuildArgsField getBuildArgsField() {
        return (BuildArgsField)this.myBuildArgsField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerBuildSettingsUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerBuildSettingsUI";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotEmptyImageTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setContextFolderListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerBuildSettingsUI.class).getString("DockerBuildSettingsUI.dockerfile.text"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox comboBox = this.mySourcePathCombo;
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerBuildSettingsUI.class).getString("DockerBuildSettingsUI.image.tag.text"));
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImageTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerBuildSettingsUI.class).getString("DockerBuildSettingsUI.build.args.text"));
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myBuildArgsField;
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myContextFolderField;
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerBuildSettingsUI.class).getString("DockerBuildSettingsUI.context.folder.text"));
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerBuildSettingsUI.class).getString("DockerBuildSettingsUI.build.options.text"));
        jPanel.add((Component)jBLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithCompletion textFieldWithCompletion = this.myBuildCliOptionsField;
        jPanel.add((Component)textFieldWithCompletion, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myEnableBuildKit = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerBuildSettingsUI.class).getString("DockerBuildSettingsUI.enable.buildkit.experimental"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)comboBox);
        jBLabel2.setLabelFor(jTextField);
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel3.setLabelFor((Component)textFieldWithBrowseButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class DockerBuildOptionsField
    extends DockerCliOptionsField {
        private static final Map<String, DockerCliOption> MODEL = DockerCliOptionsModel.INSTANCE.getDockerBuildOptions();

        public DockerBuildOptionsField(Project project) {
            super(project, new DockerBuildCliValidator(), MODEL);
        }

        @Override
        protected void storeRawText(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                DockerBuildOptionsField.$$$reportNull$$$0(0);
            }
            configuration.setBuildCliOptions(this.getText());
        }

        @Override
        public void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                DockerBuildOptionsField.$$$reportNull$$$0(1);
            }
            String optionsLine = configuration.getBuildCliOptions();
            this.setText(optionsLine);
        }

        @Override
        public void clearValue(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                DockerBuildOptionsField.$$$reportNull$$$0(2);
            }
            configuration.setBuildCliOptions(null);
        }

        @Override
        protected void handleParseException(ParseException e) throws ConfigurationException {
            throw new RuntimeConfigurationWarning(DockerBundle.message("DockerBuildSettingsUI.DockerBuildOptionsField.onParseError", e.getMessage()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "configuration";
            objectArray2[1] = "com/intellij/docker/deployment/ui/DockerBuildSettingsUI$DockerBuildOptionsField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "storeRawText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resetEditorFrom";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clearValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class BuildArgsField
    extends DockerEnvVarFieldWithBrowseButton {
        BuildArgsField() {
            super(DockerBundle.message("DockerBuildSettingsUI.BuildArgsField.dialogTitle", new Object[0]), DockerBundle.message("DockerBuildSettingsUI.BuildArgsField.dialogEmptyText", new Object[0]));
        }
    }
}

