/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeUpCliBuilder;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfigurationBuilder;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposeServiceUpCmd
extends AbstractServiceCmd<ComposeServiceUpCmd> {
    @Nullable
    private List<String> myServiceNames;

    public ComposeServiceUpCmd(@NotNull RemoteDockerRuntime dockerRuntime) {
        if (dockerRuntime == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(0);
        }
        super(dockerRuntime);
    }

    @Override
    @NotNull
    public KillableColoredProcessHandler execute() throws IOException, ExecutionException {
        KillableColoredProcessHandler killableColoredProcessHandler = this.createBuilder().run();
        if (killableColoredProcessHandler == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(1);
        }
        return killableColoredProcessHandler;
    }

    @Override
    @NotNull
    public GeneralCommandLine buildCommandLine() throws IOException {
        GeneralCommandLine generalCommandLine = this.createBuilder().buildCommandLine();
        if (generalCommandLine == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(2);
        }
        return generalCommandLine;
    }

    @NotNull
    private DockerComposeUpCliBuilder createBuilder() throws IOException {
        if (ContainerUtil.isEmpty(this.getConfigurationPaths())) {
            throw new IllegalArgumentException(DockerBundle.message("ComposeServiceUpCmd.error.path.required", new Object[0]));
        }
        if (StringUtil.isEmpty((String)this.getServiceName())) {
            throw new IllegalArgumentException(DockerBundle.message("ComposeServiceUpCmd.error.service.required", new Object[0]));
        }
        List<Path> paths = DockerComposeConfigurationUtil.findConfigurationFiles(this.getConfigurationPaths());
        Set<String> namedVolumes = ServiceCmdExecUtils.collectNamedVolumes(this.getVolumesBinding());
        DockerComposeConfigurationBuilder<?, ?, ?> configurationBuilder = ServiceCmdExecUtils.createConfigurationBuilder(paths, namedVolumes);
        if (!ArrayUtil.isEmpty((Object[])this.getVolumesFrom())) {
            ServiceCmdExecUtils.assertVolumesFromOptionSupported(configurationBuilder);
        }
        Object serviceBuilder = configurationBuilder.addService(this.getServiceName());
        String[] entrypoint = this.getEntrypoint();
        if (entrypoint != null) {
            serviceBuilder.withEntrypoint(entrypoint);
        }
        serviceBuilder.withCommand(this.getCommand()).withWorkingDir(this.getWorkingDir()).withEnvironment(DockerComposeConfigurationUtil.escapeDollarSigns(this.getEnvironment())).withVolumesFrom(this.getVolumesFrom()).withBindVolumes(this.getVolumesBinding()).withPorts(this.getPorts()).withUser(this.getUser()).withRestartPolicy(this.getRestartPolicy()).withStdinOpen(true);
        ServiceCmdExecUtils.setupSharedVolume(configurationBuilder, serviceBuilder, this, paths, this.getVolumesBinding());
        Object override = configurationBuilder.build();
        File tempFile = ServiceCmdExecUtils.writeDockerComposeOverrideYml(override);
        ImmutableList.Builder withTempFile = ImmutableList.builder();
        withTempFile.addAll(paths);
        withTempFile.add((Object)tempFile.toPath());
        DockerComposeUpCliBuilder builder = ((DockerComposeUpCliBuilder)((DockerComposeUpCliBuilder)((DockerComposeUpCliBuilder)DockerComposeCliUtil.buildUpCommand(this.getDockerRuntime()).withEnvironment((Map<String, String>)this.getEnvs())).withFiles((List<Path>)withTempFile.build())).withSubcommandOptions(this.getSubcommandOptions())).withServices(this.getEffectiveServices()).withDetached(this.isDetached());
        if (this.getSubcommandOptions() == null && !this.isDetached()) {
            builder.withExitCodeFrom(this.getServiceName());
        }
        DockerComposeUpCliBuilder dockerComposeUpCliBuilder = builder;
        if (dockerComposeUpCliBuilder == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(3);
        }
        return dockerComposeUpCliBuilder;
    }

    private String @NotNull [] getEffectiveServices() {
        List<String> serviceNames = this.getServiceNames();
        if (serviceNames == null) {
            String[] stringArray = new String[]{this.getServiceName()};
            if (stringArray == null) {
                ComposeServiceUpCmd.$$$reportNull$$$0(4);
            }
            return stringArray;
        }
        String[] stringArray = ArrayUtilRt.toStringArray(serviceNames);
        if (stringArray == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Override
    @NotNull
    protected ComposeServiceUpCmd getThis() {
        ComposeServiceUpCmd composeServiceUpCmd = this;
        if (composeServiceUpCmd == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(6);
        }
        return composeServiceUpCmd;
    }

    @Nullable
    public List<String> getServiceNames() {
        return this.myServiceNames;
    }

    @NotNull
    public ComposeServiceUpCmd withServiceNames(@Nullable List<String> serviceNames) {
        this.myServiceNames = serviceNames;
        ComposeServiceUpCmd composeServiceUpCmd = this.getThis();
        if (composeServiceUpCmd == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(7);
        }
        return composeServiceUpCmd;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/service/commands/ComposeServiceUpCmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/service/commands/ComposeServiceUpCmd";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveServices";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getThis";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withServiceNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

