/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.parse;

import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.parse.CachingDockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.parse.CachingFilesSupplier;
import com.intellij.docker.compose.configuration.beans.parse.PureDockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.parse.ToolBasedDockerComposeConfigurationParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerComposeConfigurationParserUtil {
    private static final Logger LOG = Logger.getInstance(DockerComposeConfigurationParserUtil.class);
    public static final String VERSION_3 = "3";
    static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+)(\\.\\d+)?");
    private static DockerComposeConfigurationParser ourInstance;
    private static final Object ourInstanceCreationMonitor;
    private static final CachingFilesSupplier<String> cachedComposeFileVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DockerComposeConfigurationParser defaultParserForUi() {
        Object object = ourInstanceCreationMonitor;
        synchronized (object) {
            if (ourInstance == null) {
                ourInstance = new CachingDockerComposeConfigurationParser(new ToolBasedDockerComposeConfigurationParser(PureDockerComposeConfigurationParser.getInstance()));
            }
            return ourInstance;
        }
    }

    public static String parseVersion(@NotNull String path) throws IOException {
        if (path == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(0);
        }
        return cachedComposeFileVersion.fun(Collections.singletonList(path));
    }

    @Nullable
    public static String getMajorVersion(@NotNull String version) {
        Matcher matcher;
        if (version == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(1);
        }
        return (matcher = VERSION_PATTERN.matcher(version)).matches() ? matcher.group("major") : null;
    }

    public static void saveDockerComposeFiles(@NotNull List<String> dockerComposeFilePaths) {
        if (dockerComposeFilePaths == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(2);
        }
        DockerComposeConfigurationParserUtil.saveDockerComposeFiles(dockerComposeFilePaths, ModalityState.defaultModalityState());
    }

    public static void saveDockerComposeFiles(@NotNull List<String> dockerComposeFilePaths, @NotNull ModalityState modalityState) {
        if (dockerComposeFilePaths == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(3);
        }
        if (modalityState == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileDocumentManager documentManager = FileDocumentManager.getInstance();
            List documents = (List)ReadAction.compute(() -> {
                ArrayList<Document> list = new ArrayList<Document>();
                LocalFileSystem fs = LocalFileSystem.getInstance();
                for (String path : dockerComposeFilePaths) {
                    VirtualFile file2 = fs.findFileByPath(path);
                    if (file2 == null) continue;
                    list.add(documentManager.getDocument(file2));
                }
                return list;
            });
            if (!documents.isEmpty()) {
                WriteAction.runAndWait(() -> {
                    for (Document document : documents) {
                        if (!documentManager.isDocumentUnsaved(document)) continue;
                        documentManager.saveDocument(document);
                    }
                });
            }
        }, modalityState);
    }

    static {
        ourInstanceCreationMonitor = new Object();
        cachedComposeFileVersion = new CachingFilesSupplier(composeFiles -> {
            FileDocumentManager fileDocumentManager;
            Document document;
            Path path = Paths.get((String)composeFiles.get(0), new String[0]);
            VirtualFile virtualFile = VfsUtil.findFile((Path)path, (boolean)true);
            if (virtualFile != null && (document = (fileDocumentManager = FileDocumentManager.getInstance()).getCachedDocument(virtualFile)) != null && fileDocumentManager.isDocumentUnsaved(document)) {
                LOG.error(String.format("The document for the file %s is unsaved. It must be saved in advance.", path));
            }
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path.toFile()), StandardCharsets.UTF_8);){
                String string = PureDockerComposeConfigurationParser.getInstance().parseVersion(reader);
                return string;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeFilePaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/compose/configuration/beans/parse/DockerComposeConfigurationParserUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMajorVersion";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "saveDockerComposeFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

