/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.common;

import com.google.common.collect.Lists;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.compose.configuration.beans.common.AccessMode;
import com.intellij.docker.compose.configuration.beans.common.DefinedDockerComposePort;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeCommand;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeEnvFile;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePortVariant;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBase;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeServiceBuilder;
import com.intellij.docker.compose.configuration.beans.common.RestartPolicy;
import com.intellij.docker.compose.configuration.beans.common.ServiceVolume;
import com.intellij.docker.compose.configuration.beans.common.ServiceVolumeShortSyntax;
import com.intellij.docker.compose.configuration.beans.v2.DependsOn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerComposeServiceBuilderBase<T extends DockerComposeServiceBuilderBase, R extends DockerComposeServiceBase>
implements DockerComposeServiceBuilder<T, R> {
    private String myImage;
    private List<String> myLinks;
    private DependsOn myDependsOn;
    private String myWorkingDir;
    private DockerComposeCommand myEntrypoint;
    private DockerComposeCommand myCommand;
    private Map<String, String> myEnvironment;
    private String myNetworkMode;
    private DockerComposeEnvFile myEnvFile;
    private String myUser;
    private RestartPolicy myRestartPolicy;
    private Boolean myStdinOpen;
    private List<DockerComposePortVariant> myPorts;
    private List<ServiceVolume> myVolumes;

    @NotNull
    public T withImage(@NotNull String val) {
        if (val == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(0);
        }
        this.myImage = val;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(1);
        }
        return t;
    }

    @NotNull
    public T withLinks(@NotNull List<String> val) {
        if (val == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(2);
        }
        this.myLinks = val;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(3);
        }
        return t;
    }

    @NotNull
    public T withDependsOn(@Nullable DependsOn dependsOn) {
        this.myDependsOn = dependsOn;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(4);
        }
        return t;
    }

    @Override
    @NotNull
    public T withDependsOn(@Nullable List<String> val) {
        this.myDependsOn = val != null ? new DependsOn(val) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(5);
        }
        return t;
    }

    @Override
    @NotNull
    public T withWorkingDir(@Nullable String workingDir) {
        this.myWorkingDir = workingDir;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Override
    @NotNull
    public T withEntrypoint(String ... command) {
        this.myEntrypoint = command != null ? new DockerComposeCommand(Arrays.asList(command)) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(7);
        }
        return t;
    }

    @Override
    @NotNull
    public T withEntrypointLine(@Nullable String command) {
        this.myEntrypoint = command != null ? new DockerComposeCommand(command) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(8);
        }
        return t;
    }

    @Override
    @NotNull
    public T withCommand(String ... command) {
        this.myCommand = command != null ? new DockerComposeCommand(Arrays.asList(command)) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(9);
        }
        return t;
    }

    @Override
    @NotNull
    public T withCommandLine(@Nullable String command) {
        this.myCommand = command != null ? new DockerComposeCommand(command) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(10);
        }
        return t;
    }

    @Override
    @NotNull
    public T withEnvironment(@Nullable Map<String, String> environment) {
        this.myEnvironment = environment;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(11);
        }
        return t;
    }

    @Override
    @NotNull
    public T withUser(@Nullable String user) {
        this.myUser = user;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(12);
        }
        return t;
    }

    @Override
    @NotNull
    public T withRestartPolicy(@Nullable RestartPolicy restartPolicy) {
        this.myRestartPolicy = restartPolicy;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(13);
        }
        return t;
    }

    @Override
    @NotNull
    public T withNetworkMode(@Nullable String networkMode) {
        this.myNetworkMode = networkMode;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(14);
        }
        return t;
    }

    @NotNull
    public T withEnvFiles(String ... envFiles) {
        this.myEnvFile = envFiles != null ? new DockerComposeEnvFile(Arrays.asList(envFiles)) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(15);
        }
        return t;
    }

    @Override
    @NotNull
    public T withStdinOpen(@Nullable Boolean stdinOpen) {
        this.myStdinOpen = stdinOpen;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(16);
        }
        return t;
    }

    @Override
    @NotNull
    public T withPorts(@Nullable List<DockerComposePort> ports) {
        this.myPorts = ports != null ? ContainerUtil.map(ports, DefinedDockerComposePort::new) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(17);
        }
        return t;
    }

    @NotNull
    public T withPorts(String ... ports) {
        this.myPorts = ports.length == 0 ? null : ContainerUtil.map((Object[])ports, DockerComposePortVariant::fromString);
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(18);
        }
        return t;
    }

    @Override
    @NotNull
    public T withBindVolumes(DockerVolumeBinding @Nullable [] volumeBindings) {
        List<Object> volumeBindingsList = volumeBindings == null ? Collections.emptyList() : Arrays.asList(volumeBindings);
        this.myVolumes = Lists.transform(volumeBindingsList, volume -> {
            StringBuilder stringBuilder = new StringBuilder();
            if (!StringUtil.isEmpty((String)volume.getHostPath())) {
                stringBuilder.append(volume.getHostPath()).append(":");
            }
            stringBuilder.append(volume.getContainerPath());
            if (!StringUtil.isEmpty((String)volume.getHostPath()) && !volume.isReadOnly()) {
                stringBuilder.append(":").append(AccessMode.RW.getCode());
            }
            return ServiceVolumeShortSyntax.parse(stringBuilder.toString());
        });
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(19);
        }
        return t;
    }

    @NotNull
    public T addVolume(@NotNull ServiceVolume volume) {
        if (volume == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(20);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<ServiceVolume>();
        }
        this.myVolumes.add(volume);
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(21);
        }
        return t;
    }

    @NotNull
    public T addVolume(@NotNull String containerPath) {
        if (containerPath == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(22);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<ServiceVolume>();
        }
        this.myVolumes.add(ServiceVolumeShortSyntax.fromParts(containerPath));
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(23);
        }
        return t;
    }

    @NotNull
    public T addVolume(@NotNull String hostPath, @NotNull String containerPath) {
        if (hostPath == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(24);
        }
        if (containerPath == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(25);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<ServiceVolume>();
        }
        this.myVolumes.add(ServiceVolumeShortSyntax.fromParts(hostPath, containerPath));
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(26);
        }
        return t;
    }

    @NotNull
    public T addVolume(@NotNull String hostPath, @NotNull String containerPath, @NotNull AccessMode accessMode) {
        if (hostPath == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(27);
        }
        if (containerPath == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(28);
        }
        if (accessMode == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(29);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<ServiceVolume>();
        }
        this.myVolumes.add(ServiceVolumeShortSyntax.fromParts(hostPath, containerPath, accessMode));
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(30);
        }
        return t;
    }

    @Override
    @NotNull
    public final R build() {
        R serviceBean = this.createServiceBean();
        ((DockerComposeServiceBase)serviceBean).setImage(this.myImage);
        ((DockerComposeServiceBase)serviceBean).setLinks(this.myLinks);
        ((DockerComposeServiceBase)serviceBean).setDependsOn(this.myDependsOn);
        ((DockerComposeServiceBase)serviceBean).setWorkingDir(this.myWorkingDir);
        ((DockerComposeServiceBase)serviceBean).setEntrypoint(this.myEntrypoint);
        ((DockerComposeServiceBase)serviceBean).setCommand(this.myCommand);
        ((DockerComposeServiceBase)serviceBean).setEnvironment(this.myEnvironment);
        ((DockerComposeServiceBase)serviceBean).setNetworkMode(this.myNetworkMode);
        ((DockerComposeServiceBase)serviceBean).setEnvFile(this.myEnvFile);
        ((DockerComposeServiceBase)serviceBean).setUser(this.myUser);
        ((DockerComposeServiceBase)serviceBean).setRestart(this.myRestartPolicy != null ? this.myRestartPolicy.toString() : null);
        ((DockerComposeServiceBase)serviceBean).setStdinOpen(this.myStdinOpen);
        ((DockerComposeServiceBase)serviceBean).setPorts(this.myPorts);
        ((DockerComposeServiceBase)serviceBean).setVolumes(this.myVolumes);
        R r = this.tuneServiceBean(serviceBean);
        if (r == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(31);
        }
        return r;
    }

    @NotNull
    protected abstract R createServiceBean();

    @NotNull
    protected abstract R tuneServiceBean(@NotNull R var1);

    @NotNull
    protected abstract T getThis();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volume";
                break;
            }
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerPath";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/beans/common/DockerComposeServiceBuilderBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withImage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withLinks";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withDependsOn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkingDir";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withEntrypoint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withEntrypointLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvironment";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withUser";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withRestartPolicy";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withNetworkMode";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withStdinOpen";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "withPorts";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withBindVolumes";
                break;
            }
            case 21: 
            case 23: 
            case 26: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "addVolume";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withImage";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 30: 
            case 31: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withLinks";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addVolume";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

