/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.cli;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerSettings;
import com.intellij.docker.compose.cli.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeDownCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeExecCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeRestartCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeRunCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStartCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStopCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeUpCliBuilder;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.machine.DockerMachineConfigurable;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e\u001a-\u0010\u001b\u001a\u0002H\u001c\"\u000e\b\u0000\u0010\u001c*\b\u0012\u0004\u0012\u0002H\u001c0\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u0002H\u001cH\u0002\u00a2\u0006\u0002\u0010\u001f\u001a\u0018\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%\u001a\f\u0010&\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\u000e\u0010'\u001a\u0004\u0018\u00010#*\u00020#H\u0002\u001a)\u0010(\u001a\u0002H\u001c\"\u000e\b\u0000\u0010\u001c*\b\u0012\u0004\u0012\u0002H\u001c0\u001d*\u0002H\u001c2\u0006\u0010)\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010+\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"DEFAULT_TIMEOUT_SECONDS", "", "EXEC_COMMAND", "", "HTTPS_URL_SCHEMA", "HTTP_URL_SCHEMA", "RUN_COMMAND", "TCP_URL_SCHEMA", "UP_COMMAND", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "buildDownCommand", "Lcom/intellij/docker/compose/cli/DockerComposeDownCliBuilder;", "dockerRuntime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "buildExecCommand", "Lcom/intellij/docker/compose/cli/DockerComposeExecCliBuilder;", "buildRestartCommand", "Lcom/intellij/docker/compose/cli/DockerComposeRestartCliBuilder;", "buildRunCommand", "Lcom/intellij/docker/compose/cli/DockerComposeRunCliBuilder;", "buildStartCommand", "Lcom/intellij/docker/compose/cli/DockerComposeStartCliBuilder;", "buildStopCommand", "Lcom/intellij/docker/compose/cli/DockerComposeStopCliBuilder;", "buildUpCommand", "Lcom/intellij/docker/compose/cli/DockerComposeUpCliBuilder;", "initBuilder", "T", "Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "builder", "(Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;)Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "notifyDockerComposeExecutionFailed", "", "project", "Lcom/intellij/openapi/project/Project;", "e", "Lcom/intellij/execution/process/ProcessNotCreatedException;", "fixApiUrlSchema", "notDisposedOrNull", "setupDockerEngineParameters", "configuration", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;Lcom/intellij/docker/DockerCloudConfiguration;)Lcom/intellij/docker/compose/cli/AbstractDockerComposeCmdCliBuilder;", "intellij.clouds.docker"})
@JvmName(name="DockerComposeCliUtil")
public final class DockerComposeCliUtil {
    @NotNull
    public static final String UP_COMMAND = "up";
    @NotNull
    public static final String RUN_COMMAND = "run";
    @NotNull
    public static final String EXEC_COMMAND = "exec";
    private static final NotificationGroup notificationGroup = new NotificationGroup("Docker Compose", NotificationDisplayType.BALLOON, true, null, null, 24, null);
    public static final int DEFAULT_TIMEOUT_SECONDS = 10;
    private static final String HTTP_URL_SCHEMA = "http://";
    private static final String HTTPS_URL_SCHEMA = "https://";
    private static final String TCP_URL_SCHEMA = "tcp://";

    @NotNull
    public static final DockerComposeRunCliBuilder buildRunCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeRunCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeRunCliBuilder());
    }

    @NotNull
    public static final DockerComposeUpCliBuilder buildUpCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeUpCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeUpCliBuilder());
    }

    @NotNull
    public static final DockerComposeExecCliBuilder buildExecCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeExecCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeExecCliBuilder());
    }

    @NotNull
    public static final DockerComposeDownCliBuilder buildDownCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeDownCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeDownCliBuilder());
    }

    @NotNull
    public static final DockerComposeStartCliBuilder buildStartCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeStartCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeStartCliBuilder());
    }

    @NotNull
    public static final DockerComposeRestartCliBuilder buildRestartCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeRestartCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeRestartCliBuilder());
    }

    @NotNull
    public static final DockerComposeStopCliBuilder buildStopCommand(@NotNull RemoteDockerRuntime dockerRuntime) {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        return (DockerComposeStopCliBuilder)DockerComposeCliUtil.initBuilder(dockerRuntime, (AbstractDockerComposeCmdCliBuilder)new DockerComposeStopCliBuilder());
    }

    private static final <T extends AbstractDockerComposeCmdCliBuilder<T>> T initBuilder(RemoteDockerRuntime dockerRuntime, T builder) {
        DockerSettings dockerSettings = DockerSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dockerSettings, (String)"DockerSettings.getInstance()");
        String string = dockerSettings.getDockerComposePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerSettings.getInstance().dockerComposePath");
        String dockerComposePath = string;
        DockerCloudConfiguration dockerCloudConfiguration = dockerRuntime.getAccount();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerCloudConfiguration), (String)"dockerRuntime.account");
        return DockerComposeCliUtil.setupDockerEngineParameters(builder, dockerCloudConfiguration).withDockerComposeExecutable(dockerComposePath);
    }

    private static final <T extends AbstractDockerComposeCmdCliBuilder<T>> T setupDockerEngineParameters(T $this$setupDockerEngineParameters, DockerCloudConfiguration configuration) {
        boolean bl;
        CharSequence charSequence;
        String string = configuration.getApiUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configuration.apiUrl");
        $this$setupDockerEngineParameters.withDockerHost(DockerComposeCliUtil.fixApiUrlSchema(string));
        String string2 = StringKt.nullize((String)configuration.getCertificatesPath(), (boolean)true);
        if (string2 != null) {
            charSequence = string2;
            bl = false;
            boolean bl2 = false;
            String it = charSequence;
            boolean bl3 = false;
            $this$setupDockerEngineParameters.withDockerCertPath(it);
            $this$setupDockerEngineParameters.withDockerTlsVerify("1");
        }
        if (SystemInfo.isWindows) {
            String string3 = configuration.getMachine();
            if (string3 != null) {
                charSequence = string3;
                bl = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    $this$setupDockerEngineParameters.withComposeConvertWindowsPaths(true);
                }
            }
        }
        return $this$setupDockerEngineParameters;
    }

    @NotNull
    public static final String fixApiUrlSchema(@NotNull String $this$fixApiUrlSchema) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$fixApiUrlSchema, (String)"$this$fixApiUrlSchema");
        if (StringsKt.startsWith$default((String)$this$fixApiUrlSchema, (String)HTTP_URL_SCHEMA, (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append(TCP_URL_SCHEMA);
            String string2 = $this$fixApiUrlSchema;
            int n = HTTP_URL_SCHEMA.length();
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            string = stringBuilder.append(string3).toString();
        } else if (StringsKt.startsWith$default((String)$this$fixApiUrlSchema, (String)HTTPS_URL_SCHEMA, (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append(TCP_URL_SCHEMA);
            String string4 = $this$fixApiUrlSchema;
            int n = HTTPS_URL_SCHEMA.length();
            boolean bl = false;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            string = stringBuilder.append(string5).toString();
        } else {
            string = $this$fixApiUrlSchema;
        }
        return string;
    }

    public static final void notifyDockerComposeExecutionFailed(@Nullable Project project, @NotNull ProcessNotCreatedException e) {
        String content;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = DockerBundle.message("DockerComposeCliUtil.error.compose.execution.failed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DockerBundle.message(\"Do\u2026ompose.execution.failed\")");
        String title = string;
        String string2 = content = e.getLocalizedMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"content");
        notificationGroup.createNotification(title, string2, NotificationType.WARNING, null).addAction((AnAction)new NotificationAction(project, DockerBundle.message("DockerComposeExecutionFailed.notification.action.title", new Object[0])){
            final /* synthetic */ Project $project;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Project project = this.$project;
                ShowSettingsUtil.getInstance().showSettingsDialog((Project)(project != null ? DockerComposeCliUtil.access$notDisposedOrNull(project) : null), DockerMachineConfigurable.class);
            }
            {
                this.$project = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }).notify(project);
    }

    private static final Project notDisposedOrNull(Project $this$notDisposedOrNull) {
        return $this$notDisposedOrNull.isDisposed() ? null : $this$notDisposedOrNull;
    }

    public static final /* synthetic */ Project access$notDisposedOrNull(Project $this$access_u24notDisposedOrNull) {
        return DockerComposeCliUtil.notDisposedOrNull($this$access_u24notDisposedOrNull);
    }
}

