/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.agent.cli.DockerBuildCliParserBase;
import com.intellij.docker.cli.NormalizedCommandLine;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerBuildCliBuilder {
    public static final String CANONICAL_FILE_NAME = "Dockerfile";
    public static final String UNKNOWN_IMAGE_TAG = "<image_tag>";
    private String myDockerFile;
    private final List<String> myImageTags = new ArrayList<String>();
    private NormalizedCommandLine myCustomBuildOptions;
    private final List<String> myBuildArgValues = new LinkedList<String>();
    private boolean myEnableBuildKit = false;
    private boolean myShortenDockerFilePath = true;
    private String myContextDirectory;

    public DockerBuildCliBuilder setDockerFile(@NotNull String path) {
        if (path == null) {
            DockerBuildCliBuilder.$$$reportNull$$$0(0);
        }
        this.myDockerFile = path;
        return this;
    }

    public DockerBuildCliBuilder withShortenDockerFilePath(boolean value) {
        this.myShortenDockerFilePath = value;
        return this;
    }

    public DockerBuildCliBuilder setContextDirectory(String contextDirectory) {
        this.myContextDirectory = contextDirectory;
        return this;
    }

    public void setEnableBuildKit(boolean enableBuildKit) {
        this.myEnableBuildKit = enableBuildKit;
    }

    public void addImageTag(@NotNull String imageTag) {
        if (imageTag == null) {
            DockerBuildCliBuilder.$$$reportNull$$$0(1);
        }
        if (!StringUtil.isEmptyOrSpaces((String)imageTag)) {
            this.myImageTags.add(imageTag);
        }
    }

    public void addBuildArg(@NotNull String name, @Nullable String value) {
        if (name == null) {
            DockerBuildCliBuilder.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        this.myBuildArgValues.add(name + (String)(StringUtil.isEmptyOrSpaces((String)value) ? "" : "=" + value));
    }

    public DockerBuildCliBuilder setCustomBuildOptions(@NotNull NormalizedCommandLine runOptions) {
        if (runOptions == null) {
            DockerBuildCliBuilder.$$$reportNull$$$0(3);
        }
        this.myCustomBuildOptions = runOptions;
        return this;
    }

    public List<String> buildPreviewLines() {
        return this.buildPreviewLines(true);
    }

    public List<String> buildPreviewLines(boolean withPrefix) {
        String START = "docker build";
        LinkedList<String> result = new LinkedList<String>();
        if (this.myEnableBuildKit && withPrefix) {
            result.add("DOCKER_BUILDKIT=1");
        }
        LinkedList<String> lastLine = new LinkedList<String>();
        if (!this.myBuildArgValues.isEmpty()) {
            Option buildArgsOption = DockerBuildCliParserBase.buildArgsOption();
            if (this.myCustomBuildOptions == null) {
                this.myCustomBuildOptions = new NormalizedCommandLine();
            }
            for (String nextValue : this.myBuildArgValues) {
                this.myCustomBuildOptions.registerOneValue(buildArgsOption, nextValue);
            }
        }
        if (this.myCustomBuildOptions != null) {
            if (withPrefix) {
                result.add("docker build");
            }
            result.addAll(this.myCustomBuildOptions.groupByOptions());
        } else if (withPrefix) {
            lastLine.add("docker build");
        }
        if (this.myDockerFile != null && !this.myDockerFile.equals(CANONICAL_FILE_NAME)) {
            lastLine.add("-f");
            lastLine.add(DockerBuildCliBuilder.normalizeDockerFilePath(this.myDockerFile, this.myShortenDockerFilePath));
        }
        for (String tag2 : this.myImageTags) {
            lastLine.add("-t");
            lastLine.add(tag2);
        }
        if (this.myContextDirectory != null) {
            lastLine.add(this.myContextDirectory);
        } else {
            lastLine.add(".");
        }
        result.add(StringUtil.join(lastLine, (String)" "));
        return result;
    }

    private static String normalizeDockerFilePath(@NotNull String path, boolean shortenDockerFilePath) {
        if (path == null) {
            DockerBuildCliBuilder.$$$reportNull$$$0(4);
        }
        if (shortenDockerFilePath) {
            int lastSlash = (path = FileUtil.toSystemIndependentName((String)path)).lastIndexOf("/");
            return lastSlash >= 0 ? path.substring(lastSlash + "/".length()) : path;
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageTag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runOptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/cli/DockerBuildCliBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setDockerFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addImageTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addBuildArg";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setCustomBuildOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "normalizeDockerFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

