/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.before;

import com.intellij.docker.before.DockerBeforeRunKt;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunConfigurationBeforeRunProviderDelegate;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.Key;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/before/DockerBeforeRunEnabler;", "Lcom/intellij/execution/impl/RunConfigurationBeforeRunProviderDelegate;", "()V", "beforeRun", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Companion", "intellij.clouds.docker"})
public final class DockerBeforeRunEnabler
implements RunConfigurationBeforeRunProviderDelegate {
    private static final String PREFIX;
    private static final Key<CompletableFuture<DeploymentRuntime>> KEY_RUNTIME_PROMISE;
    private static final Key<Boolean> KEY_IS_FOR_BEFORE_RUN_MARKER;
    @NotNull
    public static final Companion Companion;

    public void beforeRun(@NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"environment.runProfile");
        if (DockerBeforeRunKt.isDockerRunProfile(runProfile)) {
            Executor executor = environment.getExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"environment.executor");
            if (DockerBeforeRunKt.isDockerCompatible(executor)) {
                environment.putUserData(KEY_IS_FOR_BEFORE_RUN_MARKER, (Object)true);
                environment.putUserData(KEY_RUNTIME_PROMISE, new CompletableFuture());
            }
        }
    }

    static {
        Companion = new Companion(null);
        PREFIX = Reflection.getOrCreateKotlinClass(DockerBeforeRunEnabler.class).getQualifiedName();
        KEY_RUNTIME_PROMISE = new Key(PREFIX + ":promise");
        KEY_IS_FOR_BEFORE_RUN_MARKER = new Key(PREFIX + ":key");
    }

    @JvmStatic
    @JvmName(name="isDockerBeforeRun")
    public static final boolean isDockerBeforeRun(@NotNull ExecutionEnvironment environment) {
        return Companion.isDockerBeforeRun(environment);
    }

    @JvmStatic
    @JvmName(name="getDeploymentPromise")
    @Nullable
    public static final CompletableFuture<DeploymentRuntime> getDeploymentPromise(@NotNull ExecutionEnvironment environment) {
        return Companion.getDeploymentPromise(environment);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0001J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/before/DockerBeforeRunEnabler$Companion;", "", "()V", "KEY_IS_FOR_BEFORE_RUN_MARKER", "Lcom/intellij/openapi/util/Key;", "", "KEY_RUNTIME_PROMISE", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/remoteServer/runtime/deployment/DeploymentRuntime;", "PREFIX", "", "getDeploymentPromise", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "isDockerBeforeRun", "intellij.clouds.docker"})
    public static final class Companion {
        @JvmStatic
        @JvmName(name="isDockerBeforeRun")
        public final boolean isDockerBeforeRun(@NotNull ExecutionEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            return environment.getUserData(KEY_IS_FOR_BEFORE_RUN_MARKER) != null;
        }

        @JvmStatic
        @JvmName(name="getDeploymentPromise")
        @Nullable
        public final CompletableFuture<DeploymentRuntime> getDeploymentPromise(@NotNull ExecutionEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            return (CompletableFuture)environment.getUserData(KEY_RUNTIME_PROMISE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

