/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.ContainerActionBase;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersDeploymentManager;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class SelectContainerImageAction
extends ContainerActionBase {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DeploymentNode node;
        if (e == null) {
            SelectContainerImageAction.$$$reportNull$$$0(0);
        }
        if ((node = ApplicationActionUtils.getDeploymentTarget((AnActionEvent)e)) == null) {
            return;
        }
        RemoteServer server = (RemoteServer)node.getServerNode().getValue();
        ServerConnection connection = ServerConnectionManager.getInstance().getConnection(server);
        if (connection == null) {
            return;
        }
        String imageId = Optional.ofNullable((DockerApplicationRuntime)((Object)ApplicationActionUtils.getApplicationRuntime((AnActionEvent)e, DockerApplicationRuntime.class))).map(DockerApplicationRuntime::getImageId).orElse(null);
        if (imageId == null) {
            return;
        }
        Deployment imageDeployment = SelectContainerImageAction.findImageDeployment(connection, imageId);
        if (imageDeployment == null) {
            return;
        }
        ServersTreeNodeSelector selector = RemoteServersDeploymentManager.getNodeSelector((AnActionEvent)e);
        if (selector == null) {
            return;
        }
        selector.select(connection, imageDeployment.getName());
    }

    private static Deployment findImageDeployment(@NotNull ServerConnection<?> connection, @NotNull String patternImageId) {
        if (connection == null) {
            SelectContainerImageAction.$$$reportNull$$$0(1);
        }
        if (patternImageId == null) {
            SelectContainerImageAction.$$$reportNull$$$0(2);
        }
        boolean patternShortened = !patternImageId.startsWith("sha256:");
        for (Deployment next : connection.getDeployments()) {
            DockerApplicationRuntime nextRuntime;
            if (!(next.getRuntime() instanceof DockerApplicationRuntime) || (nextRuntime = (DockerApplicationRuntime)next.getRuntime()).getContainerId() != null) continue;
            String actualImageId = nextRuntime.getImageId();
            boolean match = patternShortened ? Optional.ofNullable(actualImageId).map(fullId -> StringUtil.substringAfter((String)fullId, (String)"sha256:")).map(id -> id.startsWith(patternImageId)).orElse(false).booleanValue() : patternImageId.equals(actualImageId);
            if (!match) continue;
            return next;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternImageId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/action/SelectContainerImageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findImageDeployment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

