/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.view.DockerServiceViewContributor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersDeploymentManager;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerActionUtils {
    DockerActionUtils() {
    }

    @Contract(value="null -> false")
    public static boolean isFailedContainerDeployment(@Nullable Deployment deployment) {
        return deployment != null && deployment.getRuntime() == null && deployment.getStatus() == DeploymentStatus.NOT_DEPLOYED;
    }

    @Contract(value="null -> false")
    public static boolean isContainerRuntime(@Nullable DockerApplicationRuntime runtime) {
        return runtime != null && runtime.getContainerId() != null;
    }

    @Contract(value="null -> false")
    public static boolean isImageRuntime(@Nullable DockerApplicationRuntime runtime) {
        return runtime != null && runtime.getContainerId() == null && runtime.getImageId() != null;
    }

    static boolean isNotDeployed(DeploymentNode node) {
        Deployment deployment = ApplicationActionUtils.getDeployment((DeploymentNode)node);
        return deployment != null && deployment.getStatus() == DeploymentStatus.NOT_DEPLOYED;
    }

    @Nullable
    static LoggingActionHelper getLoggingActionHelper(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DockerActionUtils.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        ServersTreeNodeSelector selector = RemoteServersDeploymentManager.getNodeSelector((AnActionEvent)e);
        if (selector == null) {
            return null;
        }
        DockerServiceViewContributor.DetailsProvidingNode node = (DockerServiceViewContributor.DetailsProvidingNode)ObjectUtils.tryCast((Object)ApplicationActionUtils.getDeploymentTarget((AnActionEvent)e), DockerServiceViewContributor.DetailsProvidingNode.class);
        if (node == null) {
            return null;
        }
        DockerApplicationRuntime applicationRuntime = (DockerApplicationRuntime)((Object)ApplicationActionUtils.getApplicationRuntime((DeploymentNode)node, DockerApplicationRuntime.class));
        if (applicationRuntime == null) {
            return null;
        }
        return new LoggingActionHelper(project, applicationRuntime, selector, node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/action/DockerActionUtils", "getLoggingActionHelper"));
    }

    static final class LoggingActionHelper {
        final Project project;
        final DockerApplicationRuntime applicationRuntime;
        final DockerServiceViewContributor.DetailsProvidingNode node;
        private final ServersTreeNodeSelector selector;

        private LoggingActionHelper(@NotNull Project project, @NotNull DockerApplicationRuntime applicationRuntime, @NotNull ServersTreeNodeSelector selector, @NotNull DockerServiceViewContributor.DetailsProvidingNode node) {
            if (project == null) {
                LoggingActionHelper.$$$reportNull$$$0(0);
            }
            if (applicationRuntime == null) {
                LoggingActionHelper.$$$reportNull$$$0(1);
            }
            if (selector == null) {
                LoggingActionHelper.$$$reportNull$$$0(2);
            }
            if (node == null) {
                LoggingActionHelper.$$$reportNull$$$0(3);
            }
            this.project = project;
            this.applicationRuntime = applicationRuntime;
            this.selector = selector;
            this.node = node;
        }

        @NotNull
        Runnable createLogSelector(@NotNull String logName) {
            if (logName == null) {
                LoggingActionHelper.$$$reportNull$$$0(4);
            }
            Runnable runnable = ApplicationActionUtils.createLogSelector((Project)this.project, (ServersTreeNodeSelector)this.selector, (DeploymentNode)this.node, (String)logName);
            if (runnable == null) {
                LoggingActionHelper.$$$reportNull$$$0(5);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "applicationRuntime";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/action/DockerActionUtils$LoggingActionHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/action/DockerActionUtils$LoggingActionHelper";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLogSelector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createLogSelector";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

