/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.ContainerActionBase;
import com.intellij.docker.action.DockerActionUtils;
import com.intellij.docker.agent.terminal.pipe.DockerBasePipe;
import com.intellij.docker.view.DockerServiceViewContributor;
import com.intellij.docker.view.details.DockerAttachToContainerTab;
import com.intellij.docker.view.details.DockerBuildLogTab;
import com.intellij.docker.view.details.DockerDetailsTab;
import com.intellij.docker.view.details.ITabManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class AttachToContainerAction
extends ContainerActionBase {
    @Override
    protected boolean isEnabled(DeploymentNode node) {
        Deployment deployment = ApplicationActionUtils.getDeployment((DeploymentNode)node);
        if (deployment == null || deployment.getStatus() != DeploymentStatus.DEPLOYED) {
            return false;
        }
        RemoteServer server = (RemoteServer)node.getServerNode().getValue();
        ServerConnection connection = ServerConnectionManager.getInstance().getConnection(server);
        if (connection == null) {
            return false;
        }
        Project project = node.getServerNode().getProject();
        if (project == null) {
            return false;
        }
        DockerServiceViewContributor.DetailsProvidingNode detailsProvidingNode = (DockerServiceViewContributor.DetailsProvidingNode)ObjectUtils.tryCast((Object)node, DockerServiceViewContributor.DetailsProvidingNode.class);
        if (detailsProvidingNode == null) {
            return false;
        }
        ITabManager tabManager = detailsProvidingNode.getDetailsTabs();
        if (tabManager == null) {
            return false;
        }
        DockerAttachToContainerTab tab = (DockerAttachToContainerTab)tabManager.findTab((Function1<? super DockerDetailsTab, Boolean>)((Function1)e -> e instanceof DockerAttachToContainerTab));
        if (tab == null) {
            return true;
        }
        return tab.isPipeClosed();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DockerActionUtils.LoggingActionHelper helper;
        if (e == null) {
            AttachToContainerAction.$$$reportNull$$$0(0);
        }
        if ((helper = DockerActionUtils.getLoggingActionHelper(e)) == null) {
            return;
        }
        ITabManager tabManager = helper.node.getDetailsTabs();
        if (tabManager == null) {
            return;
        }
        DockerAttachToContainerTab tab = AttachToContainerAction.createOrGetTab(tabManager);
        Content content = tab.getContent() == null ? tab.createContent() : tab.getContent();
        helper.applicationRuntime.attach().thenAccept(p -> {
            tab.attachPipe((DockerBasePipe)p);
            UIUtil.invokeLaterIfNeeded(() -> tabManager.getContentManager().setSelectedContent(content, true));
        });
    }

    private static DockerAttachToContainerTab createOrGetTab(ITabManager manager) {
        DockerAttachToContainerTab tab = (DockerAttachToContainerTab)manager.findTab((Function1<? super DockerDetailsTab, Boolean>)((Function1)e -> e instanceof DockerAttachToContainerTab));
        DockerDetailsTab buildLogTab = manager.findTab((Function1<? super DockerDetailsTab, Boolean>)((Function1)e -> e instanceof DockerBuildLogTab));
        if (tab == null) {
            tab = new DockerAttachToContainerTab(manager, buildLogTab == null ? 1 : 2);
            manager.addTab(tab);
        }
        return tab;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/action/AttachToContainerAction", "actionPerformed"));
    }
}

