/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.cli.communicator.CliCommunicator;
import com.intellij.docker.agent.cli.communicator.DockerCliFacade;
import com.intellij.docker.agent.events.DockerEvent;
import com.intellij.docker.before.DockerBeforeRunEnabler;
import com.intellij.docker.cli.executor.CliExecutor;
import com.intellij.docker.cli.executor.DockerCliExecutor;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.machine.DockerConnectionInfo;
import com.intellij.docker.machine.DockerMachine;
import com.intellij.docker.machine.DockerMachineException;
import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.RegistryAuthCallback;
import com.intellij.docker.runtimes.ComposeDeploymentRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntime;
import com.intellij.docker.runtimes.DockerRuntimesCache;
import com.intellij.docker.runtimes.DockerRuntimesManagerImpl;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerServerRuntimeInstance
extends ServerRuntimeInstance<DockerDeploymentConfiguration> {
    public static final Topic<DockerServerListener> EVENTS_TOPIC = new Topic(DockerServerListener.class);
    private static final Logger LOG = Logger.getInstance(DockerServerRuntimeInstance.class);
    private DockerRuntimesCache myRuntimesCache;
    private final DockerCloudConfiguration myConfiguration;
    private final DockerAgent myDockerAgent;
    private final ServerTaskExecutor myServerTaskExecutor;
    private final AgentTaskExecutor myAgentTaskExecutor;
    private final AtomicInteger myConsecutiveErrorsCount;

    public DockerServerRuntimeInstance(@NotNull DockerCloudConfiguration configuration, @NotNull ServerTaskExecutor serverTaskExecutor) {
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(0);
        }
        if (serverTaskExecutor == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(1);
        }
        this.myConsecutiveErrorsCount = new AtomicInteger();
        this.myConfiguration = configuration;
        this.myDockerAgent = ((DockerAgent.Factory)ServiceManager.getService(DockerAgent.Factory.class)).createAgent();
        this.myServerTaskExecutor = serverTaskExecutor;
        this.myAgentTaskExecutor = new AgentTaskExecutor();
    }

    public DockerCloudConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public AgentTaskExecutor getAgentTaskExecutor() {
        return this.myAgentTaskExecutor;
    }

    public ServerTaskExecutor getTaskExecutor() {
        return this.myServerTaskExecutor;
    }

    public DockerAgent getAgent() {
        return this.myDockerAgent;
    }

    public void computeDeployments(@NotNull ServerRuntimeInstance.ComputeDeploymentsCallback callback) {
        if (callback == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(2);
        }
        this.getTaskExecutor().submit(() -> {
            try {
                for (CloudApplicationRuntime application : this.getApplications()) {
                    Deployment deployment = callback.addDeployment(application.getApplicationName(), (DeploymentRuntime)application, application.getStatus(), application.getStatusText());
                    application.setDeploymentModel(deployment);
                }
                callback.succeeded();
            }
            catch (ServerRuntimeException e) {
                callback.errorOccurred(e.getMessage());
            }
        }, (RemoteOperationCallback)callback);
    }

    public void connect(final ServerConnector.ConnectionCallback<DockerDeploymentConfiguration> callback) {
        try {
            DockerServerRuntimeInstance.cleanupDockerLog();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        try {
            DockerServerRuntimeInstance.updateDockerConnectionParameters(this.getConfiguration());
        }
        catch (DockerMachineException e) {
            callback.errorOccurred(e.getMessage());
        }
        CloudAgentLogger agentLogger = DockerServerRuntimeInstance.createAgentLogger();
        CallbackWrapper<Void> callbackWrapper = new CallbackWrapper<Void>(){

            public void onSuccess(Void result) {
                DockerServerRuntimeInstance.this.getAgent().attachEventListener(x$0 -> DockerServerRuntimeInstance.this.onDockerEvent(x$0));
                callback.connected((ServerRuntimeInstance)DockerServerRuntimeInstance.this);
            }

            public void onError(@Nls String message) {
                callback.errorOccurred(message);
            }
        };
        DockerCliFacade cliFacade = new DockerCliFacade(){

            @NotNull
            public CliCommunicator createDockerCommunicator() {
                return new DockerCliExecutor(DockerServerRuntimeInstance.this.myConfiguration);
            }

            @NotNull
            public CliCommunicator createCommunicator(@NotNull String exePath) {
                if (exePath == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new CliExecutor(exePath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/intellij/docker/DockerServerRuntimeInstance$2", "createCommunicator"));
            }
        };
        this.getAgentTaskExecutor().execute(() -> this.lambda$connect$1(cliFacade, agentLogger), (CallbackWrapper)callbackWrapper);
    }

    private static void updateDockerConnectionParameters(@NotNull DockerCloudConfiguration configuration) {
        String machineName;
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)(machineName = configuration.getMachine()))) {
            DockerConnectionInfo connectionInfo = DockerMachine.currentDockerMachine().getDockerConnectionInfo(machineName);
            configuration.setApiUrl(connectionInfo.getApiUrl());
            configuration.setCertificatesPath(connectionInfo.getCertificatesPath());
        }
    }

    private static void cleanupDockerLog() throws IOException {
        File oldLogFile = Path.of(PathManager.getLogPath(), "docker.log").toFile();
        if (oldLogFile.exists() && oldLogFile.isFile() && !oldLogFile.delete()) {
            LOG.warn("Cannot cleanup old agent log file at " + oldLogFile.getAbsolutePath());
        }
    }

    public void deploy(@NotNull DeploymentTask<DockerDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback _callback) {
        ServerRuntimeInstance.DeploymentOperationCallback chainedCallback;
        ExecutionEnvironment environment;
        if (task == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(4);
        }
        if (logManager == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(5);
        }
        if (_callback == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(6);
        }
        if (DockerBeforeRunEnabler.isDockerBeforeRun(environment = task.getExecutionEnvironment())) {
            CompletableFuture<DeploymentRuntime> runtimePromise = DockerBeforeRunEnabler.getDeploymentPromise(environment);
            chainedCallback = new PromiseResolvingCallback(_callback, runtimePromise);
        } else {
            chainedCallback = _callback;
        }
        this.getTaskExecutor().submit(() -> {
            DockerSingletonDeploymentSourceType sourceType = (DockerSingletonDeploymentSourceType)task.getSource().getType();
            if (sourceType instanceof DockerComposeDeploymentSourceType) {
                ComposeDeploymentRuntime composeDeploymentRuntime = this.myRuntimesCache.createComposeRuntime(task);
                composeDeploymentRuntime.deploy(chainedCallback);
            } else {
                String displayName = sourceType.getPresentableDeploymentName((DockerDeploymentConfiguration)task.getConfiguration(), null);
                DockerDeploymentRuntime deploymentRuntime = this.myRuntimesCache.createDeploymentRuntime(task);
                deploymentRuntime.deploy(chainedCallback, displayName, ((DockerDeploymentConfiguration)task.getConfiguration()).isBuildKitEnabled());
            }
        }, (RemoteOperationCallback)chainedCallback);
    }

    public void disconnect() {
        this.getRuntimesManager().serverDisconnected(this);
        this.myRuntimesCache = null;
        this.getTaskExecutor().submit(() -> this.getAgent().disconnect());
    }

    private boolean isConnected() {
        return this.myRuntimesCache != null;
    }

    private void onDockerEvent(DockerEvent agentEvent) {
        if (this.isConnected()) {
            ((DockerServerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EVENTS_TOPIC)).onDockerEvent(this, agentEvent);
        }
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source, @NotNull DockerDeploymentConfiguration configuration) {
        if (source == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(8);
        }
        String string = DockerServerRuntimeInstance.doGetDeploymentName(null, source, configuration);
        if (string == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getRuntimeDeploymentName(@NotNull DeploymentRuntime deploymentRuntime, @NotNull DeploymentSource source, @NotNull DockerDeploymentConfiguration configuration) {
        if (deploymentRuntime == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(10);
        }
        if (source == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(11);
        }
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(12);
        }
        String string = DockerServerRuntimeInstance.doGetDeploymentName((DockerApplicationRuntime)deploymentRuntime, source, configuration);
        if (string == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nls
    private static String doGetDeploymentName(@Nullable DockerApplicationRuntime applicationRuntime, @NotNull DeploymentSource source, @NotNull DockerDeploymentConfiguration configuration) {
        DeploymentSourceType type2;
        if (source == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(14);
        }
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(15);
        }
        String result = (type2 = source.getType()) instanceof DockerSingletonDeploymentSourceType ? ((DockerSingletonDeploymentSourceType)type2).getPresentableDeploymentName(configuration, applicationRuntime) : DockerSingletonDeploymentSourceType.getPresentableContainerNamePiece(configuration, applicationRuntime);
        return result;
    }

    public void imageRegistryAuth(DockerRegistry registry, RegistryAuthCallback callback) {
        this.getTaskExecutor().submit(() -> {
            try {
                this.getAgentTaskExecutor().execute(() -> {
                    this.getAgent().imageRegistryAuth(registry.getAuthConfig());
                    return null;
                });
                callback.succeeded();
            }
            catch (ServerRuntimeException e) {
                callback.errorOccurred(e.getMessage());
            }
        });
    }

    public List<CloudApplicationRuntime> getApplications() throws ServerRuntimeException {
        int THRESHOLD = 5;
        return (List)this.getAgentTaskExecutor().execute(() -> {
            DockerAgentApplication[] agentApps = this.getAgent().getApplications();
            if (agentApps != null) {
                this.myConsecutiveErrorsCount.set(0);
            } else if (this.myConsecutiveErrorsCount.incrementAndGet() > 5) {
                agentApps = DockerAgentApplication.EMPTY_ARRAY;
                this.requestDisconnectLater();
                this.myConsecutiveErrorsCount.set(0);
            } else {
                agentApps = DockerAgentApplication.EMPTY_ARRAY;
            }
            return this.myRuntimesCache.refreshStructure(agentApps);
        });
    }

    private void requestDisconnectLater() {
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
            ServerConnection connection;
            RemoteServer server = (RemoteServer)ContainerUtil.find((Iterable)RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance()), it -> it.getConfiguration() == this.getConfiguration());
            if (server != null && (connection = ServerConnectionManager.getInstance().getConnection(server)) != null && connection.getStatus() == ConnectionStatus.CONNECTED) {
                connection.disconnect();
            }
        });
    }

    @NotNull
    public CompletableFuture<DockerApplicationRuntime> findRuntimeLater(@NotNull String id, boolean containerNotImage) {
        if (id == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(16);
        }
        CompletableFuture<DockerApplicationRuntime> promise = new CompletableFuture<DockerApplicationRuntime>();
        this.getTaskExecutor().submit(() -> {
            try {
                DockerApplicationRuntime result = (DockerApplicationRuntime)((Object)((Object)this.getAgentTaskExecutor().execute(() -> {
                    DockerAgentApplication app = containerNotImage ? this.getAgent().findContainer(id) : (DockerAgentApplication)Stream.of(this.getAgent().getImages(null)).filter(next -> id.equalsIgnoreCase(next.getImageId())).findFirst().orElse(null);
                    return app == null ? null : this.myRuntimesCache.createRuntimeForExternalUse(app);
                })));
                promise.complete(result);
            }
            catch (ServerRuntimeException e) {
                promise.completeExceptionally(e);
            }
        });
        CompletableFuture<DockerApplicationRuntime> completableFuture = promise;
        if (completableFuture == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(17);
        }
        return completableFuture;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    @NotNull
    private DockerRuntimesManagerImpl getRuntimesManager() {
        DockerRuntimesManagerImpl dockerRuntimesManagerImpl = (DockerRuntimesManagerImpl)DockerRuntimesManagerService.getInstance().findOrCreateManagerFor(this.getConfiguration());
        if (dockerRuntimesManagerImpl == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(18);
        }
        return dockerRuntimesManagerImpl;
    }

    @NotNull
    private static CloudAgentLogger createAgentLogger() {
        return new CloudAgentLogger(){

            public void debugEx(Exception e) {
                LOG.debug((Throwable)e);
            }

            public void debug(String message) {
                LOG.debug(message);
            }
        };
    }

    private /* synthetic */ Void lambda$connect$1(2 cliFacade, CloudAgentLogger agentLogger) {
        this.getAgent().connect((DockerAgentConfig)this.getConfiguration(), (DockerCliFacade)cliFacade, agentLogger, (CloudAgentErrorHandler)this.getAgentTaskExecutor());
        this.myRuntimesCache = this.getRuntimesManager().serverConnected(this);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverTaskExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_callback";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerServerRuntimeInstance";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentRuntime";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerServerRuntimeInstance";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeDeploymentName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findRuntimeLater";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimesManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeDeployments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateDockerConnectionParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deploy";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentName";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeDeploymentName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doGetDeploymentName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findRuntimeLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PromiseResolvingCallback
    implements ServerRuntimeInstance.DeploymentOperationCallback {
        private final ServerRuntimeInstance.DeploymentOperationCallback myRealCallback;
        private final CompletableFuture<DeploymentRuntime> myPromise;

        PromiseResolvingCallback(@NotNull ServerRuntimeInstance.DeploymentOperationCallback callback, @Nullable CompletableFuture<DeploymentRuntime> promise) {
            if (callback == null) {
                PromiseResolvingCallback.$$$reportNull$$$0(0);
            }
            this.myRealCallback = callback;
            this.myPromise = promise != null ? promise : new CompletableFuture();
        }

        public void started(@NotNull DeploymentRuntime deploymentRuntime) {
            if (deploymentRuntime == null) {
                PromiseResolvingCallback.$$$reportNull$$$0(1);
            }
            this.myRealCallback.started(deploymentRuntime);
        }

        public Deployment succeeded(@NotNull DeploymentRuntime deploymentRuntime) {
            if (deploymentRuntime == null) {
                PromiseResolvingCallback.$$$reportNull$$$0(2);
            }
            this.myPromise.complete(deploymentRuntime);
            return this.myRealCallback.succeeded(deploymentRuntime);
        }

        public void errorOccurred(@NotNull @Nls String errorMessage) {
            if (errorMessage == null) {
                PromiseResolvingCallback.$$$reportNull$$$0(3);
            }
            this.myPromise.completeExceptionally((Throwable)new ExecutionException(errorMessage));
            this.myRealCallback.errorOccurred(errorMessage);
        }

        public void errorOccurred(@NotNull @Nls String errorMessage, DeploymentRuntime failedDeployment) {
            if (errorMessage == null) {
                PromiseResolvingCallback.$$$reportNull$$$0(4);
            }
            this.myPromise.completeExceptionally((Throwable)new ExecutionException(errorMessage));
            this.myRealCallback.errorOccurred(errorMessage, failedDeployment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentRuntime";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/DockerServerRuntimeInstance$PromiseResolvingCallback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "started";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "succeeded";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface DockerServerListener {
        public void onDockerEvent(@NotNull DockerServerRuntimeInstance var1, @NotNull DockerEvent var2);
    }
}

