/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerComposeDownOptions;
import com.intellij.docker.DockerComposeRemoveImagesOnDown;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationBase;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerDeploymentConfiguration
extends DeploymentConfigurationBase<DockerDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance(DockerDeploymentConfiguration.class);
    private String mySourceFilePath;
    private String myContextFolderPath;
    private String myEnvFilePath;
    private String myAllImageTagsJoined;
    private String[] myImageTags = ArrayUtil.EMPTY_STRING_ARRAY;
    private String myContainerName;
    private Integer myDebugPort;
    private String myEntrypoint;
    private String myCommand;
    private List<DockerPortBindingImpl> myPortBindings = new ArrayList<DockerPortBindingImpl>();
    private boolean myPublishAllPorts;
    private List<DockerLinkImpl> myLinks = new ArrayList<DockerLinkImpl>();
    private List<DockerVolumeBindingImpl> myVolumeBindings = new ArrayList<DockerVolumeBindingImpl>();
    private List<DockerEnvVarImpl> myEnvVars = new ArrayList<DockerEnvVarImpl>();
    private List<DockerEnvVarImpl> myBuildArgs = new ArrayList<DockerEnvVarImpl>();
    private String myRunCliOptions;
    private String myBuildCliOptions;
    private boolean myLinksExpanded = false;
    private boolean myVolumeBindingsExpanded = false;
    private boolean myEnvVarsExpanded = false;
    private boolean myPortBindingsExpanded = false;
    private boolean myBuildKitEnabled = false;
    private List<String> mySecondarySourceFiles = new ArrayList<String>();
    private List<String> myServices = new ArrayList<String>();
    private List<String> myImagesToPullBeforeRun = new ArrayList<String>();
    private boolean myAttachToContainerNeeded = false;
    private final DockerComposeDownOptions myDownOptions = new DockerComposeDownOptions();
    private boolean myBuildOnly;
    private boolean myUpNoDeps;
    private boolean myUpDetach = true;
    private boolean myUpRemoveOrphans;
    private boolean myUpNoStart;
    private boolean myUpNoBuild;
    private boolean myUpForceRecreate;
    private boolean myUpAttachDependencies;
    private boolean myUpRenewAnonVolumes;
    private boolean myUpAbortOnContainerExit;
    private String myUpExitCodeFromService;
    private boolean myUpNoRecreate;
    private boolean myUpAlwaysRecreate;
    private String myUpTimeout;
    private Map<String, Integer> myUpScaledServices = new HashMap<String, Integer>();

    @OptionTag(value="imageTag")
    public String getAllImageTagsJoined() {
        return this.myAllImageTagsJoined;
    }

    public void setAllImageTagsJoined(String allTagsJoined) {
        this.myAllImageTagsJoined = StringUtil.trim((String)allTagsJoined);
        this.myImageTags = DockerDeploymentConfigurationUtilsKt.splitTags(this.myAllImageTagsJoined);
    }

    @Transient
    public String @NotNull [] getSeparateImageTags() {
        if (this.myImageTags == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(0);
        }
        return this.myImageTags;
    }

    @Transient
    public void setTheOnlyImageTag(@NotNull String imageTag) {
        if (imageTag == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(1);
        }
        this.setAllImageTagsJoined(imageTag);
    }

    public String getContainerName() {
        return this.myContainerName;
    }

    public void setContainerName(String containerName) {
        this.myContainerName = StringUtil.trim((String)containerName);
    }

    @Nullable
    public String getEnvFilePath() {
        return this.myEnvFilePath;
    }

    public DockerDeploymentConfiguration setEnvFilePath(String envFilePath) {
        this.myEnvFilePath = envFilePath;
        return this;
    }

    public String getSourceFilePath() {
        return this.mySourceFilePath;
    }

    public void setSourceFilePath(String path) {
        this.mySourceFilePath = path;
    }

    @OptionTag(value="commandLineOptions")
    public String getRunCliOptions() {
        return this.myRunCliOptions;
    }

    public void setRunCliOptions(String runCliOptions) {
        this.myRunCliOptions = runCliOptions;
    }

    public String getBuildCliOptions() {
        return this.myBuildCliOptions;
    }

    public void setBuildCliOptions(String buildCliOptions) {
        this.myBuildCliOptions = buildCliOptions;
    }

    public Integer getDebugPort() {
        return this.myDebugPort;
    }

    public void setAttachToContainerNeeded(boolean attachToContainerNeeded) {
        this.myAttachToContainerNeeded = attachToContainerNeeded;
    }

    public boolean isAttachToContainerNeeded() {
        return this.myAttachToContainerNeeded;
    }

    public void setDebugPort(Integer debugPort) {
        this.myDebugPort = debugPort;
    }

    public String getContextFolderPath() {
        return this.myContextFolderPath;
    }

    public void setContextFolderPath(String path) {
        this.myContextFolderPath = path;
    }

    public void checkConfiguration(RemoteServer<?> server, DeploymentSource deploymentSource, Project project) throws RuntimeConfigurationException {
        assert (deploymentSource != null);
        assert (project != null);
        if (deploymentSource.getType() instanceof DockerSingletonDeploymentSourceType) {
            DockerSingletonDeploymentSourceType typeImpl = (DockerSingletonDeploymentSourceType)deploymentSource.getType();
            typeImpl.checkDeploymentConfiguration(project, this);
        }
    }

    public String getEntrypoint() {
        return this.myEntrypoint;
    }

    public void setEntrypoint(String entrypoint) {
        this.myEntrypoint = entrypoint;
    }

    public String getCommand() {
        return this.myCommand;
    }

    public void setCommand(String command) {
        this.myCommand = command;
    }

    @AbstractCollection
    public List<DockerPortBindingImpl> getPortBindings() {
        if (this.myPortBindings == null) {
            this.myPortBindings = new ArrayList<DockerPortBindingImpl>();
        }
        return this.myPortBindings;
    }

    public void setPortBindings(List<DockerPortBindingImpl> portBindings) {
        this.myPortBindings = DockerDeploymentConfiguration.defensiveCopy(portBindings);
    }

    public void setPublishAllPorts(boolean publishAllPorts) {
        this.myPublishAllPorts = publishAllPorts;
    }

    public boolean isPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    @AbstractCollection
    public List<DockerLinkImpl> getLinks() {
        if (this.myLinks == null) {
            this.myLinks = new ArrayList<DockerLinkImpl>();
        }
        return this.myLinks;
    }

    public void setLinks(List<DockerLinkImpl> links) {
        this.myLinks = DockerDeploymentConfiguration.defensiveCopy(links);
    }

    @AbstractCollection
    public List<DockerVolumeBindingImpl> getVolumeBindings() {
        if (this.myVolumeBindings == null) {
            this.myVolumeBindings = new ArrayList<DockerVolumeBindingImpl>();
        }
        return this.myVolumeBindings;
    }

    public void setVolumeBindings(List<DockerVolumeBindingImpl> volumeBindings) {
        this.myVolumeBindings = DockerDeploymentConfiguration.defensiveCopy(volumeBindings);
    }

    @AbstractCollection
    public List<DockerEnvVarImpl> getEnvVars() {
        if (this.myEnvVars == null) {
            this.myEnvVars = new ArrayList<DockerEnvVarImpl>();
        }
        return this.myEnvVars;
    }

    public void setEnvVars(List<DockerEnvVarImpl> envVars) {
        this.myEnvVars = DockerDeploymentConfiguration.defensiveCopy(envVars);
    }

    @AbstractCollection
    public List<DockerEnvVarImpl> getBuildArgs() {
        if (this.myBuildArgs == null) {
            this.myBuildArgs = new ArrayList<DockerEnvVarImpl>();
        }
        return this.myBuildArgs;
    }

    public void setBuildArgs(List<DockerEnvVarImpl> buildArgs) {
        this.myBuildArgs = DockerDeploymentConfiguration.defensiveCopy(buildArgs);
    }

    public boolean isLinksExpanded() {
        return this.myLinksExpanded;
    }

    public void setLinksExpanded(boolean linksExpanded) {
        this.myLinksExpanded = linksExpanded;
    }

    public boolean isVolumeBindingsExpanded() {
        return this.myVolumeBindingsExpanded;
    }

    public void setVolumeBindingsExpanded(boolean volumeBindingsExpanded) {
        this.myVolumeBindingsExpanded = volumeBindingsExpanded;
    }

    public boolean isEnvVarsExpanded() {
        return this.myEnvVarsExpanded;
    }

    public void setEnvVarsExpanded(boolean envVarsExpanded) {
        this.myEnvVarsExpanded = envVarsExpanded;
    }

    public boolean isBuildKitEnabled() {
        return this.myBuildKitEnabled;
    }

    public void setBuildKitEnabled(boolean buildKitEnabled) {
        this.myBuildKitEnabled = buildKitEnabled;
    }

    public boolean isPortBindingsExpanded() {
        return this.myPortBindingsExpanded;
    }

    public void setPortBindingsExpanded(boolean portBindingsExpanded) {
        this.myPortBindingsExpanded = portBindingsExpanded;
    }

    @XMap
    public Map<String, Integer> getUpScaledServices() {
        if (this.myUpScaledServices == null) {
            this.myUpScaledServices = new HashMap<String, Integer>();
        }
        return this.myUpScaledServices;
    }

    public void setUpScaledServices(Map<String, Integer> upScaledServices) {
        this.myUpScaledServices = upScaledServices;
    }

    public String getUpExitCodeFromService() {
        return this.myUpExitCodeFromService;
    }

    public void setUpExitCodeFromService(String upExitCodeFromService) {
        this.myUpExitCodeFromService = upExitCodeFromService;
    }

    public String getUpTimeout() {
        return this.myUpTimeout;
    }

    public void setUpTimeout(String upTimeout) {
        this.myUpTimeout = upTimeout;
    }

    public boolean isUpAbortOnContainerExit() {
        return this.myUpAbortOnContainerExit;
    }

    public void setUpAbortOnContainerExit(boolean upAbortOnContainerExit) {
        this.myUpAbortOnContainerExit = upAbortOnContainerExit;
    }

    public boolean isUpNoRecreate() {
        return this.myUpNoRecreate;
    }

    public void setUpNoRecreate(boolean upNoRecreate) {
        this.myUpNoRecreate = upNoRecreate;
    }

    public boolean isUpAlwaysRecreate() {
        return this.myUpAlwaysRecreate;
    }

    public void setUpAlwaysRecreate(boolean upAlwaysRecreate) {
        this.myUpAlwaysRecreate = upAlwaysRecreate;
    }

    public boolean isUpRenewAnonVolumes() {
        return this.myUpRenewAnonVolumes;
    }

    public void setUpRenewAnonVolumes(boolean upRenewAnonVolumes) {
        this.myUpRenewAnonVolumes = upRenewAnonVolumes;
    }

    public boolean isUpRemoveOrphans() {
        return this.myUpRemoveOrphans;
    }

    public void setUpRemoveOrphans(boolean upRemoveOrphans) {
        this.myUpRemoveOrphans = upRemoveOrphans;
    }

    public boolean isUpNoStart() {
        return this.myUpNoStart;
    }

    public void setUpNoStart(boolean upNoStart) {
        this.myUpNoStart = upNoStart;
    }

    public boolean isUpNoBuild() {
        return this.myUpNoBuild;
    }

    public void setUpNoBuild(boolean upNoBuild) {
        this.myUpNoBuild = upNoBuild;
    }

    public boolean isUpForceRecreate() {
        return this.myUpForceRecreate;
    }

    public void setUpForceRecreate(boolean upForceRecreate) {
        this.myUpForceRecreate = upForceRecreate;
    }

    public boolean isUpAttachDependencies() {
        return this.myUpAttachDependencies;
    }

    public void setUpAttachDependencies(boolean upAttachDependencies) {
        this.myUpAttachDependencies = upAttachDependencies;
    }

    public boolean isUpDetach() {
        return this.myUpDetach;
    }

    public void setUpDetach(boolean upDetach) {
        this.myUpDetach = upDetach;
    }

    public boolean isUpNoDeps() {
        return this.myUpNoDeps;
    }

    public void setUpNoDeps(boolean upNoDeps) {
        this.myUpNoDeps = upNoDeps;
    }

    public boolean isBuildOnly() {
        return this.myBuildOnly;
    }

    public void setBuildOnly(boolean buildOnly) {
        this.myBuildOnly = buildOnly;
    }

    public DockerComposeDownOptions copyComposeDownOptions() {
        return this.myDownOptions.makeCopy();
    }

    public void setRemoveImagesOnComposeDown(@NotNull DockerComposeRemoveImagesOnDown kind) {
        if (kind == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(2);
        }
        this.myDownOptions.setRemoveImages(kind);
    }

    public DockerComposeRemoveImagesOnDown getRemoveImagesOnComposeDown() {
        return this.myDownOptions.getRemoveImages();
    }

    public void setRemoveOrphansOnComposeDown(boolean remove) {
        this.myDownOptions.setRemoveOrphans(remove);
    }

    public boolean isRemoveOrphansOnComposeDown() {
        return this.myDownOptions.getRemoveOrphans();
    }

    public void setRemoveVolumesOnComposeDown(boolean remove) {
        this.myDownOptions.setRemoveVolumes(remove);
    }

    public boolean isRemoveVolumesOnComposeDown() {
        return this.myDownOptions.getRemoveVolumes();
    }

    @AbstractCollection
    public List<String> getSecondarySourceFiles() {
        if (this.mySecondarySourceFiles == null) {
            this.mySecondarySourceFiles = new ArrayList<String>();
        }
        return this.mySecondarySourceFiles;
    }

    public void setSecondarySourceFiles(List<String> files) {
        this.mySecondarySourceFiles = DockerDeploymentConfiguration.defensiveCopy(files);
    }

    @AbstractCollection
    @NotNull
    public List<String> getServices() {
        if (this.myServices == null) {
            this.myServices = new ArrayList<String>();
        }
        List<String> list = this.myServices;
        if (list == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setServices(List<String> services) {
        this.myServices = DockerDeploymentConfiguration.defensiveCopy(services);
    }

    @XCollection
    @NotNull
    public List<String> getImagesToPullBeforeRun() {
        List<String> list = this.myImagesToPullBeforeRun;
        if (list == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setImagesToPullBeforeRun(@NotNull List<String> imagesToPull) {
        if (imagesToPull == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(5);
        }
        this.myImagesToPullBeforeRun = DockerDeploymentConfiguration.defensiveCopy(imagesToPull);
    }

    public void loadState(@NotNull DockerDeploymentConfiguration state) {
        if (state == null) {
            DockerDeploymentConfiguration.$$$reportNull$$$0(6);
        }
        String mayBePresetPath = this.getSourceFilePath();
        super.loadState((DeploymentConfigurationBase)state);
        if (mayBePresetPath != null && this.getSourceFilePath() == null) {
            this.setSourceFilePath(mayBePresetPath);
        }
    }

    @NotNull
    private static <T> List<T> defensiveCopy(@Nullable List<T> list) {
        return list == null ? new ArrayList() : new ArrayList<T>(list);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerDeploymentConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageTag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imagesToPull";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparateImageTags";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerDeploymentConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImagesToPullBeforeRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTheOnlyImageTag";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRemoveImagesOnComposeDown";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setImagesToPullBeforeRun";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

