/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.util.encoders.Hex;

public class PuTTYKeyFile
extends BaseFileKeyProvider {
    private byte[] privateKey;
    private byte[] publicKey;
    private Map<String, String> payload = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();

    @Override
    public KeyType getType() throws IOException {
        return KeyType.fromString(this.headers.get("PuTTY-User-Key-File-2"));
    }

    public boolean isEncrypted() {
        return "aes256-cbc".equals(this.headers.get("Encryption"));
    }

    @Override
    protected KeyPair readKeyPair() throws IOException {
        String ecdsaCurve;
        this.parseKeyPair();
        Buffer.PlainBuffer publicKeyReader = new Buffer.PlainBuffer(this.publicKey);
        Buffer.PlainBuffer privateKeyReader = new Buffer.PlainBuffer(this.privateKey);
        publicKeyReader.readBytes();
        if (KeyType.RSA.equals((Object)this.getType())) {
            KeyFactory factory;
            BigInteger e = publicKeyReader.readMPInt();
            BigInteger n = publicKeyReader.readMPInt();
            BigInteger d = privateKeyReader.readMPInt();
            try {
                factory = KeyFactory.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException s) {
                throw new IOException(s.getMessage(), s);
            }
            try {
                return new KeyPair(factory.generatePublic(new RSAPublicKeySpec(n, e)), factory.generatePrivate(new RSAPrivateKeySpec(n, d)));
            }
            catch (InvalidKeySpecException i) {
                throw new IOException(i.getMessage(), i);
            }
        }
        if (KeyType.DSA.equals((Object)this.getType())) {
            KeyFactory factory;
            BigInteger p = publicKeyReader.readMPInt();
            BigInteger q = publicKeyReader.readMPInt();
            BigInteger g = publicKeyReader.readMPInt();
            BigInteger y = publicKeyReader.readMPInt();
            BigInteger x = privateKeyReader.readMPInt();
            try {
                factory = KeyFactory.getInstance("DSA");
            }
            catch (NoSuchAlgorithmException s) {
                throw new IOException(s.getMessage(), s);
            }
            try {
                return new KeyPair(factory.generatePublic(new DSAPublicKeySpec(y, p, q, g)), factory.generatePrivate(new DSAPrivateKeySpec(x, p, q, g)));
            }
            catch (InvalidKeySpecException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        if (KeyType.ED25519.equals((Object)this.getType())) {
            EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.getByName("Ed25519");
            EdDSAPublicKeySpec publicSpec = new EdDSAPublicKeySpec(publicKeyReader.readBytes(), (EdDSAParameterSpec)ed25519);
            EdDSAPrivateKeySpec privateSpec = new EdDSAPrivateKeySpec(privateKeyReader.readBytes(), ed25519);
            return new KeyPair(new EdDSAPublicKey(publicSpec), new EdDSAPrivateKey(privateSpec));
        }
        switch (this.getType()) {
            case ECDSA256: {
                ecdsaCurve = "P-256";
                break;
            }
            case ECDSA384: {
                ecdsaCurve = "P-384";
                break;
            }
            case ECDSA521: {
                ecdsaCurve = "P-521";
                break;
            }
            default: {
                ecdsaCurve = null;
            }
        }
        if (ecdsaCurve != null) {
            BigInteger s = new BigInteger(1, privateKeyReader.readBytes());
            X9ECParameters ecParams = NISTNamedCurves.getByName((String)ecdsaCurve);
            ECNamedCurveSpec ecCurveSpec = new ECNamedCurveSpec(ecdsaCurve, ecParams.getCurve(), ecParams.getG(), ecParams.getN());
            ECPrivateKeySpec pks = new ECPrivateKeySpec(s, (ECParameterSpec)ecCurveSpec);
            try {
                PrivateKey privateKey = SecurityUtils.getKeyFactory("ECDSA").generatePrivate(pks);
                return new KeyPair(this.getType().readPubKeyFromBuffer(publicKeyReader), privateKey);
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        throw new IOException(String.format("Unknown key type %s", new Object[]{this.getType()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseKeyPair() throws IOException {
        try (BufferedReader r = new BufferedReader(this.resource.getReader());){
            String line;
            String headerName = null;
            while ((line = r.readLine()) != null) {
                int idx = line.indexOf(": ");
                if (idx > 0) {
                    headerName = line.substring(0, idx);
                    this.headers.put(headerName, line.substring(idx + 2));
                    continue;
                }
                String s = this.payload.get(headerName);
                s = s == null ? line : s + line;
                this.payload.put(headerName, s);
            }
        }
        this.publicKey = Base64.decode(this.payload.get("Public-Lines"));
        if (this.isEncrypted()) {
            char[] passphrase = this.pwdf != null ? this.pwdf.reqPassword(this.resource) : "".toCharArray();
            try {
                this.privateKey = this.decrypt(Base64.decode(this.payload.get("Private-Lines")), new String(passphrase));
                this.verify(new String(passphrase));
            }
            finally {
                PasswordUtils.blankOut(passphrase);
            }
        } else {
            this.privateKey = Base64.decode(this.payload.get("Private-Lines"));
        }
    }

    private byte[] toKey(String passphrase) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(new byte[]{0, 0, 0, 0});
            digest.update(passphrase.getBytes());
            byte[] key1 = digest.digest();
            digest.update(new byte[]{0, 0, 0, 1});
            digest.update(passphrase.getBytes());
            byte[] key2 = digest.digest();
            byte[] r = new byte[32];
            System.arraycopy(key1, 0, r, 0, 20);
            System.arraycopy(key2, 0, r, 20, 12);
            return r;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void verify(String passphrase) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update("putty-private-key-file-mac-key".getBytes());
            if (passphrase != null) {
                digest.update(passphrase.getBytes());
            }
            byte[] key = digest.digest();
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key, 0, 20, mac.getAlgorithm()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(out);
            data.writeInt(this.getType().toString().length());
            data.writeBytes(this.getType().toString());
            data.writeInt(this.headers.get("Encryption").length());
            data.writeBytes(this.headers.get("Encryption"));
            data.writeInt(this.headers.get("Comment").length());
            data.writeBytes(this.headers.get("Comment"));
            data.writeInt(this.publicKey.length);
            data.write(this.publicKey);
            data.writeInt(this.privateKey.length);
            data.write(this.privateKey);
            String encoded = Hex.toHexString((byte[])mac.doFinal(out.toByteArray()));
            String reference = this.headers.get("Private-MAC");
            if (!encoded.equals(reference)) {
                throw new IOException("Invalid passphrase");
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private byte[] decrypt(byte[] key, String passphrase) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            byte[] expanded = this.toKey(passphrase);
            cipher.init(2, (Key)new SecretKeySpec(expanded, 0, 32, "AES"), new IvParameterSpec(new byte[16]));
            return cipher.doFinal(key);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new PuTTYKeyFile();
        }

        @Override
        public String getName() {
            return "PuTTY";
        }
    }
}

