/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.verifier;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.security.DigestException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.ByteBufferDataSource;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.datasource.FileChannelDataSource;
import org.jetbrains.zip.signer.digest.DigestUtils;
import org.jetbrains.zip.signer.exceptions.ZipVerificationException;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.metadata.SignatureData;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.metadata.ZipMetadata;
import org.jetbrains.zip.signer.signer.CertificateUtils;
import org.jetbrains.zip.signer.verifier.DefaultSignatureVerifier;
import org.jetbrains.zip.signer.verifier.InvalidSignatureResult;
import org.jetbrains.zip.signer.verifier.MissingSignatureResult;
import org.jetbrains.zip.signer.verifier.SuccessfulVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerificationResult;
import org.jetbrains.zip.signer.zip.ZipSections;
import org.jetbrains.zip.signer.zip.ZipSectionsInformation;
import org.jetbrains.zip.signer.zip.ZipUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0012H\u0002J2\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/zip/signer/verifier/ZipVerifier;", "", "()V", "checkDigests", "", "zipSections", "Lorg/jetbrains/zip/signer/zip/ZipSections;", "zipMetadata", "Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "checkDigests$lib", "verify", "Lorg/jetbrains/zip/signer/verifier/ZipVerificationResult;", "file", "Ljava/io/File;", "dataSource", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "verifyCertificateChains", "certificateChains", "", "Ljava/security/cert/Certificate;", "verifySignatures", "digests", "", "Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "Lorg/jetbrains/zip/signer/metadata/Digest;", "signer", "Lorg/jetbrains/zip/signer/metadata/SignerBlock;", "certFactory", "Ljava/security/cert/CertificateFactory;", "lib"})
@ExperimentalUnsignedTypes
public final class ZipVerifier {
    @NotNull
    public static final ZipVerifier INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ZipVerificationResult verify(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new RandomAccessFile(file, "r");
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            RandomAccessFile it = (RandomAccessFile)closeable;
            boolean bl3 = false;
            FileChannel fileChannel = it.getChannel();
            Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"it.channel");
            ZipVerificationResult zipVerificationResult = INSTANCE.verify(new FileChannelDataSource(fileChannel, 0L, null, 6, null));
            return zipVerificationResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final ZipVerificationResult verify(DataSource dataSource) {
        ZipSectionsInformation zipSectionsInformation = ZipUtils.INSTANCE.findZipSectionsInformation(dataSource);
        ZipMetadata zipMetadata = ZipMetadata.Companion.findInZip(dataSource, zipSectionsInformation);
        if (zipMetadata == null) {
            return new MissingSignatureResult();
        }
        ZipMetadata zipMetadata2 = zipMetadata;
        ZipSections zipSections = ZipUtils.INSTANCE.findZipSections$lib(dataSource, zipSectionsInformation, zipMetadata2);
        return this.verify(zipSections, zipMetadata2);
    }

    private final ZipVerificationResult verify(ZipSections zipSections, ZipMetadata zipMetadata) {
        ZipVerificationResult zipVerificationResult;
        try {
            this.checkDigests$lib(zipSections, zipMetadata);
            List<List<Certificate>> certificateChains = this.verifySignatures(zipMetadata);
            this.verifyCertificateChains(certificateChains);
            zipVerificationResult = new SuccessfulVerificationResult(certificateChains);
        }
        catch (ZipVerificationException e) {
            zipVerificationResult = new InvalidSignatureResult(e.getMessage());
        }
        return zipVerificationResult;
    }

    private final void verifyCertificateChains(List<? extends List<? extends Certificate>> certificateChains) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = certificateChains;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List it = (List)element$iv;
                    boolean bl2 = false;
                    if (!(!CertificateUtils.INSTANCE.isValidCertificateChain(it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new ZipVerificationException("One of signature blocks contains invalid certificate chain");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Certificate>> verifySignatures(ZipMetadata zipMetadata) {
        void $this$mapTo$iv$iv;
        Object object;
        Object object2;
        void $this$associateByTo$iv$iv;
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        Iterable $this$associateBy$iv = zipMetadata.getDigests();
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Digest digest = (Digest)element$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = it.getAlgorithm();
            object2.put(object, element$iv$iv);
        }
        Map digests = destination$iv$iv;
        Iterable $this$map$iv = zipMetadata.getSigners();
        boolean $i$f$map = false;
        Iterable capacity$iv22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (SignerBlock)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            CertificateFactory certificateFactory = certFactory;
            Intrinsics.checkNotNullExpressionValue((Object)certificateFactory, (String)"certFactory");
            object = INSTANCE.verifySignatures(digests, (SignerBlock)it, certificateFactory);
            object2.add(object);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Certificate> verifySignatures(Map<ContentDigestAlgorithm, Digest> digests, SignerBlock signer, CertificateFactory certFactory) {
        void $this$mapTo$iv$iv;
        if (signer.getSignatures().isEmpty()) {
            throw (Throwable)new ZipVerificationException("Signer block contains no signatures");
        }
        Iterable $this$map$iv = signer.getEncodedCertificates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var14_15 = it;
            boolean bl2 = false;
            Certificate certificate = certFactory.generateCertificate(new ByteArrayInputStream((byte[])var14_15));
            if (certificate == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            X509Certificate x509Certificate = (X509Certificate)certificate;
            collection.add(x509Certificate);
        }
        List certificates = (List)destination$iv$iv;
        if (certificates.isEmpty()) {
            throw (Throwable)new ZipVerificationException("Signer has no certificates");
        }
        Iterable $this$forEach$iv = signer.getSignatures();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Digest digest;
            SignatureData signature = (SignatureData)element$iv;
            boolean bl = false;
            SignatureAlgorithm signatureAlgorithm = signature.getAlgorithm();
            if (digests.get((Object)signature.getAlgorithm().getContentDigestAlgorithm()) == null) {
                throw (Throwable)new ZipVerificationException("Missing digest " + (Object)((Object)signature.getAlgorithm().getContentDigestAlgorithm()));
            }
            new DefaultSignatureVerifier(certificates, signatureAlgorithm).verify(digest.getDigestBytes(), signature.getSignatureBytes());
        }
        return certificates;
    }

    /*
     * WARNING - void declaration
     */
    public final void checkDigests$lib(@NotNull ZipSections zipSections, @NotNull ZipMetadata zipMetadata) {
        Object object;
        List $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)zipSections, (String)"zipSections");
        Intrinsics.checkNotNullParameter((Object)zipMetadata, (String)"zipMetadata");
        ByteBuffer byteBuffer = zipSections.getEndOfCentralDirectorySection().getByteBuffer(0L, (int)zipSections.getEndOfCentralDirectorySection().size());
        boolean bl = false;
        boolean bl2 = false;
        ByteBuffer $this$apply = byteBuffer;
        boolean bl3 = false;
        $this$apply.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer modifiedEocd = byteBuffer;
        long l = zipSections.getBeforeSigningBlockSection().size();
        bl2 = false;
        ZipUtils.INSTANCE.setZipEocdCentralDirectoryOffset-7pO5UbU$lib(modifiedEocd, UInt.constructor-impl((int)((int)l)));
        try {
            Collection<ContentDigestAlgorithm> collection;
            void $this$mapTo$iv$iv;
            Iterable iterable = zipMetadata.getDigests();
            DigestUtils digestUtils = DigestUtils.INSTANCE;
            boolean $i$f$map = false;
            $this$apply = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (Digest)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                ContentDigestAlgorithm contentDigestAlgorithm = it.getAlgorithm();
                collection.add(contentDigestAlgorithm);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = DigestUtils.computeDigest$default(digestUtils, (List)collection, CollectionsKt.listOf((Object[])new DataSource[]{zipSections.getBeforeSigningBlockSection(), zipSections.getCentralDirectorySection(), new ByteBufferDataSource(modifiedEocd)}), 0, 4, null);
        }
        catch (DigestException e) {
            throw (Throwable)new ZipVerificationException("Failed to compute content digests");
        }
        List actualContentDigests = $this$map$iv;
        Iterable $this$forEach$iv = actualContentDigests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Digest expectedDigest;
            Object v0;
            Object object2;
            Digest digest;
            block6: {
                digest = (Digest)element$iv;
                boolean bl5 = false;
                object2 = zipMetadata.getDigests();
                boolean bl6 = false;
                Iterable iterable = object2;
                boolean bl7 = false;
                for (Object t : iterable) {
                    Digest it = (Digest)t;
                    boolean bl8 = false;
                    if (!(it.getAlgorithm() == digest.getAlgorithm())) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            if ((Digest)v0 == null) {
                throw (Throwable)new RuntimeException("Missing " + (Object)((Object)digest.getAlgorithm()) + " digest in metadata");
            }
            object2 = expectedDigest.getDigestBytes();
            object = digest.getDigestBytes();
            boolean bl9 = false;
            if (Arrays.equals((byte[])object2, (byte[])object)) continue;
            throw (Throwable)new ZipVerificationException("ZIP integrity check failed. " + (Object)((Object)digest.getAlgorithm()) + "s digest mismatch.");
        }
    }

    private ZipVerifier() {
    }

    static {
        ZipVerifier zipVerifier;
        INSTANCE = zipVerifier = new ZipVerifier();
    }
}

