/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.verifier;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.verifier.SignatureVerifier;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/zip/signer/verifier/DefaultSignatureVerifier;", "Lorg/jetbrains/zip/signer/verifier/SignatureVerifier;", "certificateChain", "", "Ljava/security/cert/X509Certificate;", "signatureAlgorithm", "Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "(Ljava/util/List;Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;)V", "jcaSignatureAlgorithm", "", "publicKey", "Ljava/security/PublicKey;", "kotlin.jvm.PlatformType", "verify", "", "dataToVerify", "", "signature", "lib"})
public final class DefaultSignatureVerifier
implements SignatureVerifier {
    private final PublicKey publicKey;
    private final String jcaSignatureAlgorithm;

    @Override
    public void verify(@NotNull byte[] dataToVerify, @NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)dataToVerify, (String)"dataToVerify");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        try {
            Signature signature2 = Signature.getInstance(this.jcaSignatureAlgorithm);
            boolean bl = false;
            boolean bl2 = false;
            Signature $this$with = signature2;
            boolean bl3 = false;
            $this$with.initVerify(this.publicKey);
            $this$with.update(dataToVerify);
            if (!$this$with.verify(signature)) {
                throw (Throwable)new SignatureException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate");
            }
        }
        catch (InvalidKeyException e) {
            throw (Throwable)new InvalidKeyException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw (Throwable)new SignatureException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate", e);
        }
        catch (SignatureException e) {
            throw (Throwable)new SignatureException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate", e);
        }
    }

    public DefaultSignatureVerifier(@NotNull List<? extends X509Certificate> certificateChain, @NotNull SignatureAlgorithm signatureAlgorithm) {
        Intrinsics.checkNotNullParameter(certificateChain, (String)"certificateChain");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureAlgorithm), (String)"signatureAlgorithm");
        this.publicKey = certificateChain.get(0).getPublicKey();
        this.jcaSignatureAlgorithm = signatureAlgorithm.getJcaSignatureAlgorithm();
    }
}

