/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.signer.CertificateUtils;
import org.jetbrains.zip.signer.signer.KeystoreUtils;
import org.jetbrains.zip.signer.signer.KeystoreUtilsKt;
import org.jetbrains.zip.signer.signer.PrivateKeyUtils;
import org.jetbrains.zip.signer.signer.SignerInfo;
import org.jetbrains.zip.signer.utils.SecurityUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007JH\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/zip/signer/signer/SignerInfoLoader;", "", "()V", "loadSignerInfoFromFiles", "Lorg/jetbrains/zip/signer/signer/SignerInfo;", "privateKeyFile", "Ljava/io/File;", "certificateFile", "privateKeyPassword", "", "loadSignerInfoFromKeystore", "file", "password", "keyPassword", "keystoreKeyAlias", "", "keystoreType", "keystoreProviderName", "lib"})
public final class SignerInfoLoader {
    @NotNull
    public static final SignerInfoLoader INSTANCE;

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromKeystore(@NotNull File file, @NotNull char[] password, @Nullable char[] keyPassword, @Nullable String keystoreKeyAlias, @Nullable String keystoreType, @Nullable String keystoreProviderName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        KeyStore keyStore = KeystoreUtils.INSTANCE.getKeyStore(keystoreType, keystoreProviderName);
        Object object = file;
        int n = 0;
        object = new FileInputStream((File)object);
        n = 8192;
        boolean bl = false;
        keyStore.load(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n), password);
        char[] cArray = keyPassword;
        if (keyPassword == null) {
            cArray = password;
        }
        return KeystoreUtilsKt.getSignerInfo(keyStore, cArray, keystoreKeyAlias);
    }

    public static /* synthetic */ SignerInfo loadSignerInfoFromKeystore$default(SignerInfoLoader signerInfoLoader, File file, char[] cArray, char[] cArray2, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            cArray2 = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        return signerInfoLoader.loadSignerInfoFromKeystore(file, cArray, cArray2, string, string2, string3);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromKeystore(@NotNull File file, @NotNull char[] password, @Nullable char[] keyPassword, @Nullable String keystoreKeyAlias, @Nullable String keystoreType) {
        return SignerInfoLoader.loadSignerInfoFromKeystore$default(this, file, password, keyPassword, keystoreKeyAlias, keystoreType, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromKeystore(@NotNull File file, @NotNull char[] password, @Nullable char[] keyPassword, @Nullable String keystoreKeyAlias) {
        return SignerInfoLoader.loadSignerInfoFromKeystore$default(this, file, password, keyPassword, keystoreKeyAlias, null, null, 48, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromKeystore(@NotNull File file, @NotNull char[] password, @Nullable char[] keyPassword) {
        return SignerInfoLoader.loadSignerInfoFromKeystore$default(this, file, password, keyPassword, null, null, null, 56, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromKeystore(@NotNull File file, @NotNull char[] password) {
        return SignerInfoLoader.loadSignerInfoFromKeystore$default(this, file, password, null, null, null, null, 60, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromFiles(@NotNull File privateKeyFile, @Nullable File certificateFile, @Nullable char[] privateKeyPassword) {
        Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
        SecurityUtils.INSTANCE.addBouncyCastleProviderIfMissing();
        PEMKeyPair keyPair = PrivateKeyUtils.INSTANCE.loadKeyPair(privateKeyFile, privateKeyPassword);
        List certificates = certificateFile != null ? CertificateUtils.INSTANCE.loadCertificatesFromFile(certificateFile) : CollectionsKt.listOf((Object)CertificateUtils.INSTANCE.generateDummyCertificate(keyPair));
        PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey(keyPair.getPrivateKeyInfo());
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"JcaPEMKeyConverter().get\u2026y(keyPair.privateKeyInfo)");
        return new SignerInfo(certificates, privateKey);
    }

    public static /* synthetic */ SignerInfo loadSignerInfoFromFiles$default(SignerInfoLoader signerInfoLoader, File file, File file2, char[] cArray, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            cArray = null;
        }
        return signerInfoLoader.loadSignerInfoFromFiles(file, file2, cArray);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromFiles(@NotNull File privateKeyFile, @Nullable File certificateFile) {
        return SignerInfoLoader.loadSignerInfoFromFiles$default(this, privateKeyFile, certificateFile, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final SignerInfo loadSignerInfoFromFiles(@NotNull File privateKeyFile) {
        return SignerInfoLoader.loadSignerInfoFromFiles$default(this, privateKeyFile, null, null, 6, null);
    }

    private SignerInfoLoader() {
    }

    static {
        SignerInfoLoader signerInfoLoader;
        INSTANCE = signerInfoLoader = new SignerInfoLoader();
    }
}

