/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordException;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/zip/signer/signer/PrivateKeyUtils;", "", "()V", "loadKeyPair", "Lorg/bouncycastle/openssl/PEMKeyPair;", "file", "Ljava/io/File;", "password", "", "lib"})
public final class PrivateKeyUtils {
    @NotNull
    public static final PrivateKeyUtils INSTANCE;

    @NotNull
    public final PEMKeyPair loadKeyPair(@NotNull File file, @Nullable char[] password) {
        PEMKeyPair pEMKeyPair;
        PEMDecryptorProvider decryptorProvider;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = file;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileInputStream((File)object3);
        bl3 = false;
        object2 = new InputStreamReader((InputStream)object3, charset);
        bl2 = false;
        object = new PEMParser((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n))).readObject();
        boolean bl4 = false;
        n = 0;
        Object pemObject = object;
        boolean bl5 = false;
        Object object4 = pemObject;
        if (object4 instanceof PEMEncryptedKeyPair) {
            if (password == null) {
                throw (Throwable)new PasswordException("Can't read private key. Password is missing");
            }
            decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password);
            pEMKeyPair = ((PEMEncryptedKeyPair)pemObject).decryptKeyPair(decryptorProvider);
        } else if (object4 instanceof PEMKeyPair) {
            pEMKeyPair = (PEMKeyPair)pemObject;
        } else if (object4 instanceof PKCS8EncryptedPrivateKeyInfo) {
            if (password == null) {
                throw (Throwable)new PasswordException("Can't read private key. Password is missing");
            }
            decryptorProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password);
            PrivateKeyInfo privateKey = ((PKCS8EncryptedPrivateKeyInfo)pemObject).decryptPrivateKeyInfo((InputDecryptorProvider)decryptorProvider);
            pEMKeyPair = new PEMKeyPair(null, privateKey);
        } else if (object4 instanceof PrivateKeyInfo) {
            pEMKeyPair = new PEMKeyPair(null, (PrivateKeyInfo)pemObject);
        } else {
            throw (Throwable)new IllegalArgumentException("Failed to parse private key from " + file);
        }
        Intrinsics.checkNotNullExpressionValue((Object)pEMKeyPair, (String)"PEMParser(file.bufferedR\u2026)\n            }\n        }");
        return pEMKeyPair;
    }

    private PrivateKeyUtils() {
    }

    static {
        PrivateKeyUtils privateKeyUtils;
        INSTANCE = privateKeyUtils = new PrivateKeyUtils();
    }
}

