/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.bc.BcDSAContentSignerBuilder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rJ\u0014\u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\u00020\n*\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/zip/signer/signer/CertificateUtils;", "", "()V", "farAwayDate", "Ljava/util/Date;", "generateDummyCertificate", "Ljava/security/cert/X509Certificate;", "keyPair", "Lorg/bouncycastle/openssl/PEMKeyPair;", "isCertificateChainTrusted", "", "certs", "", "Ljava/security/cert/Certificate;", "certificateAuthority", "isValidCertificateChain", "loadCertificatesFromFile", "file", "Ljava/io/File;", "isSignedBy", "other", "lib"})
public final class CertificateUtils {
    private static final Date farAwayDate;
    @NotNull
    public static final CertificateUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<X509Certificate> loadCertificatesFromFile(@NotNull File file) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        Object object = file;
        int n = 0;
        object = new FileInputStream((File)object);
        n = 8192;
        boolean bl = false;
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
        Intrinsics.checkNotNullExpressionValue(collection, (String)"certificateFactory.gener\u2026inputStream().buffered())");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Certificate certificate = (Certificate)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            void v1 = it;
            if (v1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            X509Certificate x509Certificate = (X509Certificate)v1;
            collection2.add(x509Certificate);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final X509Certificate generateDummyCertificate(@NotNull PEMKeyPair keyPair) {
        ContentSigner contentSigner;
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        X500Name dummyName = new X500Name("CN=Dummy Certificate");
        Date yesterday = Date.from(Instant.now().minus(Duration.ofDays(1L)));
        AsymmetricKeyParameter privateKey = PrivateKeyFactory.createKey((PrivateKeyInfo)keyPair.getPrivateKeyInfo());
        if (privateKey instanceof RSAPrivateCrtKeyParameters) {
            contentSigner = new BcRSAContentSignerBuilder(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption), new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)).build(privateKey);
        } else if (privateKey instanceof DSAPrivateKeyParameters) {
            contentSigner = new BcDSAContentSignerBuilder(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa), new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)).build(privateKey);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported key type: " + privateKey.getClass().getSimpleName());
        }
        ContentSigner contentSigner2 = contentSigner;
        X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(new X509v3CertificateBuilder(dummyName, BigInteger.valueOf(System.currentTimeMillis()), yesterday, farAwayDate, dummyName, keyPair.getPublicKeyInfo()).build(contentSigner2));
        Intrinsics.checkNotNullExpressionValue((Object)x509Certificate, (String)"JcaX509CertificateConver\u2026tentSigner)\n            )");
        return x509Certificate;
    }

    public final boolean isValidCertificateChain(@NotNull List<? extends Certificate> certs) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(certs, (String)"certs");
            Iterable $this$all$iv = CollectionsKt.zipWithNext((Iterable)certs);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (INSTANCE.isSignedBy((Certificate)it.getFirst(), (Certificate)it.getSecond())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isCertificateChainTrusted(@NotNull List<? extends Certificate> certs, @NotNull Certificate certificateAuthority) {
        Intrinsics.checkNotNullParameter(certs, (String)"certs");
        Intrinsics.checkNotNullParameter((Object)certificateAuthority, (String)"certificateAuthority");
        Certificate lastCert = (Certificate)CollectionsKt.last(certs);
        return Intrinsics.areEqual((Object)lastCert, (Object)certificateAuthority) || this.isSignedBy(lastCert, certificateAuthority);
    }

    private final boolean isSignedBy(Certificate $this$isSignedBy, Certificate other) {
        boolean bl;
        try {
            $this$isSignedBy.verify(other.getPublicKey());
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private CertificateUtils() {
    }

    static {
        CertificateUtils certificateUtils;
        INSTANCE = certificateUtils = new CertificateUtils();
        Date date = Date.from(LocalDate.of(9999, 12, 31).atStartOfDay().toInstant(ZoneOffset.UTC));
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"Date.from(\n        Local\u2026ant(ZoneOffset.UTC)\n    )");
        farAwayDate = date;
    }
}

