/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.instrumentation.LineEnumerator;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.Opcodes;
import org.jetbrains.coverage.org.objectweb.asm.Type;
import org.jetbrains.coverage.org.objectweb.asm.commons.LocalVariablesSorter;

public class TouchCounter
extends LocalVariablesSorter
implements Opcodes {
    private final LineEnumerator myEnumerator;
    private Label myStartLabel;
    private Label myEndLabel;
    private int myClassDataIndex;

    public TouchCounter(LineEnumerator enumerator, int access, String desc) {
        super(589824, access, desc, enumerator.getWV());
        this.myEnumerator = enumerator;
    }

    public void visitLineNumber(int line, Label start) {
        this.mv.visitVarInsn(25, this.myClassDataIndex);
        this.pushIntValue(line);
        this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "trace", "(Ljava/lang/Object;I)V", false);
        super.visitLineNumber(line, start);
    }

    public void visitLabel(Label label) {
        if (this.myStartLabel == null) {
            this.myStartLabel = label;
        }
        this.myEndLabel = label;
        super.visitLabel(label);
        this.visitPossibleJump(label);
        LineEnumerator.Switch aSwitch = this.myEnumerator.getSwitch(label);
        if (aSwitch != null) {
            this.mv.visitVarInsn(25, this.myClassDataIndex);
            this.pushIntValue(aSwitch.getLine());
            this.pushIntValue(aSwitch.getIndex());
            this.mv.visitIntInsn(17, aSwitch.getKey());
            this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "touchSwitch", "(Ljava/lang/Object;III)V", false);
        }
    }

    private void touchBranch(boolean trueHit, int jumpIndex, int line) {
        this.mv.visitVarInsn(25, this.myClassDataIndex);
        this.pushIntValue(line);
        this.pushIntValue(jumpIndex);
        this.mv.visitInsn(trueHit ? 3 : 4);
        this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "touchJump", "(Ljava/lang/Object;IIZ)V", false);
    }

    private void visitPossibleJump(Label label) {
        LineEnumerator.Jump jump = this.myEnumerator.getJump(label);
        if (jump != null) {
            this.touchBranch(jump.getType(), jump.getIndex(), jump.getLine());
        }
    }

    public void visitCode() {
        this.mv.visitLdcInsn(this.myEnumerator.getClassName());
        this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "loadClassData", "(Ljava/lang/String;)Ljava/lang/Object;", false);
        this.myClassDataIndex = this.newLocal(Type.getType("Ljava/lang/Object;"));
        this.mv.visitVarInsn(58, this.myClassDataIndex);
        super.visitCode();
    }

    private void pushIntValue(int value) {
        if (value <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, value);
        } else {
            this.mv.visitLdcInsn(value);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.myStartLabel != null && this.myEndLabel != null) {
            this.mv.visitLocalVariable("__class__data__", "Ljava/lang/Object;", null, this.myStartLabel, this.myEndLabel, this.myClassDataIndex);
        }
        super.visitMaxs(maxStack, maxLocals);
    }
}

