/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.util.LinesUtil;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;
import org.jetbrains.coverage.org.objectweb.asm.commons.LocalVariablesSorter;

public class SamplingInstrumenter
extends Instrumenter {
    private static final String OBJECT_TYPE = "Ljava/lang/Object;";

    public SamplingInstrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldCalculateSource) {
        super(projectData, classVisitor, className, shouldCalculateSource);
    }

    protected MethodVisitor createMethodLineEnumerator(MethodVisitor mv, final String name, final String desc, int access, String signature, String[] exceptions) {
        return new LocalVariablesSorter(589824, access, desc, mv){
            private Label myStartLabel;
            private Label myEndLabel;
            private int myClassDataIndex;

            public void visitLabel(Label label) {
                if (this.myStartLabel == null) {
                    this.myStartLabel = label;
                }
                this.myEndLabel = label;
                super.visitLabel(label);
            }

            public void visitLineNumber(int line, Label start) {
                SamplingInstrumenter.this.getOrCreateLineData(line, name, desc);
                this.mv.visitVarInsn(25, this.myClassDataIndex);
                if (line <= Short.MAX_VALUE) {
                    this.mv.visitIntInsn(17, line);
                } else {
                    this.mv.visitLdcInsn(line);
                }
                this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "touchLine", "(Ljava/lang/Object;I)V", false);
                super.visitLineNumber(line, start);
            }

            public void visitCode() {
                this.mv.visitLdcInsn(SamplingInstrumenter.this.getClassName());
                this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "loadClassData", "(Ljava/lang/String;)Ljava/lang/Object;", false);
                this.myClassDataIndex = this.newLocal(Type.getType(SamplingInstrumenter.OBJECT_TYPE));
                this.mv.visitVarInsn(58, this.myClassDataIndex);
                super.visitCode();
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                if (this.myStartLabel != null && this.myEndLabel != null) {
                    this.mv.visitLocalVariable("__class__data__", SamplingInstrumenter.OBJECT_TYPE, null, this.myStartLabel, this.myEndLabel, this.myClassDataIndex);
                }
                super.visitMaxs(maxStack, maxLocals);
            }
        };
    }

    protected void initLineData() {
        LineData[] lines = LinesUtil.calcLineArray(this.myMaxLineNumber, this.myLines);
        this.myClassData.initLineMask(lines);
        this.myClassData.setLines(lines);
    }
}

