/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrumentation.ClassInstrumenter;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.SaveLabelsMethodNode;
import com.intellij.rt.coverage.instrumentation.TouchCounter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Opcodes;
import org.jetbrains.coverage.org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineEnumerator
extends MethodVisitor
implements Opcodes {
    private final ClassInstrumenter myClassInstrumenter;
    private final int myAccess;
    private final String myMethodName;
    private final String mySignature;
    private final MethodNode myMethodNode;
    private int myCurrentLine;
    private int myCurrentSwitch;
    private Label myLastFalseJump;
    private Label myLastTrueJump;
    private boolean myHasExecutableLines = false;
    private Map<Label, Jump> myJumps;
    private Map<Label, Switch> mySwitches;
    private final MethodVisitor myWriterMethodVisitor;
    private static final byte SEEN_NOTHING = 0;
    private static final byte DUP_SEEN = 1;
    private static final byte IFNONNULL_SEEN = 2;
    private static final byte PARAM_CONST_SEEN = 3;
    private static final byte ASSERTIONS_DISABLED_STATE = 5;
    private byte myState = 0;
    private boolean myHasInstructions;
    private final HashMap<Label, SwitchData> mySwitchLabels = new HashMap();

    public LineEnumerator(ClassInstrumenter classInstrumenter, MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions) {
        super(589824, new SaveLabelsMethodNode(access, name, desc, signature, exceptions));
        this.myMethodNode = (MethodNode)this.mv;
        this.myClassInstrumenter = classInstrumenter;
        this.myWriterMethodVisitor = mv;
        this.myAccess = access;
        this.myMethodName = name;
        this.mySignature = desc;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.myMethodNode.accept(!this.myHasExecutableLines ? this.myWriterMethodVisitor : new TouchCounter(this, this.myAccess, this.mySignature));
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.myHasInstructions = false;
        this.myCurrentLine = line;
        this.myCurrentSwitch = 0;
        this.myHasExecutableLines = true;
        this.myClassInstrumenter.getOrCreateLineData(this.myCurrentLine, this.myMethodName, this.mySignature);
    }

    public String getClassName() {
        return this.myClassInstrumenter.getClassName();
    }

    public MethodVisitor getWV() {
        return this.myWriterMethodVisitor;
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        LineData lineData;
        if (!this.myHasExecutableLines) {
            super.visitJumpInsn(opcode, label);
            return;
        }
        boolean jumpInstrumented = false;
        if (opcode != 167 && opcode != 168 && !this.myMethodName.equals("<clinit>") && (lineData = this.myClassInstrumenter.getLineData(this.myCurrentLine)) != null) {
            int currentJump = lineData.jumpsCount();
            Jump trueJump = new Jump(currentJump, this.myCurrentLine, true);
            Jump falseJump = new Jump(currentJump, this.myCurrentLine, false);
            Label trueLabel = new Label();
            Label falseLabel = new Label();
            this.myLastTrueJump = trueLabel;
            this.myLastFalseJump = falseLabel;
            if (this.myJumps == null) {
                this.myJumps = new HashMap<Label, Jump>();
            }
            this.myJumps.put(this.myLastFalseJump, falseJump);
            this.myJumps.put(this.myLastTrueJump, trueJump);
            lineData.addJump(currentJump);
            jumpInstrumented = true;
            super.visitJumpInsn(opcode, trueLabel);
            super.visitJumpInsn(167, falseLabel);
            super.visitLabel(trueLabel);
            super.visitJumpInsn(167, label);
            super.visitLabel(falseLabel);
        }
        if (this.myState == 5 && opcode == 154) {
            this.myState = 0;
            if (jumpInstrumented) {
                this.removeLastJump();
            }
        }
        this.myState = this.myState == 1 && opcode == 199 ? (byte)2 : (byte)0;
        this.myHasInstructions = true;
        if (!jumpInstrumented) {
            super.visitJumpInsn(opcode, label);
        }
    }

    Jump getJump(Label jump) {
        if (this.myJumps == null) {
            return null;
        }
        return this.myJumps.get(jump);
    }

    private SwitchLabels replaceLabels(SwitchLabels original) {
        int i;
        Label beforeSwitchLabel = new Label();
        Label newDefaultLabel = new Label();
        Label[] newLabels = new Label[original.getLabels().length];
        for (i = 0; i < original.getLabels().length; ++i) {
            newLabels[i] = new Label();
        }
        super.visitJumpInsn(167, beforeSwitchLabel);
        for (i = 0; i < newLabels.length; ++i) {
            super.visitLabel(newLabels[i]);
            super.visitJumpInsn(167, original.getLabels()[i]);
        }
        super.visitLabel(newDefaultLabel);
        super.visitJumpInsn(167, original.getDefault());
        super.visitLabel(beforeSwitchLabel);
        return new SwitchLabels(newDefaultLabel, newLabels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (!this.myHasExecutableLines) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            return;
        }
        SwitchLabels switchLabels = new SwitchLabels(dflt, labels);
        LineData lineData = this.myClassInstrumenter.getLineData(this.myCurrentLine);
        if (lineData != null) {
            switchLabels = this.replaceLabels(switchLabels);
            this.rememberSwitchLabels(switchLabels.getDefault(), switchLabels.getLabels());
            lineData.addSwitch(this.myCurrentSwitch++, keys);
        }
        super.visitLookupSwitchInsn(switchLabels.getDefault(), keys, switchLabels.getLabels());
        this.myState = 0;
        this.myHasInstructions = true;
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (!this.myHasExecutableLines) {
            super.visitTableSwitchInsn(min, max, dflt, labels);
            return;
        }
        SwitchLabels switchLabels = new SwitchLabels(dflt, labels);
        LineData lineData = this.myClassInstrumenter.getLineData(this.myCurrentLine);
        if (lineData != null) {
            switchLabels = this.replaceLabels(switchLabels);
            this.rememberSwitchLabels(switchLabels.getDefault(), switchLabels.getLabels());
            SwitchData switchData = lineData.addSwitch(this.myCurrentSwitch++, min, max);
            this.mySwitchLabels.put(dflt, switchData);
        }
        super.visitTableSwitchInsn(min, max, switchLabels.getDefault(), switchLabels.getLabels());
        this.myState = 0;
        this.myHasInstructions = true;
    }

    private void rememberSwitchLabels(Label dflt, Label[] labels) {
        if (this.mySwitches == null) {
            this.mySwitches = new HashMap<Label, Switch>();
        }
        this.mySwitches.put(dflt, new Switch(this.myCurrentSwitch, this.myCurrentLine, -1));
        for (int i = labels.length - 1; i >= 0; --i) {
            this.mySwitches.put(labels[i], new Switch(this.myCurrentSwitch, this.myCurrentLine, i));
        }
    }

    public Switch getSwitch(Label label) {
        if (this.mySwitches == null) {
            return null;
        }
        return this.mySwitches.get(label);
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    @Override
    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (!this.myHasExecutableLines) {
            return;
        }
        if (opcode == 177 && !this.myHasInstructions) {
            this.myClassInstrumenter.removeLine(this.myCurrentLine);
        } else {
            this.myHasInstructions = true;
        }
        this.myState = opcode == 89 ? (byte)1 : (this.myState == 2 && (opcode >= 3 && opcode <= 8 || opcode == 16 || opcode == 17) ? (byte)3 : (byte)0);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        if (!this.myHasExecutableLines) {
            return;
        }
        this.myState = 0;
        this.myHasInstructions = true;
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        if (!this.myHasExecutableLines) {
            return;
        }
        this.myState = 0;
        this.myHasInstructions = true;
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        if (!this.myHasExecutableLines) {
            return;
        }
        this.myState = 0;
        this.myHasInstructions = true;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        if (!this.myHasExecutableLines) {
            return;
        }
        this.myState = opcode == 178 && name.equals("$assertionsDisabled") ? (byte)5 : (byte)0;
        this.myHasInstructions = true;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        if (!this.myHasExecutableLines) {
            return;
        }
        if (this.myState == 3 && opcode == 184 && name.startsWith("$$$reportNull$$$") && ClassNameUtil.convertToFQName(owner).equals(this.myClassInstrumenter.getClassName())) {
            this.removeLastJump();
            this.myState = 0;
        } else {
            this.myState = 0;
        }
        this.myHasInstructions = true;
    }

    public void removeLastJump() {
        LineData lineData = this.myClassInstrumenter.getLineData(this.myCurrentLine);
        if (lineData != null && this.myLastFalseJump != null) {
            lineData.removeJump(lineData.jumpsCount() - 1);
            this.myJumps.remove(this.myLastFalseJump);
            this.myJumps.remove(this.myLastTrueJump);
            this.myLastTrueJump = null;
            this.myLastFalseJump = null;
        }
    }

    public void removeLastSwitch(Label dflt, Label ... labels) {
        LineData lineData;
        this.mySwitchLabels.remove(dflt);
        if (this.mySwitches != null) {
            this.mySwitches.remove(dflt);
            for (Label label : labels) {
                this.mySwitches.remove(label);
            }
        }
        if ((lineData = this.myClassInstrumenter.getLineData(this.myCurrentLine)) != null) {
            lineData.removeSwitch(--this.myCurrentSwitch);
        }
    }

    @Override
    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        if (!this.myHasExecutableLines) {
            return;
        }
        this.myState = 0;
        this.myHasInstructions = true;
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        if (!this.myHasExecutableLines) {
            return;
        }
        this.myState = 0;
        this.myHasInstructions = true;
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(desc, dims);
        if (!this.myHasExecutableLines) {
            return;
        }
        this.myState = 0;
        this.myHasInstructions = true;
    }

    public Map<Label, SwitchData> getSwitchLabels() {
        return this.mySwitchLabels;
    }

    public String getDescriptor() {
        return this.mySignature;
    }

    public Instrumenter getInstrumenter() {
        return this.myClassInstrumenter;
    }

    private static class SwitchLabels {
        private final Label myDefault;
        private final Label[] myLabels;

        private SwitchLabels(Label dflt, Label[] labels) {
            this.myDefault = dflt;
            this.myLabels = labels;
        }

        public Label getDefault() {
            return this.myDefault;
        }

        public Label[] getLabels() {
            return this.myLabels;
        }
    }

    static class Switch {
        private final int myIndex;
        private final int myLine;
        private final int myKey;

        public Switch(int index, int line, int key) {
            this.myIndex = index;
            this.myLine = line;
            this.myKey = key;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public int getLine() {
            return this.myLine;
        }

        public int getKey() {
            return this.myKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Switch aSwitch = (Switch)o;
            return this.myIndex == aSwitch.myIndex && this.myLine == aSwitch.myLine && this.myKey == aSwitch.myKey;
        }

        public int hashCode() {
            int result = this.myIndex;
            result = 31 * result + this.myLine;
            result = 31 * result + this.myKey;
            return result;
        }
    }

    static class Jump {
        private final int myIndex;
        private final int myLine;
        private final boolean myType;

        public Jump(int index, int line, boolean type) {
            this.myIndex = index;
            this.myLine = line;
            this.myType = type;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public int getLine() {
            return this.myLine;
        }

        public boolean getType() {
            return this.myType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Jump jump = (Jump)o;
            return this.myIndex == jump.myIndex && this.myLine == jump.myLine && this.myType == jump.myType;
        }

        public int hashCode() {
            int result = this.myIndex;
            result = 31 * result + this.myLine;
            result = 31 * result + (this.myType ? 1 : 0);
            return result;
        }
    }
}

