/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.JSR45Util;
import com.intellij.rt.coverage.instrumentation.filters.signature.MethodSignatureFilter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import com.intellij.rt.coverage.util.StringsPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Instrumenter
extends ClassVisitor {
    private static final List<MethodSignatureFilter> ourSignatureFilters = Instrumenter.getMethodSignatureFilters();
    protected final ProjectData myProjectData;
    protected final ClassVisitor myClassVisitor;
    private final String myClassName;
    private final boolean myShouldCalculateSource;
    protected TIntObjectHashMap<LineData> myLines = new TIntObjectHashMap(4, 0.99f);
    protected int myMaxLineNumber;
    protected ClassData myClassData;
    protected boolean myProcess;
    private boolean myEnum;
    private boolean myHasInterfaces = false;
    private final List<String> myAnnotations = new ArrayList<String>();
    private HashMap<String, Object> myProperties;

    public Instrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldCalculateSource) {
        super(589824, classVisitor);
        this.myProjectData = projectData;
        this.myClassVisitor = classVisitor;
        this.myClassName = className;
        this.myShouldCalculateSource = shouldCalculateSource;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myEnum = (access & 0x4000) != 0;
        this.myProcess = (access & 0x200) == 0;
        this.myClassData = this.myProjectData.getOrCreateClassData(StringsPool.getFromPool(this.myClassName));
        this.myHasInterfaces = interfaces != null && interfaces.length > 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        if ((access & 0x40) != 0) {
            return mv;
        }
        if ((access & 0x400) != 0) {
            return mv;
        }
        if (this.myEnum && Instrumenter.isDefaultEnumMethod(name, desc, signature, this.myClassName)) {
            return mv;
        }
        for (MethodSignatureFilter filter : ourSignatureFilters) {
            if (!filter.shouldFilter(access, name, desc, signature, exceptions, this)) continue;
            return mv;
        }
        this.myProcess = true;
        return this.chainFilters(mv, access, name, desc, signature, exceptions);
    }

    private MethodVisitor chainFilters(MethodVisitor root, int access, String name, String desc, String signature, String[] exceptions) {
        root = this.createMethodLineEnumerator(root, name, desc, access, signature, exceptions);
        for (MethodVisitingFilter filter : Instrumenter.createVisitingFilters()) {
            if (!filter.isApplicable(this, access, name, desc, signature, exceptions)) continue;
            filter.initFilter(root, this, desc);
            root = filter;
        }
        return root;
    }

    private static boolean isDefaultEnumMethod(String name, String desc, String signature, String className) {
        return name.equals("values") && desc.equals("()[L" + className + ";") || name.equals("valueOf") && desc.equals("(Ljava/lang/String;)L" + className + ";") || name.equals("<init>") && signature != null && signature.equals("()V");
    }

    protected abstract MethodVisitor createMethodLineEnumerator(MethodVisitor var1, String var2, String var3, int var4, String var5, String[] var6);

    @Override
    public void visitEnd() {
        if (this.myProcess) {
            this.initLineData();
            this.myLines = null;
        }
        super.visitEnd();
    }

    protected abstract void initLineData();

    protected void getOrCreateLineData(int line, String name, String desc) {
        LineData lineData;
        if (this.myLines == null) {
            this.myLines = new TIntObjectHashMap();
        }
        if ((lineData = this.myLines.get(line)) == null) {
            lineData = new LineData(line, StringsPool.getFromPool(name + desc));
            this.myLines.put(line, lineData);
        }
        if (line > this.myMaxLineNumber) {
            this.myMaxLineNumber = line;
        }
    }

    public void removeLine(int line) {
        this.myLines.remove(line);
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        if (this.myShouldCalculateSource) {
            this.myProjectData.getOrCreateClassData(this.myClassName).setSource(source);
        }
        if (debug != null) {
            this.myProjectData.addLineMaps(this.myClassName, JSR45Util.extractLineMapping(debug, this.myClassName));
        }
    }

    public String getClassName() {
        return this.myClassName;
    }

    @Override
    public void visitOuterClass(String outerClassName, String methodName, String methodSig) {
        if (this.myShouldCalculateSource) {
            this.myProjectData.getOrCreateClassData(outerClassName).setSource(this.myClassData.getSource());
        }
        super.visitOuterClass(outerClassName, methodName, methodSig);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.myAnnotations.add(StringsPool.getFromPool(descriptor));
        return super.visitAnnotation(descriptor, visible);
    }

    public boolean isSampling() {
        return this.myProjectData.isSampling();
    }

    public boolean hasInterfaces() {
        return this.myHasInterfaces;
    }

    public List<String> getAnnotations() {
        return this.myAnnotations;
    }

    public LineData getLineData(int line) {
        return this.myLines.get(line);
    }

    public Object getProperty(String key) {
        this.createProperties();
        return this.myProperties.get(key);
    }

    public void addProperty(String key, Object value) {
        this.createProperties();
        this.myProperties.put(key, value);
    }

    private void createProperties() {
        if (this.myProperties == null) {
            this.myProperties = new HashMap();
        }
    }

    private static List<MethodVisitingFilter> createVisitingFilters() {
        return KotlinUtils.createVisitingFilters();
    }

    private static List<MethodSignatureFilter> getMethodSignatureFilters() {
        return KotlinUtils.createSignatureFilters();
    }
}

