/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.LineEnumerator;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.LineEnumeratorFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import com.intellij.rt.coverage.util.LinesUtil;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInstrumenter
extends Instrumenter {
    public ClassInstrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldCalculateSource) {
        super(projectData, classVisitor, className, shouldCalculateSource);
    }

    @Override
    protected MethodVisitor createMethodLineEnumerator(MethodVisitor mv, String name, String desc, int access, String signature, String[] exceptions) {
        LineEnumerator enumerator = new LineEnumerator(this, mv, access, name, desc, signature, exceptions);
        return this.chainFilters(name, desc, access, signature, exceptions, enumerator);
    }

    private MethodVisitor chainFilters(String name, String desc, int access, String signature, String[] exceptions, LineEnumerator enumerator) {
        MethodVisitor root = enumerator;
        for (LineEnumeratorFilter filter : ClassInstrumenter.createLineEnumeratorFilters()) {
            if (!filter.isApplicable(this, access, name, desc, signature, exceptions)) continue;
            filter.initFilter(root, enumerator);
            root = filter;
        }
        return root;
    }

    @Override
    protected void initLineData() {
        this.myClassData.setLines(LinesUtil.calcLineArray(this.myMaxLineNumber, this.myLines));
    }

    @Override
    public LineData getLineData(int line) {
        return (LineData)this.myLines.get(line);
    }

    private static List<LineEnumeratorFilter> createLineEnumeratorFilters() {
        return KotlinUtils.createLineEnumeratorFilters();
    }
}

