/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectData
implements CoverageData,
Serializable {
    public static final String PROJECT_DATA_OWNER = "com/intellij/rt/coverage/data/ProjectData";
    private static final MethodCaller TOUCH_LINE_METHOD = new MethodCaller("touchLine", new Class[]{Integer.TYPE});
    private static final MethodCaller TOUCH_LINES_METHOD = new MethodCaller("touchLines", new Class[]{int[].class});
    private static final MethodCaller TOUCH_SWITCH_METHOD = new MethodCaller("touch", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
    private static final MethodCaller TOUCH_JUMP_METHOD = new MethodCaller("touch", new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE});
    private static final MethodCaller TOUCH_METHOD = new MethodCaller("touch", new Class[]{Integer.TYPE});
    private static final MethodCaller GET_CLASS_DATA_METHOD = new MethodCaller("getClassData", new Class[]{String.class});
    private static final MethodCaller TRACE_LINE_METHOD = new MethodCaller("traceLine", new Class[]{Object.class, Integer.TYPE});
    private static boolean ourStopped = false;
    public static ProjectData ourProjectData;
    private File myDataFile;
    private String myCurrentTestName;
    private boolean myTraceLines;
    private boolean mySampling;
    private Map<ClassData, boolean[]> myTrace;
    private File myTracesDir;
    private final ClassesMap myClasses = new ClassesMap();
    private Map<String, FileMapData[]> myLinesMap;
    private static Object ourProjectDataObject;

    public ClassData getClassData(String name) {
        return this.myClasses.get(name);
    }

    public ClassData getOrCreateClassData(String name) {
        ClassData classData = this.myClasses.get(name);
        if (classData == null) {
            classData = new ClassData(name);
            this.myClasses.put(name, classData);
        }
        return classData;
    }

    public static ProjectData getProjectData() {
        return ourProjectData;
    }

    public void stop() {
        ourStopped = true;
    }

    public boolean isStopped() {
        return ourStopped;
    }

    public boolean isSampling() {
        return this.mySampling;
    }

    public static ProjectData createProjectData(File dataFile, ProjectData initialData, boolean traceLines, boolean isSampling) throws IOException {
        ProjectData projectData = ourProjectData = initialData == null ? new ProjectData() : initialData;
        if (dataFile != null && !dataFile.exists()) {
            File parentDir = dataFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            dataFile.createNewFile();
        }
        ProjectData.ourProjectData.mySampling = isSampling;
        ProjectData.ourProjectData.myTraceLines = traceLines;
        ProjectData.ourProjectData.myDataFile = dataFile;
        return ourProjectData;
    }

    @Override
    public void merge(CoverageData data) {
        ProjectData projectData = (ProjectData)data;
        Iterator<String> iterator = projectData.myClasses.names().iterator();
        while (iterator.hasNext()) {
            String o;
            String key = o = iterator.next();
            ClassData mergedData = projectData.myClasses.get(key);
            ClassData classData = this.myClasses.get(key);
            if (classData == null) {
                classData = new ClassData(mergedData.getName());
                this.myClasses.put(key, classData);
            }
            classData.merge(mergedData);
        }
    }

    public void checkLineMappings() {
        if (this.myLinesMap != null) {
            Iterator<String> iterator = this.myLinesMap.keySet().iterator();
            while (iterator.hasNext()) {
                String o;
                String className = o = iterator.next();
                ClassData classData = this.getClassData(className);
                FileMapData[] fileData = this.myLinesMap.get(className);
                FileMapData mainData = null;
                for (FileMapData aFileData : fileData) {
                    String fileName = aFileData.getClassName();
                    if (fileName.equals(className)) {
                        mainData = aFileData;
                        continue;
                    }
                    ClassData classInfo = this.getOrCreateClassData(fileName);
                    classInfo.checkLineMappings(aFileData.getLines(), classData);
                }
                if (mainData == null) continue;
                classData.checkLineMappings(mainData.getLines(), classData);
            }
        }
    }

    public void addLineMaps(String className, FileMapData[] fileDatas) {
        if (this.myLinesMap == null) {
            this.myLinesMap = new HashMap<String, FileMapData[]>();
        }
        this.myLinesMap.put(className, fileDatas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded(String name) {
        if (this.myTrace == null) {
            return;
        }
        File traceFile = new File(this.getTracesDir(), name + ".tr");
        try {
            if (!traceFile.exists()) {
                traceFile.createNewFile();
            }
            FilterOutputStream os = null;
            try {
                os = new DataOutputStream(new FileOutputStream(traceFile));
                ((DataOutputStream)os).writeInt(this.myTrace.size());
                for (ClassData classData : this.myTrace.keySet()) {
                    ((DataOutputStream)os).writeUTF(classData.toString());
                    boolean[] lines = this.myTrace.get(classData);
                    int numberOfTraces = 0;
                    for (boolean line : lines) {
                        if (!line) continue;
                        ++numberOfTraces;
                    }
                    ((DataOutputStream)os).writeInt(numberOfTraces);
                    for (int idx = 0; idx < lines.length; ++idx) {
                        boolean incl = lines[idx];
                        if (!incl) continue;
                        ((DataOutputStream)os).writeInt(idx);
                    }
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        catch (IOException e) {
            ErrorReporter.reportError("Error writing traces to file " + traceFile.getPath(), e);
        }
        finally {
            this.myTrace = null;
        }
    }

    public void testStarted(String name) {
        this.myCurrentTestName = name;
        if (this.myTraceLines) {
            this.myTrace = new ConcurrentHashMap<ClassData, boolean[]>();
        }
    }

    private File getTracesDir() {
        if (this.myTracesDir == null) {
            String fileName = this.myDataFile.getName();
            int i = fileName.lastIndexOf(46);
            String dirName = i != -1 ? fileName.substring(0, i) : fileName;
            this.myTracesDir = new File(this.myDataFile.getParent(), dirName);
            if (!this.myTracesDir.exists()) {
                this.myTracesDir.mkdirs();
            }
        }
        return this.myTracesDir;
    }

    public static String getCurrentTestName() {
        try {
            Object projectDataObject = ProjectData.getProjectDataObject();
            return (String)projectDataObject.getClass().getDeclaredField("myCurrentTestName").get(projectDataObject);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Current test name was not retrieved:", e);
            return null;
        }
    }

    public Map<String, ClassData> getClasses() {
        return this.myClasses.asMap();
    }

    public static void touchLine(Object classData, int line) {
        if (ourProjectData != null) {
            ((ClassData)classData).touchLine(line);
            return;
        }
        ProjectData.touch(TOUCH_LINE_METHOD, classData, new Object[]{line});
    }

    public static void touchSwitch(Object classData, int line, int switchNumber, int key) {
        if (ourProjectData != null) {
            ((ClassData)classData).touch(line, switchNumber, key);
            return;
        }
        ProjectData.touch(TOUCH_SWITCH_METHOD, classData, new Object[]{line, switchNumber, key});
    }

    public static void touchJump(Object classData, int line, int jump, boolean hit) {
        if (ourProjectData != null) {
            ((ClassData)classData).touch(line, jump, hit);
            return;
        }
        ProjectData.touch(TOUCH_JUMP_METHOD, classData, new Object[]{line, jump, hit});
    }

    public static void trace(Object classData, int line) {
        if (ourProjectData != null) {
            ((ClassData)classData).touch(line);
            ourProjectData.traceLine((ClassData)classData, line);
            return;
        }
        ProjectData.touch(TOUCH_METHOD, classData, new Object[]{line});
        try {
            Object projectData = ProjectData.getProjectDataObject();
            TRACE_LINE_METHOD.invoke(projectData, new Object[]{classData, line});
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error tracing class " + classData.toString(), e);
        }
    }

    private static Object touch(MethodCaller methodCaller, Object classData, Object[] paramValues) {
        try {
            return methodCaller.invoke(classData, paramValues);
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in project data collection: " + methodCaller.myMethodName, e);
            return null;
        }
    }

    public static int[] touchClassLines(String className, int[] lines) {
        if (ourProjectData != null) {
            return ourProjectData.getClassData(className).touchLines(lines);
        }
        try {
            Object projectDataObject = ProjectData.getProjectDataObject();
            Object classData = GET_CLASS_DATA_METHOD.invoke(projectDataObject, new Object[]{className});
            return (int[])ProjectData.touch(TOUCH_LINES_METHOD, classData, new Object[]{lines});
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in class data loading: " + className, e);
            return lines;
        }
    }

    public static Object loadClassData(String className) {
        if (ourProjectData != null) {
            return ourProjectData.getClassData(className);
        }
        try {
            Object projectDataObject = ProjectData.getProjectDataObject();
            return GET_CLASS_DATA_METHOD.invoke(projectDataObject, new Object[]{className});
        }
        catch (Exception e) {
            ErrorReporter.reportError("Error in class data loading: " + className, e);
            return null;
        }
    }

    private static Object getProjectDataObject() throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        if (ourProjectDataObject == null) {
            Class<?> projectDataClass = Class.forName(ProjectData.class.getName(), false, null);
            ourProjectDataObject = projectDataClass.getDeclaredField("ourProjectData").get(null);
        }
        return ourProjectDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceLine(ClassData classData, int line) {
        if (this.myTrace != null) {
            Map<ClassData, boolean[]> map = this.myTrace;
            synchronized (map) {
                boolean[] lines = this.myTrace.get(classData);
                if (lines == null) {
                    lines = new boolean[line + 20];
                    this.myTrace.put(classData, lines);
                }
                if (lines.length <= line) {
                    boolean[] longLines = new boolean[line + 20];
                    System.arraycopy(lines, 0, longLines, 0, lines.length);
                    lines = longLines;
                    this.myTrace.put(classData, lines);
                }
                lines[line] = true;
            }
        }
    }

    private static class IdentityClassData {
        private final String myClassName;
        private final ClassData myClassData;

        private IdentityClassData(String className, ClassData classData) {
            this.myClassName = className;
            this.myClassData = classData;
        }

        public ClassData getClassData(String name) {
            if (name == this.myClassName) {
                return this.myClassData;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassesMap {
        private static final int POOL_SIZE = 1024;
        private static final int MASK = 1023;
        private static final int DEFAULT_CAPACITY = 1000;
        private final IdentityClassData[] myIdentityArray = new IdentityClassData[1024];
        private final Map<String, ClassData> myClasses = ClassesMap.createClassesMap();

        private ClassesMap() {
        }

        public ClassData get(String name) {
            ClassData data;
            int idx = name.hashCode() & 0x3FF;
            IdentityClassData lastClassData = this.myIdentityArray[idx];
            if (lastClassData != null && (data = lastClassData.getClassData(name)) != null) {
                return data;
            }
            data = this.myClasses.get(name);
            this.myIdentityArray[idx] = new IdentityClassData(name, data);
            return data;
        }

        public void put(String name, ClassData data) {
            this.myClasses.put(name, data);
        }

        public HashMap<String, ClassData> asMap() {
            return new HashMap<String, ClassData>(this.myClasses);
        }

        public Collection<String> names() {
            return this.myClasses.keySet();
        }

        private static Map<String, ClassData> createClassesMap() {
            if ("true".equals(System.getProperty("idea.coverage.thread-safe.enabled", "true"))) {
                return new ConcurrentHashMap<String, ClassData>(1000);
            }
            return new HashMap<String, ClassData>(1000);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodCaller {
        private Method myMethod;
        private final String myMethodName;
        private final Class[] myParamTypes;

        private MethodCaller(String methodName, Class[] paramTypes) {
            this.myMethodName = methodName;
            this.myParamTypes = paramTypes;
        }

        public Object invoke(Object thisObj, Object[] paramValues) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            if (this.myMethod == null) {
                this.myMethod = MethodCaller.findMethod(thisObj.getClass(), this.myMethodName, this.myParamTypes);
            }
            return this.myMethod.invoke(thisObj, paramValues);
        }

        private static Method findMethod(Class<?> clazz, String name, Class[] paramTypes) throws NoSuchMethodException {
            Method m = clazz.getDeclaredMethod(name, paramTypes);
            m.setAccessible(true);
            return m;
        }
    }
}

