/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.JumpsAndSwitches;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.DataOutputStream;
import java.io.IOException;

public class LineData
implements CoverageData {
    private final int myLineNumber;
    private String myMethodSignature;
    private int myHits = 0;
    private byte myStatus = (byte)-1;
    private String myUniqueTestName = null;
    private boolean myMayBeUnique = true;
    private JumpsAndSwitches myJumpsAndSwitches;

    public LineData(int line, String desc) {
        this.myLineNumber = line;
        this.myMethodSignature = desc;
    }

    public void touch() {
        ++this.myHits;
        this.setTestName(ProjectData.getCurrentTestName());
    }

    public int getHits() {
        return this.myHits;
    }

    JumpsAndSwitches getOrCreateJumpsAndSwitches() {
        if (this.myJumpsAndSwitches == null) {
            this.myJumpsAndSwitches = new JumpsAndSwitches();
        }
        return this.myJumpsAndSwitches;
    }

    public int getStatus() {
        if (this.myStatus != -1) {
            return this.myStatus;
        }
        if (this.myHits == 0) {
            this.myStatus = 0;
            return this.myStatus;
        }
        if (this.myJumpsAndSwitches != null) {
            SwitchData[] switches;
            JumpData[] jumps = this.getOrCreateJumpsAndSwitches().getJumps();
            if (jumps != null) {
                for (JumpData jumpData : jumps) {
                    if ((jumpData.getFalseHits() > 0 ? 1 : 0) + (jumpData.getTrueHits() > 0 ? 1 : 0) >= 2) continue;
                    this.myStatus = 1;
                    return this.myStatus;
                }
            }
            if ((switches = this.getOrCreateJumpsAndSwitches().getSwitches()) != null) {
                for (SwitchData switchData : switches) {
                    if (switchData.getDefaultHits() == 0) {
                        this.myStatus = 1;
                        return this.myStatus;
                    }
                    for (int i = 0; i < switchData.getHits().length; ++i) {
                        int hit = switchData.getHits()[i];
                        if (hit != 0) continue;
                        this.myStatus = 1;
                        return this.myStatus;
                    }
                }
            }
        }
        this.myStatus = (byte)2;
        return this.myStatus;
    }

    public void save(DataOutputStream os) throws IOException {
        CoverageIOUtil.writeINT(os, this.myLineNumber);
        CoverageIOUtil.writeUTF(os, this.myUniqueTestName != null ? this.myUniqueTestName : "");
        CoverageIOUtil.writeINT(os, this.myHits);
        if (this.myHits > 0) {
            if (this.myJumpsAndSwitches != null) {
                this.getOrCreateJumpsAndSwitches().save(os);
            } else {
                new JumpsAndSwitches().save(os);
            }
        }
    }

    public void merge(CoverageData data) {
        byte status;
        LineData lineData = (LineData)data;
        this.myHits += lineData.myHits;
        if (this.myJumpsAndSwitches != null || lineData.myJumpsAndSwitches != null) {
            this.getOrCreateJumpsAndSwitches().merge(lineData.getOrCreateJumpsAndSwitches());
        }
        if (lineData.myMethodSignature != null) {
            this.myMethodSignature = lineData.myMethodSignature;
        }
        if (this.myStatus != -1 && (status = (byte)lineData.getStatus()) > this.myStatus) {
            this.myStatus = status;
        }
    }

    public int jumpsCount() {
        if (this.myJumpsAndSwitches == null) {
            return 0;
        }
        return this.myJumpsAndSwitches.jumpsCount();
    }

    public JumpData addJump(int jump) {
        return this.getOrCreateJumpsAndSwitches().addJump(jump);
    }

    public JumpData getJumpData(int jump) {
        return this.getOrCreateJumpsAndSwitches().getJumpData(jump);
    }

    public void touchBranch(int jump, boolean hit) {
        JumpData jumpData = this.getJumpData(jump);
        if (jumpData != null) {
            if (hit) {
                jumpData.touchTrueHit();
            } else {
                jumpData.touchFalseHit();
            }
        }
    }

    public SwitchData addSwitch(int switchNumber, int[] keys) {
        return this.getOrCreateJumpsAndSwitches().addSwitch(switchNumber, keys);
    }

    public void removeSwitch(int switchNumber) {
        this.getOrCreateJumpsAndSwitches().removeSwitch(switchNumber);
    }

    public SwitchData getSwitchData(int switchNumber) {
        return this.getOrCreateJumpsAndSwitches().getSwitchData(switchNumber);
    }

    public SwitchData addSwitch(int switchNumber, int min, int max) {
        int[] keys = new int[max - min + 1];
        for (int i = min; i <= max; ++i) {
            keys[i - min] = i;
        }
        return this.addSwitch(switchNumber, keys);
    }

    public void touchBranch(int switchNumber, int key) {
        SwitchData switchData = this.getSwitchData(switchNumber);
        if (switchData != null) {
            switchData.touch(key);
        }
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    public String getMethodSignature() {
        return this.myMethodSignature;
    }

    public void setStatus(byte status) {
        this.myStatus = status;
    }

    public void setTrueHits(int jumpNumber, int trueHits) {
        this.addJump(jumpNumber).setTrueHits(trueHits);
    }

    public void setFalseHits(int jumpNumber, int falseHits) {
        this.addJump(jumpNumber).setFalseHits(falseHits);
    }

    public void setDefaultHits(int switchNumber, int[] keys, int defaultHit) {
        this.addSwitch(switchNumber, keys).setDefaultHits(defaultHit);
    }

    public void setSwitchHits(int switchNumber, int[] keys, int[] hits) {
        this.addSwitch(switchNumber, keys).setKeysAndHits(keys, hits);
    }

    public JumpData[] getJumps() {
        if (this.myJumpsAndSwitches == null) {
            return null;
        }
        return this.getOrCreateJumpsAndSwitches().getJumps();
    }

    public SwitchData[] getSwitches() {
        if (this.myJumpsAndSwitches == null) {
            return null;
        }
        return this.getOrCreateJumpsAndSwitches().getSwitches();
    }

    public BranchData getBranchData() {
        SwitchData[] switches;
        if (this.myJumpsAndSwitches == null) {
            return null;
        }
        int total = 0;
        int covered = 0;
        JumpData[] jumps = this.myJumpsAndSwitches.getJumps();
        if (jumps != null) {
            for (JumpData jump : jumps) {
                ++total;
                if (jump.getFalseHits() <= 0 || jump.getTrueHits() <= 0) continue;
                ++covered;
            }
        }
        if ((switches = this.myJumpsAndSwitches.getSwitches()) != null) {
            for (SwitchData switchData : switches) {
                for (int hit : switchData.getHits()) {
                    ++total;
                    if (hit <= 0) continue;
                    ++covered;
                }
            }
        }
        return new BranchData(total, covered);
    }

    public void setHits(int hits) {
        this.myHits = hits;
    }

    public void setTestName(String testName) {
        if (testName != null) {
            if (this.myUniqueTestName == null) {
                if (this.myMayBeUnique) {
                    this.myUniqueTestName = testName;
                }
            } else if (!this.myUniqueTestName.equals(testName)) {
                this.myUniqueTestName = null;
                this.myMayBeUnique = false;
            }
        }
    }

    public boolean isCoveredByOneTest() {
        return this.myUniqueTestName != null && this.myUniqueTestName.length() > 0;
    }

    public void removeJump(int jump) {
        if (this.myJumpsAndSwitches == null) {
            return;
        }
        this.getOrCreateJumpsAndSwitches().removeJump(jump);
    }

    public void fillArrays() {
        if (this.myJumpsAndSwitches == null) {
            return;
        }
        this.getOrCreateJumpsAndSwitches().fillArrays();
    }
}

