/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementType;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLScalarText;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;

public class YAMLScalarTextImpl
extends YAMLBlockScalarImpl
implements YAMLScalarText {
    public YAMLScalarTextImpl(@NotNull ASTNode node) {
        if (node == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    protected IElementType getContentType() {
        YAMLElementType yAMLElementType = YAMLTokenTypes.SCALAR_TEXT;
        if (yAMLElementType == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(1);
        }
        return yAMLElementType;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges, int indexBefore) {
        if (text == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(2);
        }
        if (contentRanges == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(3);
        }
        TextRange leftRange = contentRanges.get(indexBefore);
        TextRange rightRange = contentRanges.get(indexBefore + 1);
        if (leftRange.isEmpty()) {
            if (rightRange.getLength() == 1 && text.charAt(rightRange.getStartOffset()) == '\n' && this.getChompingIndicator() != YAMLBlockScalarImpl.ChompingIndicator.KEEP) {
                return "";
            }
            return "\n";
        }
        if (YAMLScalarTextImpl.startsWithWhitespace(text, leftRange) || YAMLScalarTextImpl.startsWithWhitespace(text, rightRange)) {
            return "\n";
        }
        if (rightRange.isEmpty()) {
            int i;
            for (i = indexBefore + 2; i < contentRanges.size() && contentRanges.get(i).isEmpty(); ++i) {
            }
            if (i >= contentRanges.size() ? this.getChompingIndicator() == YAMLBlockScalarImpl.ChompingIndicator.KEEP : YAMLScalarTextImpl.startsWithWhitespace(text, contentRanges.get(i))) {
                return "\n";
            }
            return "";
        }
        return " ";
    }

    @Override
    @NotNull
    public String getTextValue(@Nullable TextRange rangeInHost) {
        Object value = super.getTextValue(rangeInHost);
        if (!StringUtil.isEmptyOrSpaces((String)value) && this.getChompingIndicator() != YAMLBlockScalarImpl.ChompingIndicator.STRIP && this.isEnding(rangeInHost)) {
            value = (String)value + "\n";
        }
        String string = value;
        if (string == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static boolean startsWithWhitespace(@NotNull CharSequence text, @NotNull TextRange range) {
        if (text == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(5);
        }
        if (range == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(6);
        }
        if (range.isEmpty()) {
            return false;
        }
        char c = text.charAt(range.getStartOffset());
        return c == ' ' || c == '\t';
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(7);
        }
        if (!StringUtil.endsWithChar((CharSequence)input, (char)'\n')) {
            throw new IllegalArgumentException("Should end with a line break");
        }
        int indent = this.locateIndent();
        if (indent == 0) {
            indent = YAMLUtil.getIndentToThisElement((PsiElement)this) + 2;
        }
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int currentLength = 0;
        boolean currentLineIsIndented = input.length() > 0 && input.charAt(0) == ' ';
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\n') {
                String replacement = i + 1 >= input.length() || YAMLGrammarCharUtil.isSpaceLike(input.charAt(i + 1)) || input.charAt(i + 1) == '\n' || currentLineIsIndented ? "\n" + indentString : "\n\n" + indentString;
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)replacement));
                currentLength = 0;
                currentLineIsIndented = i + 1 < input.length() && input.charAt(i + 1) == ' ';
                continue;
            }
            if (currentLength > 60 && input.charAt(i) == ' ' && i + 1 < input.length() && YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(i + 1))) {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n" + indentString)));
                currentLength = 0;
                continue;
            }
            ++currentLength;
        }
        return result;
    }

    @Override
    public String toString() {
        return "YAML scalar text";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(8);
        }
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitScalarText(this);
        } else {
            super.accept(visitor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLScalarTextImpl";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRanges";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLScalarTextImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRangesJoiner";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEncodeReplacements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

