/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLTextUtil;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;

public class YAMLElementGenerator {
    private final Project myProject;

    public YAMLElementGenerator(Project project) {
        this.myProject = project;
    }

    public static YAMLElementGenerator getInstance(Project project) {
        return (YAMLElementGenerator)ServiceManager.getService((Project)project, YAMLElementGenerator.class);
    }

    @NotNull
    public static String createChainedKey(@NotNull List<String> keyComponents, int indentAddition) {
        if (keyComponents == null) {
            YAMLElementGenerator.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyComponents.size(); ++i) {
            if (i > 0) {
                sb.append(StringUtil.repeatSymbol((char)' ', (int)(indentAddition + 2 * i)));
            }
            sb.append(keyComponents.get(i)).append(":");
            if (i + 1 >= keyComponents.size()) continue;
            sb.append('\n');
        }
        String string = sb.toString();
        if (string == null) {
            YAMLElementGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public YAMLKeyValue createYamlKeyValue(@NotNull String keyName, @NotNull String valueText) {
        if (keyName == null) {
            YAMLElementGenerator.$$$reportNull$$$0(2);
        }
        if (valueText == null) {
            YAMLElementGenerator.$$$reportNull$$$0(3);
        }
        YAMLFile tempValueFile = this.createDummyYamlWithText(valueText);
        Collection values = PsiTreeUtil.collectElementsOfType((PsiElement)tempValueFile, (Class[])new Class[]{YAMLValue.class});
        String text = !values.isEmpty() && values.iterator().next() instanceof YAMLScalar && !valueText.contains("\n") ? keyName + ": " + valueText : keyName + ":\n" + YAMLTextUtil.indentText(valueText, 2);
        YAMLFile tempFile = this.createDummyYamlWithText(text);
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{YAMLKeyValue.class}).iterator().next();
        if (yAMLKeyValue == null) {
            YAMLElementGenerator.$$$reportNull$$$0(4);
        }
        return yAMLKeyValue;
    }

    @NotNull
    public YAMLQuotedTextImpl createYamlDoubleQuotedString() {
        YAMLFile tempFile = this.createDummyYamlWithText("\"foo\"");
        YAMLQuotedTextImpl yAMLQuotedTextImpl = (YAMLQuotedTextImpl)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{YAMLQuotedTextImpl.class}).iterator().next();
        if (yAMLQuotedTextImpl == null) {
            YAMLElementGenerator.$$$reportNull$$$0(5);
        }
        return yAMLQuotedTextImpl;
    }

    @NotNull
    public YAMLFile createDummyYamlWithText(@NotNull String text) {
        if (text == null) {
            YAMLElementGenerator.$$$reportNull$$$0(6);
        }
        YAMLFile yAMLFile = (YAMLFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("temp." + YAMLFileType.YML.getDefaultExtension(), (FileType)YAMLFileType.YML, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        if (yAMLFile == null) {
            YAMLElementGenerator.$$$reportNull$$$0(7);
        }
        return yAMLFile;
    }

    @NotNull
    public PsiElement createEol() {
        YAMLFile file = this.createDummyYamlWithText("\n");
        PsiElement psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)file);
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createSpace() {
        YAMLKeyValue keyValue = this.createYamlKeyValue("foo", "bar");
        ASTNode whitespaceNode = keyValue.getNode().findChildByType(TokenType.WHITE_SPACE);
        assert (whitespaceNode != null);
        PsiElement psiElement = whitespaceNode.getPsi();
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createIndent(int size) {
        YAMLFile file = this.createDummyYamlWithText(StringUtil.repeatSymbol((char)' ', (int)size));
        PsiElement psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)file);
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createColon() {
        YAMLFile file = this.createDummyYamlWithText("? foo : bar");
        PsiElement at = file.findElementAt("? foo ".length());
        assert (at != null && at.getNode().getElementType() == YAMLTokenTypes.COLON);
        PsiElement psiElement = at;
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement createDocumentMarker() {
        YAMLFile file = this.createDummyYamlWithText("---");
        PsiElement at = file.findElementAt(0);
        assert (at != null && at.getNode().getElementType() == YAMLTokenTypes.DOCUMENT_MARKER);
        PsiElement psiElement = at;
        if (psiElement == null) {
            YAMLElementGenerator.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    @NotNull
    public YAMLSequence createEmptySequence() {
        YAMLSequence sequence = (YAMLSequence)PsiTreeUtil.findChildOfType((PsiElement)this.createDummyYamlWithText("- dummy"), YAMLSequence.class);
        assert (sequence != null);
        sequence.deleteChildRange(sequence.getFirstChild(), sequence.getLastChild());
        YAMLSequence yAMLSequence = sequence;
        if (yAMLSequence == null) {
            YAMLElementGenerator.$$$reportNull$$$0(13);
        }
        return yAMLSequence;
    }

    @NotNull
    public YAMLSequenceItem createEmptySequenceItem() {
        YAMLSequenceItem sequenceItem = (YAMLSequenceItem)PsiTreeUtil.findChildOfType((PsiElement)this.createDummyYamlWithText("- dummy"), YAMLSequenceItem.class);
        assert (sequenceItem != null);
        YAMLValue value = sequenceItem.getValue();
        assert (value != null);
        value.deleteChildRange(value.getFirstChild(), value.getLastChild());
        YAMLSequenceItem yAMLSequenceItem = sequenceItem;
        if (yAMLSequenceItem == null) {
            YAMLElementGenerator.$$$reportNull$$$0(14);
        }
        return yAMLSequenceItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyComponents";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/YAMLElementGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/YAMLElementGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createChainedKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createYamlKeyValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createYamlDoubleQuotedString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyYamlWithText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEol";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpace";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createColon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentMarker";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptySequence";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptySequenceItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createChainedKey";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createYamlKeyValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDummyYamlWithText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

