/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssAlignContent
extends org.w3c.css.properties.css.CssAlignContent {
    public static final CssIdent baseline = CssIdent.getIdent("baseline");
    public static final CssIdent normal = CssIdent.getIdent("normal");
    public static final CssIdent[] baseline_qualifier;
    public static final CssIdent[] content_distribution;
    public static final CssIdent[] overflow_position;
    public static final CssIdent[] content_position;

    public static CssIdent getBaselineQualifier(CssIdent ident) {
        for (CssIdent id : baseline_qualifier) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getContentDistribution(CssIdent ident) {
        for (CssIdent id : content_distribution) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getOverflowPosition(CssIdent ident) {
        for (CssIdent id : overflow_position) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getContentPosition(CssIdent ident) {
        for (CssIdent id : content_position) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssAlignContent() {
        this.value = initial;
    }

    public CssAlignContent(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        this.value = CssAlignContent.parseAlignContent(ac, expression, this);
        if (!expression.end()) {
            throw new InvalidParamException("unrecognize", ac);
        }
    }

    public static CssValue parseAlignContent(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        if (val.getType() == 0) {
            CssIdent ident = (CssIdent)val;
            if (inherit.equals(ident)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                expression.next();
                return inherit;
            }
            if (normal.equals(ident)) {
                expression.next();
                return normal;
            }
            CssIdent value = CssAlignContent.getContentDistribution(ident);
            if (value != null) {
                expression.next();
                return value;
            }
            if (baseline.equals(ident)) {
                expression.next();
                return baseline;
            }
            value = CssAlignContent.getContentPosition(ident);
            if (value != null) {
                expression.next();
                return value;
            }
            value = CssAlignContent.getBaselineQualifier(ident);
            if (value != null) {
                values.add(value);
                if (op != ' ') {
                    throw new InvalidParamException("operator", new Character(op).toString(), ac);
                }
                expression.next();
                if (expression.end()) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                val = expression.getValue();
                if (val.getType() != 0 || !baseline.equals(val)) {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                values.add(baseline);
                expression.next();
                return new CssValueList(values);
            }
            value = CssAlignContent.getOverflowPosition(ident);
            if (value != null) {
                values.add(value);
                if (op != ' ') {
                    throw new InvalidParamException("operator", new Character(op).toString(), ac);
                }
                expression.next();
                if (expression.end()) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                val = expression.getValue();
                if (val.getType() != 0) {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                value = CssAlignContent.getContentPosition((CssIdent)val);
                if (value == null) {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                values.add(value);
                expression.next();
                return new CssValueList(values);
            }
        }
        throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
    }

    public CssAlignContent(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _baseline_qualifier_values = new String[]{"first", "last"};
        baseline_qualifier = new CssIdent[_baseline_qualifier_values.length];
        int i = 0;
        for (String s : _baseline_qualifier_values) {
            CssAlignContent.baseline_qualifier[i++] = CssIdent.getIdent(s);
        }
        i = 0;
        String[] _content_distribution_values = new String[]{"space-between", "space-around", "space-evenly", "stretch"};
        content_distribution = new CssIdent[_content_distribution_values.length];
        for (String s : _content_distribution_values) {
            CssAlignContent.content_distribution[i++] = CssIdent.getIdent(s);
        }
        i = 0;
        String[] _overflow_position_values = new String[]{"unsafe", "safe"};
        overflow_position = new CssIdent[_overflow_position_values.length];
        for (String s : _overflow_position_values) {
            CssAlignContent.overflow_position[i++] = CssIdent.getIdent(s);
        }
        i = 0;
        String[] _content_position_values = new String[]{"center", "start", "end", "flex-start", "flex-end"};
        content_position = new CssIdent[_content_position_values.length];
        for (String s : _content_position_values) {
            CssAlignContent.content_position[i++] = CssIdent.getIdent(s);
        }
    }
}

