/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.java;

import com.intellij.docker.java.JavaCommandAdjuster;
import com.intellij.docker.remoteDebug.RemotePortRequest;
import com.intellij.docker.remoteDebug.RemoteServerRequest;
import com.intellij.docker.remoteDebug.RemoteServerRequestAdapterFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.remote.RemoteConfiguration;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaRemoteConfigurationAdapter
extends RemoteServerRequestAdapterFactory {
    private final JavaCommandAdjuster myCommandAdjuster = new JavaCommandAdjuster();

    private JavaRemoteConfigurationAdapter() {
        super(RemoteConfiguration.class);
    }

    @Nullable
    public RemoteServerRequest createAdapter() {
        RemoteServerRequest.Builder builder = new RemoteServerRequest.Builder();
        builder.withMainPortMapping("Java debugger port");
        return builder.build();
    }

    @Nullable
    public RemoteServerRequestAdapterFactory.CommandLineAdjuster recognizeCommandLine(@NotNull String commandLine) {
        if (commandLine == null) {
            JavaRemoteConfigurationAdapter.$$$reportNull$$$0(0);
        }
        return this.myCommandAdjuster.canAdjust(commandLine) ? this.myCommandAdjuster : null;
    }

    public void bind(@NotNull RemoteServerRequest adapter, @NotNull RunConfiguration adaptee) {
        if (adapter == null) {
            JavaRemoteConfigurationAdapter.$$$reportNull$$$0(1);
        }
        if (adaptee == null) {
            JavaRemoteConfigurationAdapter.$$$reportNull$$$0(2);
        }
        RemotePortRequest javaDebugPortRequest = adapter.findMainDebugPortRequest();
        assert (javaDebugPortRequest != null);
        assert (adaptee instanceof RemoteConfiguration);
        Integer localPort = JavaRemoteConfigurationAdapter.parsePort((RemoteConfiguration)adaptee);
        javaDebugPortRequest.setLocalPort(Optional.ofNullable(localPort).orElse(-1).intValue());
    }

    private static Integer parsePort(@NotNull RemoteConfiguration runConfig) {
        String portText;
        if (runConfig == null) {
            JavaRemoteConfigurationAdapter.$$$reportNull$$$0(3);
        }
        if ((portText = runConfig.PORT) != null) {
            try {
                return Integer.parseInt(portText);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adaptee";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfig";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/java/JavaRemoteConfigurationAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "recognizeCommandLine";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parsePort";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

