/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.java;

import com.intellij.DynamicBundle;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.java.ConfigurationHelpAreaWrapper;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DockerRemoteDebugExtensionEditor
extends SettingsEditor<DeployToServerRunConfiguration> {
    private JPanel myMainPanel;
    private JTextField myDebugPortTextField;
    private JPanel myHelpAreaPlaceHolder;
    private final ConfigurationHelpAreaWrapper myHelpAreaWrapper;

    DockerRemoteDebugExtensionEditor() {
        this.$$$setupUI$$$();
        assert (DockerCloudType.getInstance().isDebugSupported());
        this.myHelpAreaWrapper = new ConfigurationHelpAreaWrapper();
        this.myHelpAreaPlaceHolder.add((Component)this.myHelpAreaWrapper.getPanel(), "Center");
        this.myDebugPortTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DockerRemoteDebugExtensionEditor.this.updateHelpArea();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/java/DockerRemoteDebugExtensionEditor$1", "textChanged"));
            }
        });
        this.updateHelpArea();
    }

    protected void resetEditorFrom(@NotNull DeployToServerRunConfiguration runConfig) {
        DockerDeploymentConfiguration configuration;
        if (runConfig == null) {
            DockerRemoteDebugExtensionEditor.$$$reportNull$$$0(0);
        }
        if ((configuration = DockerRemoteDebugExtensionEditor.getDockerDeploymentConfiguration(runConfig)) == null) {
            return;
        }
        Integer debugPort = configuration.getDebugPort();
        String debugPortText = debugPort != null ? String.valueOf(debugPort) : "";
        this.myDebugPortTextField.setText(debugPortText);
    }

    protected void applyEditorTo(@NotNull DeployToServerRunConfiguration runConfig) throws ConfigurationException {
        if (runConfig == null) {
            DockerRemoteDebugExtensionEditor.$$$reportNull$$$0(1);
        }
        DockerDeploymentConfiguration configuration = DockerRemoteDebugExtensionEditor.getDockerDeploymentConfiguration(runConfig);
        assert (configuration != null) : "for run config: " + runConfig;
        this.doApplyEditorTo(configuration);
    }

    private void doApplyEditorTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerRemoteDebugExtensionEditor.$$$reportNull$$$0(2);
        }
        configuration.setDebugPort(DockerRemoteDebugExtensionEditor.parsePort(this.myDebugPortTextField.getText()));
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DockerRemoteDebugExtensionEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void updateHelpArea() {
        RemoteConnection connection = new RemoteConnection(true, "", this.myDebugPortTextField.getText(), false);
        this.myHelpAreaWrapper.updateText(connection.getLaunchCommandLine());
    }

    private static Integer parsePort(@Nullable String portText) throws RuntimeConfigurationException {
        if (StringUtil.isEmpty((String)portText)) {
            return null;
        }
        try {
            return Integer.parseInt(portText);
        }
        catch (NumberFormatException e) {
            throw new RuntimeConfigurationException(DockerBundle.message((String)"DockerRemoteDebugExtensionEditor.error.invalid.port.number", (Object[])new Object[0]));
        }
    }

    private static DockerDeploymentConfiguration getDockerDeploymentConfiguration(@NotNull DeployToServerRunConfiguration runConfig) {
        if (runConfig == null) {
            DockerRemoteDebugExtensionEditor.$$$reportNull$$$0(4);
        }
        return (DockerDeploymentConfiguration)runConfig.getDeploymentConfiguration();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/java/DockerRemoteDebugExtensionEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/java/DockerRemoteDebugExtensionEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doApplyEditorTo";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDockerDeploymentConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerRemoteDebugExtensionEditor.class).getString("DockerRemoteDebugExtensionEditor.port.text"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDebugPortTextField = jTextField = new JTextField();
        jTextField.setColumns(0);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.myHelpAreaPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

