/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.jdi;

import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.util.ThreeState;
import com.jetbrains.debugger.jdi.AsyncResultCommand;
import com.jetbrains.debugger.jdi.JdiObject;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.sun.jdi.ArrayReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

public class JdiArray
extends JdiObject {
    public JdiArray(@NotNull ArrayReference objectReference, @NotNull JdiValueManager valueManager) {
        if (objectReference == null) {
            JdiArray.$$$reportNull$$$0(0);
        }
        if (valueManager == null) {
            JdiArray.$$$reportNull$$$0(1);
        }
        super(ValueType.ARRAY, objectReference, valueManager);
    }

    @Override
    protected void initChildManager(@NotNull JdiValueManager valueManager) {
        if (valueManager == null) {
            JdiArray.$$$reportNull$$$0(2);
        }
        this.childrenManager = new VariablesHost<JdiValueManager>(valueManager){

            @NotNull
            protected Promise<List<Variable>> load() {
                AsyncPromise promise = new AsyncPromise();
                ((JdiValueManager)this.valueManager).getManagerThread().schedule((DebuggerCommandImpl)new AsyncResultCommand<List<Variable>>(promise){

                    @Override
                    protected void doAction() throws Exception {
                        List<com.sun.jdi.Value> values = ((ArrayReference)JdiArray.this.objectReference).getValues();
                        ArrayList<VariableImpl> variables = new ArrayList<VariableImpl>(values.size());
                        int size = values.size();
                        for (int i = 0; i < size; ++i) {
                            Value value = ((JdiValueManager)valueManager).createValue(values.get(i));
                            variables.add(new VariableImpl(Integer.toString(i), value, null));
                        }
                        this.updateCacheStamp();
                        this.promise.setResult(variables);
                    }
                });
                AsyncPromise asyncPromise = promise;
                if (asyncPromise == null) {
                    1.$$$reportNull$$$0(0);
                }
                return asyncPromise;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiArray$1", "load"));
            }
        };
    }

    @Override
    @NotNull
    public ArrayReference getReference() {
        ArrayReference arrayReference = (ArrayReference)super.getReference();
        if (arrayReference == null) {
            JdiArray.$$$reportNull$$$0(3);
        }
        return arrayReference;
    }

    @Override
    @NotNull
    public ThreeState hasProperties() {
        ThreeState threeState = this.getReference().length() == 0 ? ThreeState.NO : ThreeState.YES;
        if (threeState == null) {
            JdiArray.$$$reportNull$$$0(4);
        }
        return threeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/debugger/jdi/JdiArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/debugger/jdi/JdiArray";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "hasProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initChildManager";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

