/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.tools.quality;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.run.deploymentAware.PhpRemoteToolCreateDialog;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolByInterpreterDialog<P extends QualityToolConfiguration, S extends P>
extends PhpRemoteToolCreateDialog<P, S, PhpInterpreterComboBox> {
    private final String myToolName;

    public QualityToolByInterpreterDialog(@Nullable Project project, @NotNull List<P> settings, @NotNull String toolName, @NotNull Class<S> type) {
        if (settings == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(0);
        }
        if (toolName == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(1);
        }
        if (type == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(2);
        }
        super(project, settings, type);
        this.myToolName = toolName;
        this.setTitle(PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.new.settings.dialog.title", this.myToolName));
        this.init();
    }

    protected void initComboBox() {
        this.myComboBox = new PhpInterpreterComboBox(this.myProject, PhpRemoteSdkAdditionalData.getRemoteSdkFilter());
        ((PhpInterpreterComboBox)this.myComboBox).reset();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myComboBox);
    }

    @NlsContexts.Label
    protected String getLabelText() {
        return PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.dialog.label", new Object[0]);
    }

    @Nullable
    public String getSelectedInterpreterName() {
        return ((PhpInterpreterComboBox)this.myComboBox).getSelectedItemName();
    }

    @Nullable
    protected String getInterpreterId(@NotNull S configuration) {
        if (configuration == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(3);
        }
        return configuration.getInterpreterId();
    }

    protected boolean canProcessSetting(@NotNull P settings, Class<S> type) {
        if (settings == null) {
            QualityToolByInterpreterDialog.$$$reportNull$$$0(4);
        }
        return type.isInstance(settings);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String selectedInterpreterId;
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)this.myProject);
        PhpSdkAdditionalData data = manager.findInterpreterDataById(selectedInterpreterId = manager.findInterpreterId(((PhpInterpreterComboBox)this.myComboBox).getSelectedItemName()));
        if (!(data instanceof PhpRemoteSdkAdditionalData)) {
            String message = PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.settings.select.server", this.myToolName);
            return new ValidationInfo(message, (JComponent)this.myComboBox);
        }
        for (QualityToolConfiguration configuration : this.mySettings) {
            if (!StringUtil.equals((CharSequence)selectedInterpreterId, (CharSequence)this.getInterpreterId(configuration))) continue;
            String message = PhpRemoteSdkBundle.message("quality.tool.configurable.by.interpreter.settings.already.exist", this.myToolName);
            return new ValidationInfo(message, (JComponent)this.myComboBox);
        }
        return super.doValidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/tools/quality/QualityToolByInterpreterDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInterpreterId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessSetting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

