/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.phpunit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="phpunit_by_interpreter")
public class PhpUnitByInterpreterSettings
extends PhpUnitSettings
implements PhpSdkDependentConfiguration {
    @NlsSafe
    private String myInterpreterId;
    private String myInterpreterName;

    @Attribute(value="interpreter_id")
    @Nullable
    public String getInterpreterId() {
        return this.myInterpreterId;
    }

    public void setInterpreterId(@NotNull String interpreterId) {
        if (interpreterId == null) {
            PhpUnitByInterpreterSettings.$$$reportNull$$$0(0);
        }
        this.myInterpreterId = interpreterId;
    }

    @Attribute(value="interpreter_name")
    @Nullable
    public String getInterpreterName() {
        return this.myInterpreterName;
    }

    public void setInterpreterName(String interpreterName) {
        this.myInterpreterName = interpreterName;
    }

    @Nullable
    public String getInterpreterName(@Nullable Project project) {
        return PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterName(this.getInterpreterId(project));
    }

    public String getInterpreterId(@Nullable Project project) {
        if (StringUtil.isEmpty((String)this.myInterpreterId)) {
            this.myInterpreterId = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterId(this.myInterpreterName);
        }
        return this.myInterpreterId;
    }

    @NotNull
    @Nls
    public String getPresentableName(@Nullable Project project) {
        String name = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterName(this.getInterpreterId(project));
        String string = name == null ? PhpRemoteSdkBundle.message("label.undefined.interpreter", new Object[0]) : PhpRemoteSdkBundle.message("label.interpreter", name);
        if (string == null) {
            PhpUnitByInterpreterSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Transient
    public boolean isProjectLevel() {
        return PhpInterpretersManagerImpl.getInstance(null).findInterpreterById(this.getInterpreterId(null)) == null;
    }

    @NotNull
    @Nls
    public String getId() {
        String string = PhpRemoteSdkBundle.message("interpreter", new Object[0]) + "-" + this.myInterpreterId;
        if (string == null) {
            PhpUnitByInterpreterSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public PhpUnitSettings copyWithSettingsSource(@Nullable Project project) {
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)project);
        PhpInterpreter interpreter = manager.findInterpreterById(this.getInterpreterId(project));
        if (interpreter == null) {
            return null;
        }
        PhpInterpreter projectLevel = interpreter.clone();
        projectLevel.setId(PhpInterpreter.getNextId());
        projectLevel.setIsProjectLevel(true);
        projectLevel.setName(manager.getUniqueName(interpreter.getName() + " (project level)"));
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance((Project)project).getPhpInfo(interpreter.getName());
        if (info != null) {
            PhpInterpretersPhpInfoCacheImpl.getInstance((Project)project).setPhpInfo(projectLevel.getName(), info);
        }
        manager.addInterpreter(projectLevel);
        PhpUnitByInterpreterSettings phpunitCopy = this.copy();
        phpunitCopy.setInterpreterId(projectLevel.getId());
        return phpunitCopy;
    }

    @NotNull
    public PhpUnitByInterpreterSettings copy() {
        PhpUnitByInterpreterSettings settings = new PhpUnitByInterpreterSettings();
        settings.myInterpreterName = this.myInterpreterName;
        settings.myInterpreterId = this.myInterpreterId;
        this.copyTo(settings);
        PhpUnitByInterpreterSettings phpUnitByInterpreterSettings = settings;
        if (phpUnitByInterpreterSettings == null) {
            PhpUnitByInterpreterSettings.$$$reportNull$$$0(3);
        }
        return phpUnitByInterpreterSettings;
    }

    protected String serialize(@Nullable String path) {
        return path;
    }

    protected String deserialize(@Nullable String path) {
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/phpunit/PhpUnitByInterpreterSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/phpunit/PhpUnitByInterpreterSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

