/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.interpreter.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.messages.Topic;
import com.jetbrains.php.config.PhpInterpreterBasedConfig;
import com.jetbrains.php.config.PhpInterpreterConfigurationForm;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpProjectConfigComponentProvider;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class PhpRemoteInterpreterConfigurationForm
extends PhpInterpreterConfigurationForm {
    private static final Logger LOG = Logger.getInstance(PhpRemoteInterpreterConfigurationForm.class);
    private final List<PhpProjectConfigComponentProvider.PhpProjectConfigComponent> myConfigComponents;

    public static void fireChanges(@NotNull Project project) {
        if (project == null) {
            PhpRemoteInterpreterConfigurationForm.$$$reportNull$$$0(0);
        }
        ((PhpRemoteInterpreterChangedListener)project.getMessageBus().syncPublisher(PhpRemoteInterpreterChangedListener.TOPIC)).configChanged();
    }

    public PhpRemoteInterpreterConfigurationForm(final @NotNull Project project, @NotNull PhpInterpreterBasedConfig config) {
        if (project == null) {
            PhpRemoteInterpreterConfigurationForm.$$$reportNull$$$0(1);
        }
        if (config == null) {
            PhpRemoteInterpreterConfigurationForm.$$$reportNull$$$0(2);
        }
        super(project, config);
        PhpProjectConfigComponentProvider[] providers = PhpProjectConfigComponentProvider.getInstances();
        this.myConfigComponents = new ArrayList<PhpProjectConfigComponentProvider.PhpProjectConfigComponent>(providers.length);
        if (providers.length > 0) {
            for (PhpProjectConfigComponentProvider provider : providers) {
                this.myConfigComponents.add(provider.create(this.myProject));
            }
        }
        this.myCustomizablePanel.setVisible(false);
        this.myInterpreterComboBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpRemoteInterpreterConfigurationForm.this.onInterpreterChange();
            }
        });
        PhpProjectConfigComponentProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<PhpProjectConfigComponentProvider>(){

            public void extensionAdded(@NotNull PhpProjectConfigComponentProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                PhpRemoteInterpreterConfigurationForm.this.myConfigComponents.add(extension.create(project));
                PhpRemoteInterpreterConfigurationForm.this.onInterpreterChange();
            }

            public void extensionRemoved(@NotNull PhpProjectConfigComponentProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                ArrayList<PhpProjectConfigComponentProvider.PhpProjectConfigComponent> toRemove = new ArrayList<PhpProjectConfigComponentProvider.PhpProjectConfigComponent>();
                for (PhpProjectConfigComponentProvider.PhpProjectConfigComponent component : PhpRemoteInterpreterConfigurationForm.this.myConfigComponents) {
                    if (!extension.isChildComponent(component)) continue;
                    component.disposeUI();
                    toRemove.add(component);
                }
                PhpRemoteInterpreterConfigurationForm.this.myConfigComponents.removeAll(toRemove);
                PhpRemoteInterpreterConfigurationForm.this.onInterpreterChange();
                if (LOG.isTraceEnabled()) {
                    String extensionName = extension.getClass().getSimpleName();
                    LOG.trace("On unloading '" + extensionName + "' disposed " + toRemove.size() + " PHP interpreter components");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/remote/interpreter/ui/PhpRemoteInterpreterConfigurationForm$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    protected void onInterpreterChange() {
        PhpSdkAdditionalData sdkData = this.findSelectedInterpreterData();
        boolean isRemote = sdkData instanceof PhpRemoteSdkAdditionalData;
        if (isRemote) {
            int count;
            PhpRemoteSdkAdditionalData data = (PhpRemoteSdkAdditionalData)sdkData;
            String interpreterId = PhpInterpretersManagerImpl.getInstance((Project)this.myProject).findInterpreterId(this.getInterpreterName());
            int n = count = StringUtil.isEmpty((String)interpreterId) ? 0 : this.validComponents(data);
            if (count > 0) {
                this.showCustomizablePanel(false);
                this.myCustomizablePanel.removeAll();
                GridLayoutManager layoutManager = new GridLayoutManager(count, 2);
                this.myCustomizablePanel.setLayout((LayoutManager)layoutManager);
                GridConstraints gc = new GridConstraints();
                gc.setUseParentLayout(true);
                gc.setRow(0);
                gc.setColumn(0);
                gc.setColSpan(2);
                gc.setFill(3);
                gc.setVSizePolicy(1);
                for (PhpProjectConfigComponentProvider.PhpProjectConfigComponent component : this.myConfigComponents) {
                    if (!component.isAvailable(data)) continue;
                    component.onInterpreterChange(interpreterId, data);
                    this.myCustomizablePanel.add((Component)component.getMainPanel(), gc);
                    gc.setRow(gc.getRow() + 1);
                }
                this.myCustomizablePanel.invalidate();
            } else {
                LOG.debug("Can not find selected interpreter '" + this.getInterpreterName() + "'");
            }
            this.showCustomizablePanel(count > 0);
        } else {
            this.showCustomizablePanel(false);
        }
    }

    private int validComponents(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterConfigurationForm.$$$reportNull$$$0(3);
        }
        int count = 0;
        for (PhpProjectConfigComponentProvider.PhpProjectConfigComponent component : this.myConfigComponents) {
            if (!component.isAvailable(data)) continue;
            ++count;
        }
        return count;
    }

    public void dispose() {
        super.dispose();
        for (PhpProjectConfigComponentProvider.PhpProjectConfigComponent component : this.myConfigComponents) {
            component.disposeUI();
        }
        this.myCustomizablePanel.removeAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/interpreter/ui/PhpRemoteInterpreterConfigurationForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fireChanges";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "validComponents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface PhpRemoteInterpreterChangedListener {
        public static final Topic<PhpRemoteInterpreterChangedListener> TOPIC = Topic.create((String)"configChanged", PhpRemoteInterpreterChangedListener.class);

        public void configChanged();
    }
}

