/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.interpreter.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ui.RemoteSdkEditorContainer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpConfigurationFileAction;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComponent;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoUtil;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import com.jetbrains.php.remote.PhpRemoteInterpreterManagerImpl;
import com.jetbrains.php.remote.PhpRemoteProcessManager;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpInplaceEditRemoteSdkForm;
import com.jetbrains.php.remote.interpreter.ui.PhpInplaceInterpreterForm;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.ui.ResultMessage;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteInterpreterComponent
extends PhpInterpreterComponent
implements RemoteSdkEditorContainer {
    private static final Logger LOG = Logger.getInstance(PhpRemoteInterpreterComponent.class);
    private final Project myProject;
    private final String myInterpreterId;
    private String myInterpreterName;
    private final PhpInplaceInterpreterForm myInterpreterForm;
    private final String myHelpersPath;
    private final Disposable myDisposable;

    public PhpRemoteInterpreterComponent(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data, @NotNull String interpreterName) {
        if (project == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(1);
        }
        if (interpreterName == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(2);
        }
        super(project, (PhpSdkAdditionalData)data);
        this.myDisposable = new Disposable(){

            public void dispose() {
                if (PhpRemoteInterpreterComponent.this.myInterpreterForm != null) {
                    PhpRemoteInterpreterComponent.this.myInterpreterForm.disposeUI();
                }
            }
        };
        this.myProject = project;
        this.myHelpersPath = data.getHelpersPath();
        this.myInterpreterId = data.getInterpreterId();
        this.myInterpreterForm = this.newSdkForm(this.myProject, data);
        this.init(interpreterName);
    }

    @NotNull
    private PhpInplaceInterpreterForm newSdkForm(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data) {
        PhpInplaceInterpreterForm phpInplaceInterpreterForm;
        if (project == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(3);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(4);
        }
        try {
            phpInplaceInterpreterForm = PhpRemoteProcessManager.getInstance(data).newSdkForm(project, data, this);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            return new PhpInplaceEditRemoteSdkForm(project, this);
        }
        if (phpInplaceInterpreterForm == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(5);
        }
        return phpInplaceInterpreterForm;
    }

    protected void init(@NotNull String interpreterName) {
        if (interpreterName == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(6);
        }
        super.init(interpreterName);
        this.myInterpreterName = interpreterName;
        this.myLastLoadedInfo = PhpInterpretersPhpInfoCacheImpl.getInstance((Project)this.myProject).getPhpInfo(interpreterName);
        this.myLastLoadedNonPersistedInfo = null;
    }

    public JPanel getMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        List<JComponent> components = this.myInterpreterForm.getAllComponents();
        for (JComponent component : components) {
            panel.add(component);
        }
        panel.add(super.getMainPanel());
        return panel;
    }

    @NotNull
    protected ResultMessage reloadPhpInfo() {
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        if (manager == null) {
            return new ResultMessage(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage(), MessageType.ERROR);
        }
        try {
            PhpRemoteSdkAdditionalData data = this.createSdkData();
            Pair info = PhpInfoUtil.getWholePhpInfo((Project)this.myProject, (String)data.getInterpreterPath(), (PhpSdkAdditionalData)data, (List)this.getConfigurationOption(), (JComponent)this.myMainPanel);
            this.myLastLoadedInfo = (PhpInfo)info.getFirst();
            this.myLastLoadedNonPersistedInfo = (PhpNonPersistedInfo)info.getSecond();
            this.resetPhpInfo();
            return new ResultMessage(PhpBundle.message((String)"PhpInterpreterConfigurable.updated.phpinfo", (Object[])new Object[0]), MessageType.INFO);
        }
        catch (Exception e) {
            LOG.warn("Can not update phpinfo", (Throwable)e);
            this.myLastLoadedInfo = null;
            this.myLastLoadedNonPersistedInfo = null;
            this.resetPhpInfo();
            String message = StringUtil.notNullize((String)e.getMessage(), (String)PhpBundle.message((String)"PhpInterpreterConfigurable.can.not.updated.phpinfo", (Object[])new Object[0]));
            return new ResultMessage(message, MessageType.ERROR);
        }
    }

    protected boolean canReloadPhpInfo() {
        return true;
    }

    @Nullable
    protected PhpConfigurationFileAction createOpenFileAction() {
        if (!PhpRemoteInterpreterManagerImpl.supportRemoteBrowseAction(this.createSdkData())) {
            return null;
        }
        return new PhpConfigurationFileAction(OPEN_IN_EDITOR){

            public void run(@Nullable String path) {
                if (StringUtil.isEmpty((String)path)) {
                    return;
                }
                try {
                    PhpRemoteSdkAdditionalData data = PhpRemoteInterpreterComponent.this.createSdkData();
                    RemoteSdkCredentials credentials = data.getRemoteSdkCredentials(PhpRemoteInterpreterComponent.this.myProject, false);
                    if (RemoteSdkUtil.testConnection((Component)PhpRemoteInterpreterComponent.this.myMainPanel, (RemoteSdkCredentials)credentials, (boolean)false)) {
                        new PhpRemoteTransfer(PhpRemoteInterpreterComponent.this.myProject, null, credentials).editRemoteFile(PhpRemoteInterpreterComponent.this.myInterpreterName, path);
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("Can not open remote file by path '" + path + "'", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Can not open remote file by path '" + path + "'", (Throwable)e);
                    this.showErrorDialog(e.getMessage());
                }
            }

            private void showErrorDialog(@Nullable String error) {
                String title = PhpRemoteSdkBundle.message("remote.interpreter.open.remote.file.title", new Object[0]);
                String message = PhpRemoteSdkBundle.message("remote.interpreter.can.not.open.remote.file", error);
                List<JComponent> components = PhpRemoteInterpreterComponent.this.myInterpreterForm.getAllComponents();
                if (components.isEmpty()) {
                    Messages.showErrorDialog((Project)PhpRemoteInterpreterComponent.this.myProject, (String)message, (String)title);
                } else {
                    Messages.showErrorDialog((Component)components.get(0), (String)message, (String)title);
                }
            }
        };
    }

    @Nullable
    protected ProcessOutput executeCommand(@NotNull String title, @NotNull String command) throws ExecutionException {
        if (title == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(7);
        }
        if (command == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(8);
        }
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        assert (manager != null);
        try {
            PhpRemoteSdkAdditionalData remoteData = this.createSdkData();
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{remoteData.getInterpreterPath(), command});
            return manager.getProcessOutput(this.myProject, (PhpSdkAdditionalData)remoteData, commandLine, title, (JComponent)this.myMainPanel);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @NotNull
    private PhpRemoteSdkAdditionalData createSdkData() {
        PhpRemoteSdkAdditionalData remoteData;
        try {
            remoteData = this.myInterpreterForm.createSdkData();
        }
        catch (RemoteSdkException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
        remoteData.setInterpreterId(this.myInterpreterId);
        PhpRemoteSdkAdditionalData phpRemoteSdkAdditionalData = remoteData;
        if (phpRemoteSdkAdditionalData == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(9);
        }
        return phpRemoteSdkAdditionalData;
    }

    @NlsSafe
    protected String getInterpreterPath(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(10);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(11);
        }
        if (interpreter == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(12);
        }
        return data instanceof PhpRemoteSdkAdditionalData ? ((PhpRemoteSdkAdditionalData)data).getInterpreterPath() : "";
    }

    @NlsSafe
    protected String getNewFullInterpreterPath() throws RemoteSdkException {
        return this.myInterpreterForm.createSdkData().getSdkId();
    }

    public void reset(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(13);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(14);
        }
        if (interpreter == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(15);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            this.myInterpreterForm.init((PhpRemoteSdkAdditionalData)data);
        }
        super.reset(name, data, interpreter);
    }

    @NotNull
    @NlsSafe
    protected String getPresentableInterpreterPath(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(16);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(17);
        }
        if (interpreter == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(18);
        }
        String string = StringUtil.notNullize((String)this.getInterpreterPath(name, data, interpreter));
        if (string == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(19);
        }
        return string;
    }

    public void apply(@NotNull PhpInterpreter interpreter) throws RemoteSdkException, ConfigurationException {
        ValidationInfo info;
        if (interpreter == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(20);
        }
        if ((info = this.myInterpreterForm.validateRemoteInterpreter()) != null) {
            throw new ConfigurationException(info.message);
        }
        PhpRemoteSdkAdditionalData data = this.myInterpreterForm.createSdkData();
        data.copyToRemote((PhpRemoteSdkAdditionalData)this.mySdkAdditionalData);
        super.apply(interpreter);
    }

    protected String getInterpreterPath() {
        return this.myPathTextField.getText();
    }

    protected String getHelpersPath() {
        return this.myHelpersPath;
    }

    public boolean getIsProjectLevel() {
        return this.myIsProjectLevel.isSelected();
    }

    public void setIsProjectLevel(boolean value) {
        this.myIsProjectLevel.setSelected(value);
    }

    public void addListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(21);
        }
        this.myIsProjectLevel.addChangeListener(changeListener);
    }

    public boolean isModified(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(22);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(23);
        }
        if (interpreter == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(24);
        }
        if (!this.isSdkSupported(this.mySdkAdditionalData)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)((PhpRemoteSdkAdditionalData)this.mySdkAdditionalData).getInterpreterPath(), (CharSequence)this.getInterpreterPath())) {
            return true;
        }
        try {
            if (!this.mySdkAdditionalData.equals((Object)this.myInterpreterForm.createSdkData())) {
                return true;
            }
        }
        catch (RemoteSdkException e) {
            LOG.debug((Throwable)e);
        }
        return super.isModified(name, data, interpreter);
    }

    protected boolean isSdkSupported(PhpSdkAdditionalData additionalData) {
        return this.myInterpreterForm.isConnectionTypeSupported(((PhpRemoteSdkAdditionalData)additionalData).getRemoteConnectionType());
    }

    protected void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myInterpreterForm.setEnabled(enabled);
    }

    public void disposeUIResources() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
        super.disposeUIResources();
    }

    public void updateSize() {
    }

    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(25);
        }
        return disposable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 19: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 19: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 14: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 5: 
            case 9: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/interpreter/ui/PhpRemoteInterpreterComponent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/interpreter/ui/PhpRemoteInterpreterComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newSdkForm";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdkData";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableInterpreterPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newSdkForm";
                break;
            }
            case 5: 
            case 9: 
            case 19: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPath";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableInterpreterPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 19: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

